package org.cloudfoundry.operations.routes;

import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the list routes operation
 */
@Generated(from = "_ListRoutesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListRoutesRequest extends org.cloudfoundry.operations.routes._ListRoutesRequest {
  private final @Nullable Level level;

  private ListRoutesRequest(ListRoutesRequest.Builder builder) {
    this.level = builder.level;
  }

  /**
   * A level to indicate which routes to list
   */
  @Override
  public @Nullable Level getLevel() {
    return level;
  }

  /**
   * This instance is equal to all instances of {@code ListRoutesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListRoutesRequest
        && equalTo(0, (ListRoutesRequest) another);
  }

  private boolean equalTo(int synthetic, ListRoutesRequest another) {
    return Objects.equals(level, another.level);
  }

  /**
   * Computes a hash code from attributes: {@code level}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(level);
    return h;
  }

  /**
   * Prints the immutable value {@code ListRoutesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListRoutesRequest{"
        + "level=" + level
        + "}";
  }

  /**
   * Creates a builder for {@link ListRoutesRequest ListRoutesRequest}.
   * <pre>
   * ListRoutesRequest.builder()
   *    .level(org.cloudfoundry.operations.routes.Level | null) // nullable {@link ListRoutesRequest#getLevel() level}
   *    .build();
   * </pre>
   * @return A new ListRoutesRequest builder
   */
  public static ListRoutesRequest.Builder builder() {
    return new ListRoutesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListRoutesRequest ListRoutesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListRoutesRequest", generator = "Immutables")
  public static final class Builder {
    private Level level;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListRoutesRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListRoutesRequest instance) {
      return from((_ListRoutesRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ListRoutesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListRoutesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Level levelValue = instance.getLevel();
      if (levelValue != null) {
        level(levelValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListRoutesRequest#getLevel() level} attribute.
     * @param level The value for level (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder level(@Nullable Level level) {
      this.level = level;
      return this;
    }

    /**
     * Builds a new {@link ListRoutesRequest ListRoutesRequest}.
     * @return An immutable instance of ListRoutesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListRoutesRequest build() {
      return new ListRoutesRequest(this);
    }
  }
}
