package org.cloudfoundry.operations.networkpolicies;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * A Cloud Foundry Network Policy
 */
@Generated(from = "_Policy", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Policy extends org.cloudfoundry.operations.networkpolicies._Policy {
  private final String destination;
  private final Integer endPort;
  private final String protocol;
  private final String source;
  private final Integer startPort;

  private Policy(Policy.Builder builder) {
    this.destination = builder.destination;
    this.endPort = builder.endPort;
    this.protocol = builder.protocol;
    this.source = builder.source;
    this.startPort = builder.startPort;
  }

  /**
   * The destination
   */
  @Override
  public String getDestination() {
    return destination;
  }

  /**
   * The ending port
   */
  @Override
  public Integer getEndPort() {
    return endPort;
  }

  /**
   * The protocol
   */
  @Override
  public String getProtocol() {
    return protocol;
  }

  /**
   * The source
   */
  @Override
  public String getSource() {
    return source;
  }

  /**
   * The starting port
   */
  @Override
  public Integer getStartPort() {
    return startPort;
  }

  /**
   * This instance is equal to all instances of {@code Policy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Policy
        && equalTo(0, (Policy) another);
  }

  private boolean equalTo(int synthetic, Policy another) {
    return destination.equals(another.destination)
        && endPort.equals(another.endPort)
        && protocol.equals(another.protocol)
        && source.equals(another.source)
        && startPort.equals(another.startPort);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code endPort}, {@code protocol}, {@code source}, {@code startPort}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + endPort.hashCode();
    h += (h << 5) + protocol.hashCode();
    h += (h << 5) + source.hashCode();
    h += (h << 5) + startPort.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Policy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Policy{"
        + "destination=" + destination
        + ", endPort=" + endPort
        + ", protocol=" + protocol
        + ", source=" + source
        + ", startPort=" + startPort
        + "}";
  }

  /**
   * Creates a builder for {@link Policy Policy}.
   * <pre>
   * Policy.builder()
   *    .destination(String) // required {@link Policy#getDestination() destination}
   *    .endPort(Integer) // required {@link Policy#getEndPort() endPort}
   *    .protocol(String) // required {@link Policy#getProtocol() protocol}
   *    .source(String) // required {@link Policy#getSource() source}
   *    .startPort(Integer) // required {@link Policy#getStartPort() startPort}
   *    .build();
   * </pre>
   * @return A new Policy builder
   */
  public static Policy.Builder builder() {
    return new Policy.Builder();
  }

  /**
   * Builds instances of type {@link Policy Policy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Policy", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DESTINATION = 0x1L;
    private static final long INIT_BIT_END_PORT = 0x2L;
    private static final long INIT_BIT_PROTOCOL = 0x4L;
    private static final long INIT_BIT_SOURCE = 0x8L;
    private static final long INIT_BIT_START_PORT = 0x10L;
    private long initBits = 0x1fL;

    private String destination;
    private Integer endPort;
    private String protocol;
    private String source;
    private Integer startPort;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Policy} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Policy instance) {
      return from((_Policy) instance);
    }

    /**
     * Copy abstract value type {@code _Policy} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Policy instance) {
      Objects.requireNonNull(instance, "instance");
      this.destination(instance.getDestination());
      this.endPort(instance.getEndPort());
      this.protocol(instance.getProtocol());
      this.source(instance.getSource());
      this.startPort(instance.getStartPort());
      return this;
    }

    /**
     * Initializes the value for the {@link Policy#getDestination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destination(String destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link Policy#getEndPort() endPort} attribute.
     * @param endPort The value for endPort 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder endPort(Integer endPort) {
      this.endPort = Objects.requireNonNull(endPort, "endPort");
      initBits &= ~INIT_BIT_END_PORT;
      return this;
    }

    /**
     * Initializes the value for the {@link Policy#getProtocol() protocol} attribute.
     * @param protocol The value for protocol 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder protocol(String protocol) {
      this.protocol = Objects.requireNonNull(protocol, "protocol");
      initBits &= ~INIT_BIT_PROTOCOL;
      return this;
    }

    /**
     * Initializes the value for the {@link Policy#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder source(String source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link Policy#getStartPort() startPort} attribute.
     * @param startPort The value for startPort 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startPort(Integer startPort) {
      this.startPort = Objects.requireNonNull(startPort, "startPort");
      initBits &= ~INIT_BIT_START_PORT;
      return this;
    }

    /**
     * Builds a new {@link Policy Policy}.
     * @return An immutable instance of Policy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Policy build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Policy(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      if ((initBits & INIT_BIT_END_PORT) != 0) attributes.add("endPort");
      if ((initBits & INIT_BIT_PROTOCOL) != 0) attributes.add("protocol");
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_START_PORT) != 0) attributes.add("startPort");
      return "Cannot build Policy, some of required attributes are not set " + attributes;
    }
  }
}
