package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Domain object representation
 */
@Generated(from = "_DomainSummary", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DomainSummary extends org.cloudfoundry.operations.applications._DomainSummary {
  private final String id;
  private final String name;
  private final @Nullable String type;

  private DomainSummary(DomainSummary.Builder builder) {
    this.id = builder.id;
    this.name = builder.name;
    this.type = builder.type;
  }

  /**
   * The id of the domain
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The name of the domain
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The type of the domain
   */
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code DomainSummary} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DomainSummary
        && equalTo(0, (DomainSummary) another);
  }

  private boolean equalTo(int synthetic, DomainSummary another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code DomainSummary} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DomainSummary{"
        + "id=" + id
        + ", name=" + name
        + ", type=" + type
        + "}";
  }

  /**
   * Creates a builder for {@link DomainSummary DomainSummary}.
   * <pre>
   * DomainSummary.builder()
   *    .id(String) // required {@link DomainSummary#getId() id}
   *    .name(String) // required {@link DomainSummary#getName() name}
   *    .type(String | null) // nullable {@link DomainSummary#getType() type}
   *    .build();
   * </pre>
   * @return A new DomainSummary builder
   */
  public static DomainSummary.Builder builder() {
    return new DomainSummary.Builder();
  }

  /**
   * Builds instances of type {@link DomainSummary DomainSummary}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DomainSummary", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private long initBits = 0x3L;

    private String id;
    private String name;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DomainSummary} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DomainSummary instance) {
      return from((_DomainSummary) instance);
    }

    /**
     * Copy abstract value type {@code _DomainSummary} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DomainSummary instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      this.name(instance.getName());
      String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DomainSummary#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DomainSummary#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DomainSummary#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Builds a new {@link DomainSummary DomainSummary}.
     * @return An immutable instance of DomainSummary
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DomainSummary build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DomainSummary(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build DomainSummary, some of required attributes are not set " + attributes;
    }
  }
}
