package org.cloudfoundry.operations.applications;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the copy source application operation
 */
@Generated(from = "_CopySourceApplicationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CopySourceApplicationRequest
    extends org.cloudfoundry.operations.applications._CopySourceApplicationRequest {
  private final String name;
  private final @Nullable Boolean restart;
  private final Duration stagingTimeout;
  private final Duration startupTimeout;
  private final String targetName;
  private final @Nullable String targetOrganization;
  private final @Nullable String targetSpace;

  private CopySourceApplicationRequest(CopySourceApplicationRequest.Builder builder) {
    this.name = builder.name;
    this.restart = builder.restart;
    this.targetName = builder.targetName;
    this.targetOrganization = builder.targetOrganization;
    this.targetSpace = builder.targetSpace;
    if (builder.stagingTimeout != null) {
      initShim.stagingTimeout(builder.stagingTimeout);
    }
    if (builder.startupTimeout != null) {
      initShim.startupTimeout(builder.startupTimeout);
    }
    this.stagingTimeout = initShim.getStagingTimeout();
    this.startupTimeout = initShim.getStartupTimeout();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "_CopySourceApplicationRequest", generator = "Immutables")
  private final class InitShim {
    private byte stagingTimeoutBuildStage = STAGE_UNINITIALIZED;
    private Duration stagingTimeout;

    Duration getStagingTimeout() {
      if (stagingTimeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (stagingTimeoutBuildStage == STAGE_UNINITIALIZED) {
        stagingTimeoutBuildStage = STAGE_INITIALIZING;
        this.stagingTimeout = Objects.requireNonNull(CopySourceApplicationRequest.super.getStagingTimeout(), "stagingTimeout");
        stagingTimeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.stagingTimeout;
    }

    void stagingTimeout(Duration stagingTimeout) {
      this.stagingTimeout = stagingTimeout;
      stagingTimeoutBuildStage = STAGE_INITIALIZED;
    }

    private byte startupTimeoutBuildStage = STAGE_UNINITIALIZED;
    private Duration startupTimeout;

    Duration getStartupTimeout() {
      if (startupTimeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (startupTimeoutBuildStage == STAGE_UNINITIALIZED) {
        startupTimeoutBuildStage = STAGE_INITIALIZING;
        this.startupTimeout = Objects.requireNonNull(CopySourceApplicationRequest.super.getStartupTimeout(), "startupTimeout");
        startupTimeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.startupTimeout;
    }

    void startupTimeout(Duration startupTimeout) {
      this.startupTimeout = startupTimeout;
      startupTimeoutBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (stagingTimeoutBuildStage == STAGE_INITIALIZING) attributes.add("stagingTimeout");
      if (startupTimeoutBuildStage == STAGE_INITIALIZING) attributes.add("startupTimeout");
      return "Cannot build CopySourceApplicationRequest, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * The name of the application
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * Whether to restart the target application
   */
  @Override
  public @Nullable Boolean getRestart() {
    return restart;
  }

  /**
   * How long to wait for staging
   */
  @Override
  public Duration getStagingTimeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getStagingTimeout()
        : this.stagingTimeout;
  }

  /**
   * How long to wait for startup
   */
  @Override
  public Duration getStartupTimeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getStartupTimeout()
        : this.startupTimeout;
  }

  /**
   * The name of the target application
   */
  @Override
  public String getTargetName() {
    return targetName;
  }

  /**
   * The organization of the target application
   */
  @Override
  public @Nullable String getTargetOrganization() {
    return targetOrganization;
  }

  /**
   * The space of the target application
   */
  @Override
  public @Nullable String getTargetSpace() {
    return targetSpace;
  }

  /**
   * This instance is equal to all instances of {@code CopySourceApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CopySourceApplicationRequest
        && equalTo(0, (CopySourceApplicationRequest) another);
  }

  private boolean equalTo(int synthetic, CopySourceApplicationRequest another) {
    return name.equals(another.name)
        && Objects.equals(restart, another.restart)
        && stagingTimeout.equals(another.stagingTimeout)
        && startupTimeout.equals(another.startupTimeout)
        && targetName.equals(another.targetName)
        && Objects.equals(targetOrganization, another.targetOrganization)
        && Objects.equals(targetSpace, another.targetSpace);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code restart}, {@code stagingTimeout}, {@code startupTimeout}, {@code targetName}, {@code targetOrganization}, {@code targetSpace}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(restart);
    h += (h << 5) + stagingTimeout.hashCode();
    h += (h << 5) + startupTimeout.hashCode();
    h += (h << 5) + targetName.hashCode();
    h += (h << 5) + Objects.hashCode(targetOrganization);
    h += (h << 5) + Objects.hashCode(targetSpace);
    return h;
  }

  /**
   * Prints the immutable value {@code CopySourceApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CopySourceApplicationRequest{"
        + "name=" + name
        + ", restart=" + restart
        + ", stagingTimeout=" + stagingTimeout
        + ", startupTimeout=" + startupTimeout
        + ", targetName=" + targetName
        + ", targetOrganization=" + targetOrganization
        + ", targetSpace=" + targetSpace
        + "}";
  }

  private static CopySourceApplicationRequest validate(CopySourceApplicationRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link CopySourceApplicationRequest CopySourceApplicationRequest}.
   * <pre>
   * CopySourceApplicationRequest.builder()
   *    .name(String) // required {@link CopySourceApplicationRequest#getName() name}
   *    .restart(Boolean | null) // nullable {@link CopySourceApplicationRequest#getRestart() restart}
   *    .stagingTimeout(java.time.Duration) // optional {@link CopySourceApplicationRequest#getStagingTimeout() stagingTimeout}
   *    .startupTimeout(java.time.Duration) // optional {@link CopySourceApplicationRequest#getStartupTimeout() startupTimeout}
   *    .targetName(String) // required {@link CopySourceApplicationRequest#getTargetName() targetName}
   *    .targetOrganization(String | null) // nullable {@link CopySourceApplicationRequest#getTargetOrganization() targetOrganization}
   *    .targetSpace(String | null) // nullable {@link CopySourceApplicationRequest#getTargetSpace() targetSpace}
   *    .build();
   * </pre>
   * @return A new CopySourceApplicationRequest builder
   */
  public static CopySourceApplicationRequest.Builder builder() {
    return new CopySourceApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link CopySourceApplicationRequest CopySourceApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CopySourceApplicationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_TARGET_NAME = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private Boolean restart;
    private Duration stagingTimeout;
    private Duration startupTimeout;
    private String targetName;
    private String targetOrganization;
    private String targetSpace;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CopySourceApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CopySourceApplicationRequest instance) {
      return from((_CopySourceApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CopySourceApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CopySourceApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      Boolean restartValue = instance.getRestart();
      if (restartValue != null) {
        restart(restartValue);
      }
      this.stagingTimeout(instance.getStagingTimeout());
      this.startupTimeout(instance.getStartupTimeout());
      this.targetName(instance.getTargetName());
      String targetOrganizationValue = instance.getTargetOrganization();
      if (targetOrganizationValue != null) {
        targetOrganization(targetOrganizationValue);
      }
      String targetSpaceValue = instance.getTargetSpace();
      if (targetSpaceValue != null) {
        targetSpace(targetSpaceValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CopySourceApplicationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CopySourceApplicationRequest#getRestart() restart} attribute.
     * @param restart The value for restart (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder restart(@Nullable Boolean restart) {
      this.restart = restart;
      return this;
    }

    /**
     * Initializes the value for the {@link CopySourceApplicationRequest#getStagingTimeout() stagingTimeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link CopySourceApplicationRequest#getStagingTimeout() stagingTimeout}.</em>
     * @param stagingTimeout The value for stagingTimeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingTimeout(Duration stagingTimeout) {
      this.stagingTimeout = Objects.requireNonNull(stagingTimeout, "stagingTimeout");
      return this;
    }

    /**
     * Initializes the value for the {@link CopySourceApplicationRequest#getStartupTimeout() startupTimeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link CopySourceApplicationRequest#getStartupTimeout() startupTimeout}.</em>
     * @param startupTimeout The value for startupTimeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startupTimeout(Duration startupTimeout) {
      this.startupTimeout = Objects.requireNonNull(startupTimeout, "startupTimeout");
      return this;
    }

    /**
     * Initializes the value for the {@link CopySourceApplicationRequest#getTargetName() targetName} attribute.
     * @param targetName The value for targetName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder targetName(String targetName) {
      this.targetName = Objects.requireNonNull(targetName, "targetName");
      initBits &= ~INIT_BIT_TARGET_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CopySourceApplicationRequest#getTargetOrganization() targetOrganization} attribute.
     * @param targetOrganization The value for targetOrganization (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder targetOrganization(@Nullable String targetOrganization) {
      this.targetOrganization = targetOrganization;
      return this;
    }

    /**
     * Initializes the value for the {@link CopySourceApplicationRequest#getTargetSpace() targetSpace} attribute.
     * @param targetSpace The value for targetSpace (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder targetSpace(@Nullable String targetSpace) {
      this.targetSpace = targetSpace;
      return this;
    }

    /**
     * Builds a new {@link CopySourceApplicationRequest CopySourceApplicationRequest}.
     * @return An immutable instance of CopySourceApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CopySourceApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return CopySourceApplicationRequest.validate(new CopySourceApplicationRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TARGET_NAME) != 0) attributes.add("targetName");
      return "Cannot build CopySourceApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
