package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Represents an application log.
 */
@Generated(from = "_ApplicationLog", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ApplicationLog extends org.cloudfoundry.operations.applications._ApplicationLog {
  private final String sourceId;
  private final String instanceId;
  private final String sourceType;
  private final String message;
  private final ApplicationLogType logType;
  private final Long timestamp;

  private ApplicationLog(ApplicationLog.Builder builder) {
    this.sourceId = builder.sourceId;
    this.instanceId = builder.instanceId;
    this.sourceType = builder.sourceType;
    this.message = builder.message;
    this.logType = builder.logType;
    this.timestamp = builder.timestamp;
  }

  /**
   * @return The value of the {@code sourceId} attribute
   */
  @Override
  public String getSourceId() {
    return sourceId;
  }

  /**
   * @return The value of the {@code instanceId} attribute
   */
  @Override
  public String getInstanceId() {
    return instanceId;
  }

  /**
   * @return The value of the {@code sourceType} attribute
   */
  @Override
  public String getSourceType() {
    return sourceType;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @Override
  public String getMessage() {
    return message;
  }

  /**
   * @return The value of the {@code logType} attribute
   */
  @Override
  public ApplicationLogType getLogType() {
    return logType;
  }

  /**
   * @return The value of the {@code timestamp} attribute
   */
  @Override
  public Long getTimestamp() {
    return timestamp;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationLog} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationLog
        && equalTo(0, (ApplicationLog) another);
  }

  private boolean equalTo(int synthetic, ApplicationLog another) {
    return sourceId.equals(another.sourceId)
        && instanceId.equals(another.instanceId)
        && sourceType.equals(another.sourceType)
        && message.equals(another.message)
        && logType.equals(another.logType)
        && timestamp.equals(another.timestamp);
  }

  /**
   * Computes a hash code from attributes: {@code sourceId}, {@code instanceId}, {@code sourceType}, {@code message}, {@code logType}, {@code timestamp}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + sourceId.hashCode();
    h += (h << 5) + instanceId.hashCode();
    h += (h << 5) + sourceType.hashCode();
    h += (h << 5) + message.hashCode();
    h += (h << 5) + logType.hashCode();
    h += (h << 5) + timestamp.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationLog} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationLog{"
        + "sourceId=" + sourceId
        + ", instanceId=" + instanceId
        + ", sourceType=" + sourceType
        + ", message=" + message
        + ", logType=" + logType
        + ", timestamp=" + timestamp
        + "}";
  }

  /**
   * Creates a builder for {@link ApplicationLog ApplicationLog}.
   * <pre>
   * ApplicationLog.builder()
   *    .sourceId(String) // required {@link ApplicationLog#getSourceId() sourceId}
   *    .instanceId(String) // required {@link ApplicationLog#getInstanceId() instanceId}
   *    .sourceType(String) // required {@link ApplicationLog#getSourceType() sourceType}
   *    .message(String) // required {@link ApplicationLog#getMessage() message}
   *    .logType(org.cloudfoundry.operations.applications.ApplicationLogType) // required {@link ApplicationLog#getLogType() logType}
   *    .timestamp(Long) // required {@link ApplicationLog#getTimestamp() timestamp}
   *    .build();
   * </pre>
   * @return A new ApplicationLog builder
   */
  public static ApplicationLog.Builder builder() {
    return new ApplicationLog.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationLog ApplicationLog}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ApplicationLog", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SOURCE_ID = 0x1L;
    private static final long INIT_BIT_INSTANCE_ID = 0x2L;
    private static final long INIT_BIT_SOURCE_TYPE = 0x4L;
    private static final long INIT_BIT_MESSAGE = 0x8L;
    private static final long INIT_BIT_LOG_TYPE = 0x10L;
    private static final long INIT_BIT_TIMESTAMP = 0x20L;
    private long initBits = 0x3fL;

    private String sourceId;
    private String instanceId;
    private String sourceType;
    private String message;
    private ApplicationLogType logType;
    private Long timestamp;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationLog} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationLog instance) {
      return from((_ApplicationLog) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationLog} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationLog instance) {
      Objects.requireNonNull(instance, "instance");
      this.sourceId(instance.getSourceId());
      this.instanceId(instance.getInstanceId());
      this.sourceType(instance.getSourceType());
      this.message(instance.getMessage());
      this.logType(instance.getLogType());
      this.timestamp(instance.getTimestamp());
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationLog#getSourceId() sourceId} attribute.
     * @param sourceId The value for sourceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourceId(String sourceId) {
      this.sourceId = Objects.requireNonNull(sourceId, "sourceId");
      initBits &= ~INIT_BIT_SOURCE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationLog#getInstanceId() instanceId} attribute.
     * @param instanceId The value for instanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceId(String instanceId) {
      this.instanceId = Objects.requireNonNull(instanceId, "instanceId");
      initBits &= ~INIT_BIT_INSTANCE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationLog#getSourceType() sourceType} attribute.
     * @param sourceType The value for sourceType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourceType(String sourceType) {
      this.sourceType = Objects.requireNonNull(sourceType, "sourceType");
      initBits &= ~INIT_BIT_SOURCE_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationLog#getMessage() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder message(String message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationLog#getLogType() logType} attribute.
     * @param logType The value for logType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder logType(ApplicationLogType logType) {
      this.logType = Objects.requireNonNull(logType, "logType");
      initBits &= ~INIT_BIT_LOG_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationLog#getTimestamp() timestamp} attribute.
     * @param timestamp The value for timestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timestamp(Long timestamp) {
      this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
      initBits &= ~INIT_BIT_TIMESTAMP;
      return this;
    }

    /**
     * Builds a new {@link ApplicationLog ApplicationLog}.
     * @return An immutable instance of ApplicationLog
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationLog build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ApplicationLog(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOURCE_ID) != 0) attributes.add("sourceId");
      if ((initBits & INIT_BIT_INSTANCE_ID) != 0) attributes.add("instanceId");
      if ((initBits & INIT_BIT_SOURCE_TYPE) != 0) attributes.add("sourceType");
      if ((initBits & INIT_BIT_MESSAGE) != 0) attributes.add("message");
      if ((initBits & INIT_BIT_LOG_TYPE) != 0) attributes.add("logType");
      if ((initBits & INIT_BIT_TIMESTAMP) != 0) attributes.add("timestamp");
      return "Cannot build ApplicationLog, some of required attributes are not set " + attributes;
    }
  }
}
