package org.cloudfoundry.operations.applications;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * An environment of an application
 */
@Generated(from = "_ApplicationEnvironments", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ApplicationEnvironments
    extends org.cloudfoundry.operations.applications._ApplicationEnvironments {
  private final Map<String, Object> running;
  private final Map<String, Object> staging;
  private final Map<String, Object> systemProvided;
  private final Map<String, Object> userProvided;

  private ApplicationEnvironments(ApplicationEnvironments.Builder builder) {
    this.running = createUnmodifiableMap(false, false, builder.running);
    this.staging = createUnmodifiableMap(false, false, builder.staging);
    this.systemProvided = createUnmodifiableMap(false, false, builder.systemProvided);
    this.userProvided = createUnmodifiableMap(false, false, builder.userProvided);
  }

  /**
   * The running environment variables
   */
  @Override
  public Map<String, Object> getRunning() {
    return running;
  }

  /**
   * The staging environment variables
   */
  @Override
  public Map<String, Object> getStaging() {
    return staging;
  }

  /**
   * The system provided environment variables
   */
  @Override
  public Map<String, Object> getSystemProvided() {
    return systemProvided;
  }

  /**
   * The user defined environment variables
   */
  @Override
  public Map<String, Object> getUserProvided() {
    return userProvided;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationEnvironments} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationEnvironments
        && equalTo(0, (ApplicationEnvironments) another);
  }

  private boolean equalTo(int synthetic, ApplicationEnvironments another) {
    return running.equals(another.running)
        && staging.equals(another.staging)
        && systemProvided.equals(another.systemProvided)
        && userProvided.equals(another.userProvided);
  }

  /**
   * Computes a hash code from attributes: {@code running}, {@code staging}, {@code systemProvided}, {@code userProvided}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + running.hashCode();
    h += (h << 5) + staging.hashCode();
    h += (h << 5) + systemProvided.hashCode();
    h += (h << 5) + userProvided.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationEnvironments} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationEnvironments{"
        + "running=" + running
        + ", staging=" + staging
        + ", systemProvided=" + systemProvided
        + ", userProvided=" + userProvided
        + "}";
  }

  /**
   * Creates a builder for {@link ApplicationEnvironments ApplicationEnvironments}.
   * <pre>
   * ApplicationEnvironments.builder()
   *    .running|putAllRunning(String =&gt; Object) // {@link ApplicationEnvironments#getRunning() running} mappings
   *    .staging|putAllStaging(String =&gt; Object) // {@link ApplicationEnvironments#getStaging() staging} mappings
   *    .systemProvided|putAllSystemProvided(String =&gt; Object) // {@link ApplicationEnvironments#getSystemProvided() systemProvided} mappings
   *    .userProvided|putAllUserProvided(String =&gt; Object) // {@link ApplicationEnvironments#getUserProvided() userProvided} mappings
   *    .build();
   * </pre>
   * @return A new ApplicationEnvironments builder
   */
  public static ApplicationEnvironments.Builder builder() {
    return new ApplicationEnvironments.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationEnvironments ApplicationEnvironments}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ApplicationEnvironments", generator = "Immutables")
  public static final class Builder {
    private Map<String, Object> running = new LinkedHashMap<String, Object>();
    private Map<String, Object> staging = new LinkedHashMap<String, Object>();
    private Map<String, Object> systemProvided = new LinkedHashMap<String, Object>();
    private Map<String, Object> userProvided = new LinkedHashMap<String, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationEnvironments} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationEnvironments instance) {
      return from((_ApplicationEnvironments) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationEnvironments} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationEnvironments instance) {
      Objects.requireNonNull(instance, "instance");
      putAllRunning(instance.getRunning());
      putAllStaging(instance.getStaging());
      putAllSystemProvided(instance.getSystemProvided());
      putAllUserProvided(instance.getUserProvided());
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironments#getRunning() running} map.
     * @param key The key in the running map
     * @param value The associated value in the running map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder running(String key, Object value) {
      this.running.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironments#getRunning() running} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder running(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.running.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ApplicationEnvironments#getRunning() running} map. Nulls are not permitted
     * @param entries The entries that will be added to the running map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder running(Map<String, ? extends Object> entries) {
      this.running.clear();
      return putAllRunning(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ApplicationEnvironments#getRunning() running} map. Nulls are not permitted
     * @param entries The entries that will be added to the running map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllRunning(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.running.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironments#getStaging() staging} map.
     * @param key The key in the staging map
     * @param value The associated value in the staging map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder staging(String key, Object value) {
      this.staging.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironments#getStaging() staging} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder staging(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.staging.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ApplicationEnvironments#getStaging() staging} map. Nulls are not permitted
     * @param entries The entries that will be added to the staging map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder staging(Map<String, ? extends Object> entries) {
      this.staging.clear();
      return putAllStaging(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ApplicationEnvironments#getStaging() staging} map. Nulls are not permitted
     * @param entries The entries that will be added to the staging map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllStaging(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.staging.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironments#getSystemProvided() systemProvided} map.
     * @param key The key in the systemProvided map
     * @param value The associated value in the systemProvided map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder systemProvided(String key, Object value) {
      this.systemProvided.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironments#getSystemProvided() systemProvided} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder systemProvided(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.systemProvided.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ApplicationEnvironments#getSystemProvided() systemProvided} map. Nulls are not permitted
     * @param entries The entries that will be added to the systemProvided map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder systemProvided(Map<String, ? extends Object> entries) {
      this.systemProvided.clear();
      return putAllSystemProvided(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ApplicationEnvironments#getSystemProvided() systemProvided} map. Nulls are not permitted
     * @param entries The entries that will be added to the systemProvided map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllSystemProvided(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.systemProvided.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironments#getUserProvided() userProvided} map.
     * @param key The key in the userProvided map
     * @param value The associated value in the userProvided map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userProvided(String key, Object value) {
      this.userProvided.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironments#getUserProvided() userProvided} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userProvided(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.userProvided.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ApplicationEnvironments#getUserProvided() userProvided} map. Nulls are not permitted
     * @param entries The entries that will be added to the userProvided map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userProvided(Map<String, ? extends Object> entries) {
      this.userProvided.clear();
      return putAllUserProvided(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ApplicationEnvironments#getUserProvided() userProvided} map. Nulls are not permitted
     * @param entries The entries that will be added to the userProvided map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllUserProvided(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.userProvided.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link ApplicationEnvironments ApplicationEnvironments}.
     * @return An immutable instance of ApplicationEnvironments
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationEnvironments build() {
      return new ApplicationEnvironments(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
