/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.AllowNulls;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications.Docker;
import org.cloudfoundry.operations.applications.Route;
import org.immutables.value.Value;

abstract class _ApplicationManifestCommon {
    _ApplicationManifestCommon() {
    }

    @Value.Check
    void check() {
        if (this.getRoutes() != null) {
            if (this.getHosts() != null) {
                throw new IllegalStateException("routes and hosts cannot both be set");
            }
            if (this.getDomains() != null) {
                throw new IllegalStateException("routes and domains cannot both be set");
            }
            if (this.getNoHostname() != null) {
                throw new IllegalStateException("routes and noHostname cannot both be set");
            }
        }
        if (this.getDocker() != null) {
            if (this.getDocker().getImage() != null && this.getBuildpacks() != null && !this.getBuildpacks().isEmpty()) {
                throw new IllegalStateException("docker image and buildpack cannot both be set");
            }
            if (this.getDocker().getImage() != null && this.getPath() != null) {
                throw new IllegalStateException("docker image and path cannot both be set");
            }
            if (this.getDocker().getImage() == null && (this.getDocker().getUsername() != null || this.getDocker().getPassword() != null)) {
                throw new IllegalStateException("docker credentials require docker image to be set");
            }
            if (this.getDocker().getPassword() != null && this.getDocker().getUsername() == null) {
                throw new IllegalStateException("Docker password requires username");
            }
            if (this.getDocker().getPassword() == null && this.getDocker().getUsername() != null) {
                throw new IllegalStateException("Docker username requires password");
            }
        }
    }

    @Nullable
    abstract List<String> getBuildpacks();

    @Nullable
    abstract String getCommand();

    @Nullable
    abstract Integer getDisk();

    @Nullable
    abstract Docker getDocker();

    @Nullable
    abstract List<String> getDomains();

    @AllowNulls
    @Nullable
    abstract Map<String, Object> getEnvironmentVariables();

    @Nullable
    abstract String getHealthCheckHttpEndpoint();

    @Nullable
    abstract ApplicationHealthCheck getHealthCheckType();

    @Nullable
    abstract List<String> getHosts();

    @Nullable
    abstract Integer getInstances();

    @Nullable
    abstract Integer getMemory();

    abstract String getName();

    @Nullable
    abstract Boolean getNoHostname();

    @Nullable
    abstract Boolean getNoRoute();

    @Nullable
    abstract Path getPath();

    @Nullable
    abstract Boolean getRandomRoute();

    @Nullable
    abstract String getRoutePath();

    @Nullable
    abstract List<Route> getRoutes();

    @Nullable
    abstract String getStack();

    @Nullable
    abstract Integer getTimeout();

    static interface Builder {
        public Builder buildpack(String var1);

        public Builder buildpacks(String ... var1);

        public Builder buildpacks(@Nullable Iterable<String> var1);

        public Builder addAllBuildpacks(Iterable<String> var1);

        public Builder command(@Nullable String var1);

        public Builder disk(@Nullable Integer var1);

        public Builder docker(@Nullable Docker var1);

        public Builder domain(String var1);

        public Builder domains(String ... var1);

        public Builder domains(@Nullable Iterable<String> var1);

        public Builder addAllDomains(Iterable<String> var1);

        public Builder environmentVariable(String var1, Object var2);

        public Builder environmentVariable(Map.Entry<String, ? extends Object> var1);

        public Builder environmentVariables(@Nullable Map<String, ? extends Object> var1);

        public Builder putAllEnvironmentVariables(Map<String, ? extends Object> var1);

        public Builder healthCheckHttpEndpoint(@Nullable String var1);

        public Builder healthCheckType(@Nullable ApplicationHealthCheck var1);

        public Builder host(String var1);

        public Builder hosts(String ... var1);

        public Builder hosts(@Nullable Iterable<String> var1);

        public Builder addAllHosts(Iterable<String> var1);

        public Builder instances(@Nullable Integer var1);

        public Builder memory(@Nullable Integer var1);

        public Builder name(String var1);

        public Builder noHostname(@Nullable Boolean var1);

        public Builder noRoute(@Nullable Boolean var1);

        public Builder path(@Nullable Path var1);

        public Builder randomRoute(@Nullable Boolean var1);

        public Builder routePath(@Nullable String var1);

        public Builder route(Route var1);

        public Builder routes(Route ... var1);

        public Builder routes(@Nullable Iterable<? extends Route> var1);

        public Builder addAllRoutes(Iterable<? extends Route> var1);

        public Builder stack(@Nullable String var1);

        public Builder timeout(@Nullable Integer var1);

        public _ApplicationManifestCommon build();
    }
}

