package org.cloudfoundry.operations.routes;

import java.time.Duration;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request options for the delete orphaned routes operation
 */
@Generated(from = "_DeleteOrphanedRoutesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteOrphanedRoutesRequest
    extends org.cloudfoundry.operations.routes._DeleteOrphanedRoutesRequest {
  private final Duration completionTimeout;

  private DeleteOrphanedRoutesRequest(DeleteOrphanedRoutesRequest.Builder builder) {
    this.completionTimeout = builder.completionTimeout != null
        ? builder.completionTimeout
        : Objects.requireNonNull(super.getCompletionTimeout(), "completionTimeout");
  }

  /**
   * How long to wait for deletion
   */
  @Override
  public Duration getCompletionTimeout() {
    return completionTimeout;
  }

  /**
   * This instance is equal to all instances of {@code DeleteOrphanedRoutesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteOrphanedRoutesRequest
        && equalTo(0, (DeleteOrphanedRoutesRequest) another);
  }

  private boolean equalTo(int synthetic, DeleteOrphanedRoutesRequest another) {
    return completionTimeout.equals(another.completionTimeout);
  }

  /**
   * Computes a hash code from attributes: {@code completionTimeout}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + completionTimeout.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteOrphanedRoutesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteOrphanedRoutesRequest{"
        + "completionTimeout=" + completionTimeout
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteOrphanedRoutesRequest DeleteOrphanedRoutesRequest}.
   * <pre>
   * DeleteOrphanedRoutesRequest.builder()
   *    .completionTimeout(java.time.Duration) // optional {@link DeleteOrphanedRoutesRequest#getCompletionTimeout() completionTimeout}
   *    .build();
   * </pre>
   * @return A new DeleteOrphanedRoutesRequest builder
   */
  public static DeleteOrphanedRoutesRequest.Builder builder() {
    return new DeleteOrphanedRoutesRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteOrphanedRoutesRequest DeleteOrphanedRoutesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteOrphanedRoutesRequest", generator = "Immutables")
  public static final class Builder {
    private Duration completionTimeout;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteOrphanedRoutesRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteOrphanedRoutesRequest instance) {
      return from((_DeleteOrphanedRoutesRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteOrphanedRoutesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteOrphanedRoutesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      completionTimeout(instance.getCompletionTimeout());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteOrphanedRoutesRequest#getCompletionTimeout() completionTimeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DeleteOrphanedRoutesRequest#getCompletionTimeout() completionTimeout}.</em>
     * @param completionTimeout The value for completionTimeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder completionTimeout(Duration completionTimeout) {
      this.completionTimeout = Objects.requireNonNull(completionTimeout, "completionTimeout");
      return this;
    }

    /**
     * Builds a new {@link DeleteOrphanedRoutesRequest DeleteOrphanedRoutesRequest}.
     * @return An immutable instance of DeleteOrphanedRoutesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteOrphanedRoutesRequest build() {
      return new DeleteOrphanedRoutesRequest(this);
    }
  }
}
