package org.cloudfoundry.operations.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * A Cloud Foundry Quota
 */
@Generated(from = "_OrganizationQuota", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class OrganizationQuota extends org.cloudfoundry.operations.organizations._OrganizationQuota {
  private final String id;
  private final Integer instanceMemoryLimit;
  private final String name;
  private final String organizationId;
  private final Boolean paidServicePlans;
  private final Integer totalMemoryLimit;
  private final Integer totalRoutes;
  private final Integer totalServiceInstances;

  private OrganizationQuota(OrganizationQuota.Builder builder) {
    this.id = builder.id;
    this.instanceMemoryLimit = builder.instanceMemoryLimit;
    this.name = builder.name;
    this.organizationId = builder.organizationId;
    this.paidServicePlans = builder.paidServicePlans;
    this.totalMemoryLimit = builder.totalMemoryLimit;
    this.totalRoutes = builder.totalRoutes;
    this.totalServiceInstances = builder.totalServiceInstances;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The instance memory limit
   */
  @Override
  public Integer getInstanceMemoryLimit() {
    return instanceMemoryLimit;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * Whether paid service plans are allowed
   */
  @Override
  public Boolean getPaidServicePlans() {
    return paidServicePlans;
  }

  /**
   * The total memory limit
   */
  @Override
  public Integer getTotalMemoryLimit() {
    return totalMemoryLimit;
  }

  /**
   * The total number of routes
   */
  @Override
  public Integer getTotalRoutes() {
    return totalRoutes;
  }

  /**
   * The total number of service instances
   */
  @Override
  public Integer getTotalServiceInstances() {
    return totalServiceInstances;
  }

  /**
   * This instance is equal to all instances of {@code OrganizationQuota} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OrganizationQuota
        && equalTo(0, (OrganizationQuota) another);
  }

  private boolean equalTo(int synthetic, OrganizationQuota another) {
    return id.equals(another.id)
        && instanceMemoryLimit.equals(another.instanceMemoryLimit)
        && name.equals(another.name)
        && organizationId.equals(another.organizationId)
        && paidServicePlans.equals(another.paidServicePlans)
        && totalMemoryLimit.equals(another.totalMemoryLimit)
        && totalRoutes.equals(another.totalRoutes)
        && totalServiceInstances.equals(another.totalServiceInstances);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code instanceMemoryLimit}, {@code name}, {@code organizationId}, {@code paidServicePlans}, {@code totalMemoryLimit}, {@code totalRoutes}, {@code totalServiceInstances}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + instanceMemoryLimit.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + paidServicePlans.hashCode();
    h += (h << 5) + totalMemoryLimit.hashCode();
    h += (h << 5) + totalRoutes.hashCode();
    h += (h << 5) + totalServiceInstances.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OrganizationQuota} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OrganizationQuota{"
        + "id=" + id
        + ", instanceMemoryLimit=" + instanceMemoryLimit
        + ", name=" + name
        + ", organizationId=" + organizationId
        + ", paidServicePlans=" + paidServicePlans
        + ", totalMemoryLimit=" + totalMemoryLimit
        + ", totalRoutes=" + totalRoutes
        + ", totalServiceInstances=" + totalServiceInstances
        + "}";
  }

  /**
   * Creates a builder for {@link OrganizationQuota OrganizationQuota}.
   * <pre>
   * OrganizationQuota.builder()
   *    .id(String) // required {@link OrganizationQuota#getId() id}
   *    .instanceMemoryLimit(Integer) // required {@link OrganizationQuota#getInstanceMemoryLimit() instanceMemoryLimit}
   *    .name(String) // required {@link OrganizationQuota#getName() name}
   *    .organizationId(String) // required {@link OrganizationQuota#getOrganizationId() organizationId}
   *    .paidServicePlans(Boolean) // required {@link OrganizationQuota#getPaidServicePlans() paidServicePlans}
   *    .totalMemoryLimit(Integer) // required {@link OrganizationQuota#getTotalMemoryLimit() totalMemoryLimit}
   *    .totalRoutes(Integer) // required {@link OrganizationQuota#getTotalRoutes() totalRoutes}
   *    .totalServiceInstances(Integer) // required {@link OrganizationQuota#getTotalServiceInstances() totalServiceInstances}
   *    .build();
   * </pre>
   * @return A new OrganizationQuota builder
   */
  public static OrganizationQuota.Builder builder() {
    return new OrganizationQuota.Builder();
  }

  /**
   * Builds instances of type {@link OrganizationQuota OrganizationQuota}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_OrganizationQuota", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_INSTANCE_MEMORY_LIMIT = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private static final long INIT_BIT_ORGANIZATION_ID = 0x8L;
    private static final long INIT_BIT_PAID_SERVICE_PLANS = 0x10L;
    private static final long INIT_BIT_TOTAL_MEMORY_LIMIT = 0x20L;
    private static final long INIT_BIT_TOTAL_ROUTES = 0x40L;
    private static final long INIT_BIT_TOTAL_SERVICE_INSTANCES = 0x80L;
    private long initBits = 0xffL;

    private String id;
    private Integer instanceMemoryLimit;
    private String name;
    private String organizationId;
    private Boolean paidServicePlans;
    private Integer totalMemoryLimit;
    private Integer totalRoutes;
    private Integer totalServiceInstances;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OrganizationQuota} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OrganizationQuota instance) {
      return from((_OrganizationQuota) instance);
    }

    /**
     * Copy abstract value type {@code _OrganizationQuota} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_OrganizationQuota instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      instanceMemoryLimit(instance.getInstanceMemoryLimit());
      name(instance.getName());
      organizationId(instance.getOrganizationId());
      paidServicePlans(instance.getPaidServicePlans());
      totalMemoryLimit(instance.getTotalMemoryLimit());
      totalRoutes(instance.getTotalRoutes());
      totalServiceInstances(instance.getTotalServiceInstances());
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getInstanceMemoryLimit() instanceMemoryLimit} attribute.
     * @param instanceMemoryLimit The value for instanceMemoryLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceMemoryLimit(Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = Objects.requireNonNull(instanceMemoryLimit, "instanceMemoryLimit");
      initBits &= ~INIT_BIT_INSTANCE_MEMORY_LIMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getPaidServicePlans() paidServicePlans} attribute.
     * @param paidServicePlans The value for paidServicePlans 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder paidServicePlans(Boolean paidServicePlans) {
      this.paidServicePlans = Objects.requireNonNull(paidServicePlans, "paidServicePlans");
      initBits &= ~INIT_BIT_PAID_SERVICE_PLANS;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getTotalMemoryLimit() totalMemoryLimit} attribute.
     * @param totalMemoryLimit The value for totalMemoryLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalMemoryLimit(Integer totalMemoryLimit) {
      this.totalMemoryLimit = Objects.requireNonNull(totalMemoryLimit, "totalMemoryLimit");
      initBits &= ~INIT_BIT_TOTAL_MEMORY_LIMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getTotalRoutes() totalRoutes} attribute.
     * @param totalRoutes The value for totalRoutes 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalRoutes(Integer totalRoutes) {
      this.totalRoutes = Objects.requireNonNull(totalRoutes, "totalRoutes");
      initBits &= ~INIT_BIT_TOTAL_ROUTES;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getTotalServiceInstances() totalServiceInstances} attribute.
     * @param totalServiceInstances The value for totalServiceInstances 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalServiceInstances(Integer totalServiceInstances) {
      this.totalServiceInstances = Objects.requireNonNull(totalServiceInstances, "totalServiceInstances");
      initBits &= ~INIT_BIT_TOTAL_SERVICE_INSTANCES;
      return this;
    }

    /**
     * Builds a new {@link OrganizationQuota OrganizationQuota}.
     * @return An immutable instance of OrganizationQuota
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OrganizationQuota build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new OrganizationQuota(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_INSTANCE_MEMORY_LIMIT) != 0) attributes.add("instanceMemoryLimit");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      if ((initBits & INIT_BIT_PAID_SERVICE_PLANS) != 0) attributes.add("paidServicePlans");
      if ((initBits & INIT_BIT_TOTAL_MEMORY_LIMIT) != 0) attributes.add("totalMemoryLimit");
      if ((initBits & INIT_BIT_TOTAL_ROUTES) != 0) attributes.add("totalRoutes");
      if ((initBits & INIT_BIT_TOTAL_SERVICE_INSTANCES) != 0) attributes.add("totalServiceInstances");
      return "Cannot build OrganizationQuota, some of required attributes are not set " + attributes;
    }
  }
}
