package org.cloudfoundry.operations.organizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.operations.spaceadmin.SpaceQuota;
import org.immutables.value.Generated;

/**
 * A Cloud Foundry Organization
 */
@Generated(from = "_OrganizationDetail", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class OrganizationDetail extends org.cloudfoundry.operations.organizations._OrganizationDetail {
  private final List<String> domains;
  private final String id;
  private final String name;
  private final OrganizationQuota quota;
  private final List<SpaceQuota> spaceQuotas;
  private final List<String> spaces;

  private OrganizationDetail(OrganizationDetail.Builder builder) {
    this.domains = createUnmodifiableList(true, builder.domains);
    this.id = builder.id;
    this.name = builder.name;
    this.quota = builder.quota;
    this.spaceQuotas = createUnmodifiableList(true, builder.spaceQuotas);
    this.spaces = createUnmodifiableList(true, builder.spaces);
  }

  /**
   * The domains bound to this organization
   */
  @Override
  public List<String> getDomains() {
    return domains;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The organization quota
   */
  @Override
  public OrganizationQuota getQuota() {
    return quota;
  }

  /**
   * The space quota of the organizations quota
   */
  @Override
  public List<SpaceQuota> getSpaceQuotas() {
    return spaceQuotas;
  }

  /**
   * The spaces in this organization
   */
  @Override
  public List<String> getSpaces() {
    return spaces;
  }

  /**
   * This instance is equal to all instances of {@code OrganizationDetail} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OrganizationDetail
        && equalTo(0, (OrganizationDetail) another);
  }

  private boolean equalTo(int synthetic, OrganizationDetail another) {
    return domains.equals(another.domains)
        && id.equals(another.id)
        && name.equals(another.name)
        && quota.equals(another.quota)
        && spaceQuotas.equals(another.spaceQuotas)
        && spaces.equals(another.spaces);
  }

  /**
   * Computes a hash code from attributes: {@code domains}, {@code id}, {@code name}, {@code quota}, {@code spaceQuotas}, {@code spaces}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + domains.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + quota.hashCode();
    h += (h << 5) + spaceQuotas.hashCode();
    h += (h << 5) + spaces.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OrganizationDetail} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OrganizationDetail{"
        + "domains=" + domains
        + ", id=" + id
        + ", name=" + name
        + ", quota=" + quota
        + ", spaceQuotas=" + spaceQuotas
        + ", spaces=" + spaces
        + "}";
  }

  /**
   * Creates a builder for {@link OrganizationDetail OrganizationDetail}.
   * <pre>
   * OrganizationDetail.builder()
   *    .domain|addAllDomains(String) // {@link OrganizationDetail#getDomains() domains} elements
   *    .id(String) // required {@link OrganizationDetail#getId() id}
   *    .name(String) // required {@link OrganizationDetail#getName() name}
   *    .quota(org.cloudfoundry.operations.organizations.OrganizationQuota) // required {@link OrganizationDetail#getQuota() quota}
   *    .spaceQuota|addAllSpaceQuotas(org.cloudfoundry.operations.spaceadmin.SpaceQuota) // {@link OrganizationDetail#getSpaceQuotas() spaceQuotas} elements
   *    .space|addAllSpaces(String) // {@link OrganizationDetail#getSpaces() spaces} elements
   *    .build();
   * </pre>
   * @return A new OrganizationDetail builder
   */
  public static OrganizationDetail.Builder builder() {
    return new OrganizationDetail.Builder();
  }

  /**
   * Builds instances of type {@link OrganizationDetail OrganizationDetail}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_OrganizationDetail", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_QUOTA = 0x4L;
    private long initBits = 0x7L;

    private List<String> domains = new ArrayList<String>();
    private String id;
    private String name;
    private OrganizationQuota quota;
    private List<SpaceQuota> spaceQuotas = new ArrayList<SpaceQuota>();
    private List<String> spaces = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OrganizationDetail} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OrganizationDetail instance) {
      return from((_OrganizationDetail) instance);
    }

    /**
     * Copy abstract value type {@code _OrganizationDetail} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_OrganizationDetail instance) {
      Objects.requireNonNull(instance, "instance");
      addAllDomains(instance.getDomains());
      id(instance.getId());
      name(instance.getName());
      quota(instance.getQuota());
      addAllSpaceQuotas(instance.getSpaceQuotas());
      addAllSpaces(instance.getSpaces());
      return this;
    }

    /**
     * Adds one element to {@link OrganizationDetail#getDomains() domains} list.
     * @param element A domains element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String element) {
      this.domains.add(Objects.requireNonNull(element, "domains element"));
      return this;
    }

    /**
     * Adds elements to {@link OrganizationDetail#getDomains() domains} list.
     * @param elements An array of domains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domains(String... elements) {
      for (String element : elements) {
        this.domains.add(Objects.requireNonNull(element, "domains element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OrganizationDetail#getDomains() domains} list.
     * @param elements An iterable of domains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domains(Iterable<String> elements) {
      this.domains.clear();
      return addAllDomains(elements);
    }

    /**
     * Adds elements to {@link OrganizationDetail#getDomains() domains} list.
     * @param elements An iterable of domains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDomains(Iterable<String> elements) {
      for (String element : elements) {
        this.domains.add(Objects.requireNonNull(element, "domains element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationDetail#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationDetail#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationDetail#getQuota() quota} attribute.
     * @param quota The value for quota 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder quota(OrganizationQuota quota) {
      this.quota = Objects.requireNonNull(quota, "quota");
      initBits &= ~INIT_BIT_QUOTA;
      return this;
    }

    /**
     * Adds one element to {@link OrganizationDetail#getSpaceQuotas() spaceQuotas} list.
     * @param element A spaceQuotas element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceQuota(SpaceQuota element) {
      this.spaceQuotas.add(Objects.requireNonNull(element, "spaceQuotas element"));
      return this;
    }

    /**
     * Adds elements to {@link OrganizationDetail#getSpaceQuotas() spaceQuotas} list.
     * @param elements An array of spaceQuotas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceQuotas(SpaceQuota... elements) {
      for (SpaceQuota element : elements) {
        this.spaceQuotas.add(Objects.requireNonNull(element, "spaceQuotas element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OrganizationDetail#getSpaceQuotas() spaceQuotas} list.
     * @param elements An iterable of spaceQuotas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceQuotas(Iterable<? extends SpaceQuota> elements) {
      this.spaceQuotas.clear();
      return addAllSpaceQuotas(elements);
    }

    /**
     * Adds elements to {@link OrganizationDetail#getSpaceQuotas() spaceQuotas} list.
     * @param elements An iterable of spaceQuotas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceQuotas(Iterable<? extends SpaceQuota> elements) {
      for (SpaceQuota element : elements) {
        this.spaceQuotas.add(Objects.requireNonNull(element, "spaceQuotas element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link OrganizationDetail#getSpaces() spaces} list.
     * @param element A spaces element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder space(String element) {
      this.spaces.add(Objects.requireNonNull(element, "spaces element"));
      return this;
    }

    /**
     * Adds elements to {@link OrganizationDetail#getSpaces() spaces} list.
     * @param elements An array of spaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaces(String... elements) {
      for (String element : elements) {
        this.spaces.add(Objects.requireNonNull(element, "spaces element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OrganizationDetail#getSpaces() spaces} list.
     * @param elements An iterable of spaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaces(Iterable<String> elements) {
      this.spaces.clear();
      return addAllSpaces(elements);
    }

    /**
     * Adds elements to {@link OrganizationDetail#getSpaces() spaces} list.
     * @param elements An iterable of spaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaces(Iterable<String> elements) {
      for (String element : elements) {
        this.spaces.add(Objects.requireNonNull(element, "spaces element"));
      }
      return this;
    }

    /**
     * Builds a new {@link OrganizationDetail OrganizationDetail}.
     * @return An immutable instance of OrganizationDetail
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OrganizationDetail build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new OrganizationDetail(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_QUOTA) != 0) attributes.add("quota");
      return "Cannot build OrganizationDetail, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
