/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.operations.applications.ManifestV3Application;
import org.cloudfoundry.operations.applications._ManifestV3;
import org.immutables.value.Generated;

@Generated(from="_ManifestV3", generator="Immutables")
public final class ManifestV3
extends _ManifestV3 {
    private final List<ManifestV3Application> applications;
    private final Integer version;

    private ManifestV3(Builder builder) {
        this.applications = ManifestV3.createUnmodifiableList(true, builder.applications);
        this.version = builder.version != null ? builder.version : Objects.requireNonNull(super.getVersion(), "version");
    }

    @Override
    public List<ManifestV3Application> getApplications() {
        return this.applications;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ManifestV3 && this.equalTo(0, (ManifestV3)another);
    }

    private boolean equalTo(int synthetic, ManifestV3 another) {
        return this.applications.equals(another.applications) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applications.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return "ManifestV3{applications=" + this.applications + ", version=" + this.version + "}";
    }

    private static ManifestV3 validate(ManifestV3 instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ManifestV3", generator="Immutables")
    public static final class Builder {
        private List<ManifestV3Application> applications = new ArrayList<ManifestV3Application>();
        private Integer version;

        private Builder() {
        }

        public final Builder from(ManifestV3 instance) {
            return this.from((_ManifestV3)instance);
        }

        final Builder from(_ManifestV3 instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllApplications(instance.getApplications());
            this.version(instance.getVersion());
            return this;
        }

        public final Builder application(ManifestV3Application element) {
            this.applications.add(Objects.requireNonNull(element, "applications element"));
            return this;
        }

        public final Builder applications(ManifestV3Application ... elements) {
            for (ManifestV3Application element : elements) {
                this.applications.add(Objects.requireNonNull(element, "applications element"));
            }
            return this;
        }

        public final Builder applications(Iterable<? extends ManifestV3Application> elements) {
            this.applications.clear();
            return this.addAllApplications(elements);
        }

        public final Builder addAllApplications(Iterable<? extends ManifestV3Application> elements) {
            for (ManifestV3Application manifestV3Application : elements) {
                this.applications.add(Objects.requireNonNull(manifestV3Application, "applications element"));
            }
            return this;
        }

        public final Builder version(Integer version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        public ManifestV3 build() {
            return ManifestV3.validate(new ManifestV3(this));
        }
    }
}

