/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications.Docker;
import org.cloudfoundry.operations.applications.ManifestV3RouteProtocol;
import org.cloudfoundry.operations.applications.Route;
import org.cloudfoundry.operations.applications._ApplicationManifestCommon;
import org.cloudfoundry.util.tuple.Consumer2;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import reactor.core.Exceptions;

abstract class ApplicationManifestUtilsCommon {
    static final int GIBI = 1024;
    static final Yaml YAML;
    static final Pattern FIND_VARIABLE_REGEX;

    ApplicationManifestUtilsCommon() {
    }

    static <T extends _ApplicationManifestCommon.Builder> T toApplicationManifestCommon(Map<String, Object> application, Map<String, String> variables, T builder, Path root) {
        ApplicationManifestUtilsCommon.asListOfString(application, "buildpacks", variables, xva$0 -> builder.buildpacks((String)xva$0));
        ApplicationManifestUtilsCommon.asString(application, "buildpack", variables, xva$0 -> builder.buildpacks((String)xva$0));
        ApplicationManifestUtilsCommon.asString(application, "command", variables, builder::command);
        ApplicationManifestUtilsCommon.asMemoryInteger(application, "disk_quota", variables, builder::disk);
        ApplicationManifestUtilsCommon.asDocker(application, "docker", variables, builder::docker);
        ApplicationManifestUtilsCommon.asString(application, "domain", variables, builder::domain);
        ApplicationManifestUtilsCommon.asListOfString(application, "domains", variables, builder::domain);
        ApplicationManifestUtilsCommon.asMapOfStringString(application, "env", variables, (Consumer2<String, String>)((Consumer2)builder::environmentVariable));
        ApplicationManifestUtilsCommon.asString(application, "health-check-http-endpoint", variables, builder::healthCheckHttpEndpoint);
        ApplicationManifestUtilsCommon.asString(application, "health-check-type", variables, healthCheckType -> builder.healthCheckType(ApplicationHealthCheck.from(healthCheckType)));
        ApplicationManifestUtilsCommon.asString(application, "host", variables, builder::host);
        ApplicationManifestUtilsCommon.asListOfString(application, "hosts", variables, builder::host);
        ApplicationManifestUtilsCommon.asInteger(application, "instances", variables, builder::instances);
        ApplicationManifestUtilsCommon.asMemoryInteger(application, "memory", variables, builder::memory);
        ApplicationManifestUtilsCommon.asString(application, "name", variables, builder::name);
        ApplicationManifestUtilsCommon.asBoolean(application, "no-hostname", variables, builder::noHostname);
        ApplicationManifestUtilsCommon.asBoolean(application, "no-route", variables, builder::noRoute);
        ApplicationManifestUtilsCommon.asString(application, "path", variables, path -> builder.path(root.getParent().resolve((String)path)));
        ApplicationManifestUtilsCommon.asBoolean(application, "random-route", variables, builder::randomRoute);
        ApplicationManifestUtilsCommon.asList(application, "routes", variables, raw -> ApplicationManifestUtilsCommon.getRoute((Map)raw, variables), builder::route);
        ApplicationManifestUtilsCommon.asString(application, "stack", variables, builder::stack);
        ApplicationManifestUtilsCommon.asInteger(application, "timeout", variables, builder::timeout);
        return builder;
    }

    static <T> void as(Map<String, Object> payload, String key, Map<String, String> variables, Function<Object, T> mapper, Consumer<T> consumer) {
        Optional.ofNullable(payload.get(key)).map(o -> {
            if (o instanceof String) {
                Matcher m = FIND_VARIABLE_REGEX.matcher((String)o);
                StringBuffer stringBuffer = new StringBuffer();
                while (m.find()) {
                    m.appendReplacement(stringBuffer, (String)Optional.ofNullable(variables.get(m.group(1))).orElseThrow(() -> new NoSuchElementException("Expected to find variable: " + m.group(1))));
                }
                m.appendTail(stringBuffer);
                return stringBuffer.toString();
            }
            return o;
        }).map(mapper).ifPresent(consumer);
    }

    static void asBoolean(Map<String, Object> payload, String key, Map<String, String> variables, Consumer<Boolean> consumer) {
        ApplicationManifestUtilsCommon.as(payload, key, variables, Boolean.class::cast, consumer);
    }

    static void asDocker(Map<String, Object> payload, String key, Map<String, String> variables, Consumer<Docker> consumer) {
        ApplicationManifestUtilsCommon.as(payload, key, variables, value -> {
            Map docker = (Map)value;
            return Docker.builder().image((String)docker.get("image")).password((String)docker.get("password")).username((String)docker.get("username")).build();
        }, consumer);
    }

    static void asInteger(Map<String, Object> payload, String key, Map<String, String> variables, Consumer<Integer> consumer) {
        ApplicationManifestUtilsCommon.as(payload, key, variables, e -> {
            if (e instanceof String) {
                return Integer.parseInt((String)e);
            }
            return (Integer)e;
        }, consumer);
    }

    static <T> void asList(Map<String, Object> payload, String key, Map<String, String> variables, Function<Object, T> mapper, Consumer<T> consumer) {
        ApplicationManifestUtilsCommon.as(payload, key, variables, value -> ((List)value).stream(), values -> values.map(mapper).forEach(consumer));
    }

    static void asListOfString(Map<String, Object> payload, String key, Map<String, String> variables, Consumer<String> consumer) {
        ApplicationManifestUtilsCommon.asList(payload, key, variables, String.class::cast, consumer);
    }

    static <T> void asMap(Map<String, Object> payload, String key, Map<String, String> variables, Function<Object, T> valueMapper, Consumer2<String, T> consumer) {
        ApplicationManifestUtilsCommon.as(payload, key, variables, value -> (Map)value, values -> values.forEach((k, v) -> consumer.accept(k, valueMapper.apply(v))));
    }

    static void asMapOfStringString(Map<String, Object> payload, String key, Map<String, String> variables, Consumer2<String, String> consumer) {
        ApplicationManifestUtilsCommon.asMap(payload, key, variables, String::valueOf, consumer);
    }

    static void asMemoryInteger(Map<String, Object> payload, String key, Map<String, String> variables, Consumer<Integer> consumer) {
        ApplicationManifestUtilsCommon.as(payload, key, variables, raw -> {
            if (raw instanceof Integer) {
                return (Integer)raw;
            }
            if (raw instanceof String) {
                String text = ((String)raw).toUpperCase();
                if (text.endsWith("G")) {
                    return Integer.parseInt(text.substring(0, text.length() - 1)) * 1024;
                }
                if (text.endsWith("GB")) {
                    return Integer.parseInt(text.substring(0, text.length() - 2)) * 1024;
                }
                if (text.endsWith("M")) {
                    return Integer.parseInt(text.substring(0, text.length() - 1));
                }
                if (text.endsWith("MB")) {
                    return Integer.parseInt(text.substring(0, text.length() - 2));
                }
                return 0;
            }
            return 0;
        }, consumer);
    }

    static void asString(Map<String, Object> payload, String key, Map<String, String> variables, Consumer<String> consumer) {
        ApplicationManifestUtilsCommon.as(payload, key, variables, String.class::cast, consumer);
    }

    static Map<String, Object> deserialize(Path path) {
        AtomicReference<Map> root = new AtomicReference<Map>();
        try (InputStream in = Files.newInputStream(path, StandardOpenOption.READ);){
            root.set((Map)YAML.load(in));
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        ApplicationManifestUtilsCommon.asString((Map)root.get(), "inherit", Collections.emptyMap(), inherit -> {
            Map<String, Object> inherited = ApplicationManifestUtilsCommon.deserialize(path.getParent().resolve((String)inherit));
            ApplicationManifestUtilsCommon.merge(inherited, (Map)root.get());
            root.set(inherited);
        });
        return (Map)root.get();
    }

    static Object getEmptyNamedObject(List<Object> array, String name) {
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("name", name);
        array.add(value);
        return value;
    }

    static String getName(Map<String, Object> raw) {
        return Optional.ofNullable(raw.get("name")).map(String.class::cast).orElseThrow(() -> new IllegalStateException("Application does not contain required 'name' value"));
    }

    static Map<String, Object> getNamedObject(List<Object> array, String name) {
        return (Map)array.stream().filter(value -> value instanceof Map && name.equals(((Map)value).get("name"))).findFirst().orElseGet(() -> ApplicationManifestUtilsCommon.getEmptyNamedObject(array, name));
    }

    static Route getRoute(Map<String, Object> raw, Map<String, String> variables) {
        Route.Builder builder = Route.builder();
        ApplicationManifestUtilsCommon.asString(raw, "route", variables, builder::route);
        ApplicationManifestUtilsCommon.asString(raw, "protocol", variables, p -> builder.protocol(ManifestV3RouteProtocol.from(p)));
        return builder.build();
    }

    static void merge(Map<String, Object> first, Map<String, Object> second) {
        second.forEach((key, value) -> first.merge((String)key, value, (firstValue, secondValue) -> {
            if (secondValue instanceof Map) {
                ApplicationManifestUtilsCommon.merge((Map)firstValue, (Map)secondValue);
                return firstValue;
            }
            if (secondValue instanceof List) {
                ApplicationManifestUtilsCommon.merge((List)firstValue, (List)secondValue);
                return firstValue;
            }
            return secondValue;
        }));
    }

    static void merge(List<Object> first, List<Object> second) {
        second.forEach(element -> {
            if (element instanceof Map) {
                Object name = ((Map)element).get("name");
                if (name != null) {
                    Map<String, Object> named = ApplicationManifestUtilsCommon.getNamedObject(first, (String)name);
                    ApplicationManifestUtilsCommon.merge(named, (Map)element);
                } else {
                    first.add(element);
                }
            } else {
                first.add(element);
            }
        });
    }

    static Function<Path, Object> pathToString() {
        return path -> Optional.ofNullable(path).map(Path::toString).orElse(null);
    }

    static Function<ApplicationHealthCheck, Object> protectApplicationHealthCheck() {
        return applicationHealthCheck -> Optional.ofNullable(applicationHealthCheck).map(ApplicationHealthCheck::getValue).orElse(null);
    }

    static void putIfPresent(Map<String, Object> yaml, String key, Object value) {
        ApplicationManifestUtilsCommon.putIfPresent(yaml, key, value, Function.identity());
    }

    static <T> void putIfPresent(Map<String, Object> yaml, String key, T value, Function<T, Object> valueMapper) {
        Optional.ofNullable(value).map(valueMapper).ifPresent(v -> yaml.put(key, v));
    }

    static List<Map<String, Object>> toRoutesYaml(List<Route> routes) {
        return routes.stream().map(route -> {
            TreeMap<String, Object> yaml = new TreeMap<String, Object>();
            yaml.put("route", route.getRoute());
            ApplicationManifestUtilsCommon.putIfPresent(yaml, "protocol", route.getProtocol(), ManifestV3RouteProtocol::getValue);
            return yaml;
        }).collect(Collectors.toList());
    }

    static Map<String, Object> toApplicationYaml(_ApplicationManifestCommon applicationManifest) {
        TreeMap<String, Object> yaml = new TreeMap<String, Object>();
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "buildpacks", applicationManifest.getBuildpacks());
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "command", applicationManifest.getCommand());
        Integer disk = applicationManifest.getDisk();
        if (null != disk) {
            ApplicationManifestUtilsCommon.putIfPresent(yaml, "disk_quota", applicationManifest.getDisk().toString() + "M");
        }
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "docker", applicationManifest.getDocker());
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "domains", applicationManifest.getDomains());
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "env", applicationManifest.getEnvironmentVariables());
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "health-check-http-endpoint", applicationManifest.getHealthCheckHttpEndpoint());
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "health-check-type", applicationManifest.getHealthCheckType(), ApplicationManifestUtilsCommon.protectApplicationHealthCheck());
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "hosts", applicationManifest.getHosts());
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "instances", applicationManifest.getInstances());
        Integer memory = applicationManifest.getMemory();
        if (null != memory) {
            ApplicationManifestUtilsCommon.putIfPresent(yaml, "memory", memory + "M");
        }
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "name", applicationManifest.getName());
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "no-hostname", applicationManifest.getNoHostname());
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "no-route", applicationManifest.getNoRoute());
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "path", applicationManifest.getPath(), ApplicationManifestUtilsCommon.pathToString());
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "random-route", applicationManifest.getRandomRoute());
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "route-path", applicationManifest.getRoutePath());
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "routes", applicationManifest.getRoutes(), ApplicationManifestUtilsCommon::toRoutesYaml);
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "stack", applicationManifest.getStack());
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "timeout", applicationManifest.getTimeout());
        return yaml;
    }

    static Map<String, Object> toDockerYaml(Docker docker) {
        if (docker == null) {
            return null;
        }
        TreeMap<String, Object> yaml = new TreeMap<String, Object>();
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "image", docker.getImage());
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "username", docker.getUsername());
        ApplicationManifestUtilsCommon.putIfPresent(yaml, "password", docker.getPassword());
        return yaml;
    }

    static <T, S> List<S> convertCollection(Collection<T> collection, Function<T, S> converter) {
        if (collection == null) {
            return null;
        }
        return collection.stream().map(converter).collect(Collectors.toList());
    }

    static {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setExplicitStart(true);
        YAML = new Yaml(dumperOptions);
        FIND_VARIABLE_REGEX = Pattern.compile("\\(\\(([a-zA-Z]\\w+)\\)\\)");
    }
}

