package org.cloudfoundry.operations.useradmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request options for the list space users operation
 */
@Generated(from = "_ListSpaceUsersRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListSpaceUsersRequest extends org.cloudfoundry.operations.useradmin._ListSpaceUsersRequest {
  private final String organizationName;
  private final String spaceName;

  private ListSpaceUsersRequest(ListSpaceUsersRequest.Builder builder) {
    this.organizationName = builder.organizationName;
    this.spaceName = builder.spaceName;
  }

  /**
   * Organization name to list
   */
  @Override
  public String getOrganizationName() {
    return organizationName;
  }

  /**
   * Space name to list
   */
  @Override
  public String getSpaceName() {
    return spaceName;
  }

  /**
   * This instance is equal to all instances of {@code ListSpaceUsersRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListSpaceUsersRequest
        && equalTo(0, (ListSpaceUsersRequest) another);
  }

  private boolean equalTo(int synthetic, ListSpaceUsersRequest another) {
    return organizationName.equals(another.organizationName)
        && spaceName.equals(another.spaceName);
  }

  /**
   * Computes a hash code from attributes: {@code organizationName}, {@code spaceName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organizationName.hashCode();
    h += (h << 5) + spaceName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListSpaceUsersRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListSpaceUsersRequest{"
        + "organizationName=" + organizationName
        + ", spaceName=" + spaceName
        + "}";
  }

  /**
   * Creates a builder for {@link ListSpaceUsersRequest ListSpaceUsersRequest}.
   * <pre>
   * ListSpaceUsersRequest.builder()
   *    .organizationName(String) // required {@link ListSpaceUsersRequest#getOrganizationName() organizationName}
   *    .spaceName(String) // required {@link ListSpaceUsersRequest#getSpaceName() spaceName}
   *    .build();
   * </pre>
   * @return A new ListSpaceUsersRequest builder
   */
  public static ListSpaceUsersRequest.Builder builder() {
    return new ListSpaceUsersRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListSpaceUsersRequest ListSpaceUsersRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListSpaceUsersRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_NAME = 0x1L;
    private static final long INIT_BIT_SPACE_NAME = 0x2L;
    private long initBits = 0x3L;

    private String organizationName;
    private String spaceName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListSpaceUsersRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListSpaceUsersRequest instance) {
      return from((_ListSpaceUsersRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ListSpaceUsersRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListSpaceUsersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationName(instance.getOrganizationName());
      spaceName(instance.getSpaceName());
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceUsersRequest#getOrganizationName() organizationName} attribute.
     * @param organizationName The value for organizationName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationName(String organizationName) {
      this.organizationName = Objects.requireNonNull(organizationName, "organizationName");
      initBits &= ~INIT_BIT_ORGANIZATION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceUsersRequest#getSpaceName() spaceName} attribute.
     * @param spaceName The value for spaceName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceName(String spaceName) {
      this.spaceName = Objects.requireNonNull(spaceName, "spaceName");
      initBits &= ~INIT_BIT_SPACE_NAME;
      return this;
    }

    /**
     * Builds a new {@link ListSpaceUsersRequest ListSpaceUsersRequest}.
     * @return An immutable instance of ListSpaceUsersRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListSpaceUsersRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListSpaceUsersRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_NAME) != 0) attributes.add("organizationName");
      if ((initBits & INIT_BIT_SPACE_NAME) != 0) attributes.add("spaceName");
      return "Cannot build ListSpaceUsersRequest, some of required attributes are not set " + attributes;
    }
  }
}
