package org.cloudfoundry.operations.serviceadmin;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Request options for the disable service access operation
 */
@Generated(from = "_DisableServiceAccessRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DisableServiceAccessRequest
    extends org.cloudfoundry.operations.serviceadmin._DisableServiceAccessRequest {
  private final Duration completionTimeout;
  private final @Nullable String organizationName;
  private final String serviceName;
  private final @Nullable String servicePlanName;

  private DisableServiceAccessRequest(DisableServiceAccessRequest.Builder builder) {
    this.organizationName = builder.organizationName;
    this.serviceName = builder.serviceName;
    this.servicePlanName = builder.servicePlanName;
    this.completionTimeout = builder.completionTimeout != null
        ? builder.completionTimeout
        : Objects.requireNonNull(super.getCompletionTimeout(), "completionTimeout");
  }

  /**
   * How long to wait for the disable
   */
  @Override
  public Duration getCompletionTimeout() {
    return completionTimeout;
  }

  /**
   * Limit to this organization name
   */
  @Override
  public @Nullable String getOrganizationName() {
    return organizationName;
  }

  /**
   * The name of the service to enable
   */
  @Override
  public String getServiceName() {
    return serviceName;
  }

  /**
   * Limit to this service plan name
   */
  @Override
  public @Nullable String getServicePlanName() {
    return servicePlanName;
  }

  /**
   * This instance is equal to all instances of {@code DisableServiceAccessRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DisableServiceAccessRequest
        && equalTo(0, (DisableServiceAccessRequest) another);
  }

  private boolean equalTo(int synthetic, DisableServiceAccessRequest another) {
    return completionTimeout.equals(another.completionTimeout)
        && Objects.equals(organizationName, another.organizationName)
        && serviceName.equals(another.serviceName)
        && Objects.equals(servicePlanName, another.servicePlanName);
  }

  /**
   * Computes a hash code from attributes: {@code completionTimeout}, {@code organizationName}, {@code serviceName}, {@code servicePlanName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + completionTimeout.hashCode();
    h += (h << 5) + Objects.hashCode(organizationName);
    h += (h << 5) + serviceName.hashCode();
    h += (h << 5) + Objects.hashCode(servicePlanName);
    return h;
  }

  /**
   * Prints the immutable value {@code DisableServiceAccessRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DisableServiceAccessRequest{"
        + "completionTimeout=" + completionTimeout
        + ", organizationName=" + organizationName
        + ", serviceName=" + serviceName
        + ", servicePlanName=" + servicePlanName
        + "}";
  }

  /**
   * Creates a builder for {@link DisableServiceAccessRequest DisableServiceAccessRequest}.
   * <pre>
   * DisableServiceAccessRequest.builder()
   *    .completionTimeout(java.time.Duration) // optional {@link DisableServiceAccessRequest#getCompletionTimeout() completionTimeout}
   *    .organizationName(String | null) // nullable {@link DisableServiceAccessRequest#getOrganizationName() organizationName}
   *    .serviceName(String) // required {@link DisableServiceAccessRequest#getServiceName() serviceName}
   *    .servicePlanName(String | null) // nullable {@link DisableServiceAccessRequest#getServicePlanName() servicePlanName}
   *    .build();
   * </pre>
   * @return A new DisableServiceAccessRequest builder
   */
  public static DisableServiceAccessRequest.Builder builder() {
    return new DisableServiceAccessRequest.Builder();
  }

  /**
   * Builds instances of type {@link DisableServiceAccessRequest DisableServiceAccessRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DisableServiceAccessRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_NAME = 0x1L;
    private long initBits = 0x1L;

    private Duration completionTimeout;
    private String organizationName;
    private String serviceName;
    private String servicePlanName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DisableServiceAccessRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DisableServiceAccessRequest instance) {
      return from((_DisableServiceAccessRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DisableServiceAccessRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DisableServiceAccessRequest instance) {
      Objects.requireNonNull(instance, "instance");
      completionTimeout(instance.getCompletionTimeout());
      String organizationNameValue = instance.getOrganizationName();
      if (organizationNameValue != null) {
        organizationName(organizationNameValue);
      }
      serviceName(instance.getServiceName());
      String servicePlanNameValue = instance.getServicePlanName();
      if (servicePlanNameValue != null) {
        servicePlanName(servicePlanNameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DisableServiceAccessRequest#getCompletionTimeout() completionTimeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DisableServiceAccessRequest#getCompletionTimeout() completionTimeout}.</em>
     * @param completionTimeout The value for completionTimeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder completionTimeout(Duration completionTimeout) {
      this.completionTimeout = Objects.requireNonNull(completionTimeout, "completionTimeout");
      return this;
    }

    /**
     * Initializes the value for the {@link DisableServiceAccessRequest#getOrganizationName() organizationName} attribute.
     * @param organizationName The value for organizationName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationName(@Nullable String organizationName) {
      this.organizationName = organizationName;
      return this;
    }

    /**
     * Initializes the value for the {@link DisableServiceAccessRequest#getServiceName() serviceName} attribute.
     * @param serviceName The value for serviceName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceName(String serviceName) {
      this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
      initBits &= ~INIT_BIT_SERVICE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DisableServiceAccessRequest#getServicePlanName() servicePlanName} attribute.
     * @param servicePlanName The value for servicePlanName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanName(@Nullable String servicePlanName) {
      this.servicePlanName = servicePlanName;
      return this;
    }

    /**
     * Builds a new {@link DisableServiceAccessRequest DisableServiceAccessRequest}.
     * @return An immutable instance of DisableServiceAccessRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DisableServiceAccessRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DisableServiceAccessRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_NAME) != 0) attributes.add("serviceName");
      return "Cannot build DisableServiceAccessRequest, some of required attributes are not set " + attributes;
    }
  }
}
