package org.cloudfoundry.operations.domains;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Domain object representation
 */
@Generated(from = "_Domain", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Domain extends org.cloudfoundry.operations.domains._Domain {
  private final String id;
  private final String name;
  private final Status status;
  private final @Nullable String type;

  private Domain(Domain.Builder builder) {
    this.id = builder.id;
    this.name = builder.name;
    this.status = builder.status;
    this.type = builder.type;
  }

  /**
   * The id of the domain
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The name of the domain
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The status of the domain indicating shared or private ('owned')
   */
  @Override
  public Status getStatus() {
    return status;
  }

  /**
   * The type of the domain
   */
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code Domain} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Domain
        && equalTo(0, (Domain) another);
  }

  private boolean equalTo(int synthetic, Domain another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && status.equals(another.status)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code status}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + status.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code Domain} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Domain{"
        + "id=" + id
        + ", name=" + name
        + ", status=" + status
        + ", type=" + type
        + "}";
  }

  /**
   * Creates a builder for {@link Domain Domain}.
   * <pre>
   * Domain.builder()
   *    .id(String) // required {@link Domain#getId() id}
   *    .name(String) // required {@link Domain#getName() name}
   *    .status(org.cloudfoundry.operations.domains.Status) // required {@link Domain#getStatus() status}
   *    .type(String | null) // nullable {@link Domain#getType() type}
   *    .build();
   * </pre>
   * @return A new Domain builder
   */
  public static Domain.Builder builder() {
    return new Domain.Builder();
  }

  /**
   * Builds instances of type {@link Domain Domain}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Domain", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_STATUS = 0x4L;
    private long initBits = 0x7L;

    private String id;
    private String name;
    private Status status;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Domain} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Domain instance) {
      return from((_Domain) instance);
    }

    /**
     * Copy abstract value type {@code _Domain} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Domain instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      status(instance.getStatus());
      String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Domain#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Domain#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Domain#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder status(Status status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the value for the {@link Domain#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Builds a new {@link Domain Domain}.
     * @return An immutable instance of Domain
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Domain build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Domain(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build Domain, some of required attributes are not set " + attributes;
    }
  }
}
