package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * A Cloud Foundry Application as returned by list
 */
@Generated(from = "_ApplicationSummary", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ApplicationSummary extends org.cloudfoundry.operations.applications._ApplicationSummary {
  private final Integer diskQuota;
  private final String id;
  private final Integer instances;
  private final Integer memoryLimit;
  private final String name;
  private final String requestedState;
  private final Integer runningInstances;
  private final List<String> urls;

  private ApplicationSummary(ApplicationSummary.Builder builder) {
    this.diskQuota = builder.diskQuota;
    this.id = builder.id;
    this.instances = builder.instances;
    this.memoryLimit = builder.memoryLimit;
    this.name = builder.name;
    this.requestedState = builder.requestedState;
    this.runningInstances = builder.runningInstances;
    this.urls = createUnmodifiableList(true, builder.urls);
  }

  /**
   * The disk quota in bytes
   */
  @Override
  public Integer getDiskQuota() {
    return diskQuota;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The number of instances
   */
  @Override
  public Integer getInstances() {
    return instances;
  }

  /**
   * The memory limit in bytes
   */
  @Override
  public Integer getMemoryLimit() {
    return memoryLimit;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The requested state
   */
  @Override
  public String getRequestedState() {
    return requestedState;
  }

  /**
   * The number of running instances
   */
  @Override
  public Integer getRunningInstances() {
    return runningInstances;
  }

  /**
   * The list of bound urls
   */
  @Override
  public List<String> getUrls() {
    return urls;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationSummary} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationSummary
        && equalTo(0, (ApplicationSummary) another);
  }

  private boolean equalTo(int synthetic, ApplicationSummary another) {
    return diskQuota.equals(another.diskQuota)
        && id.equals(another.id)
        && instances.equals(another.instances)
        && memoryLimit.equals(another.memoryLimit)
        && name.equals(another.name)
        && requestedState.equals(another.requestedState)
        && runningInstances.equals(another.runningInstances)
        && urls.equals(another.urls);
  }

  /**
   * Computes a hash code from attributes: {@code diskQuota}, {@code id}, {@code instances}, {@code memoryLimit}, {@code name}, {@code requestedState}, {@code runningInstances}, {@code urls}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + diskQuota.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + instances.hashCode();
    h += (h << 5) + memoryLimit.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + requestedState.hashCode();
    h += (h << 5) + runningInstances.hashCode();
    h += (h << 5) + urls.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationSummary} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationSummary{"
        + "diskQuota=" + diskQuota
        + ", id=" + id
        + ", instances=" + instances
        + ", memoryLimit=" + memoryLimit
        + ", name=" + name
        + ", requestedState=" + requestedState
        + ", runningInstances=" + runningInstances
        + ", urls=" + urls
        + "}";
  }

  /**
   * Creates a builder for {@link ApplicationSummary ApplicationSummary}.
   * <pre>
   * ApplicationSummary.builder()
   *    .diskQuota(Integer) // required {@link ApplicationSummary#getDiskQuota() diskQuota}
   *    .id(String) // required {@link ApplicationSummary#getId() id}
   *    .instances(Integer) // required {@link ApplicationSummary#getInstances() instances}
   *    .memoryLimit(Integer) // required {@link ApplicationSummary#getMemoryLimit() memoryLimit}
   *    .name(String) // required {@link ApplicationSummary#getName() name}
   *    .requestedState(String) // required {@link ApplicationSummary#getRequestedState() requestedState}
   *    .runningInstances(Integer) // required {@link ApplicationSummary#getRunningInstances() runningInstances}
   *    .url|addAllUrls(String) // {@link ApplicationSummary#getUrls() urls} elements
   *    .build();
   * </pre>
   * @return A new ApplicationSummary builder
   */
  public static ApplicationSummary.Builder builder() {
    return new ApplicationSummary.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationSummary ApplicationSummary}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ApplicationSummary", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DISK_QUOTA = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_INSTANCES = 0x4L;
    private static final long INIT_BIT_MEMORY_LIMIT = 0x8L;
    private static final long INIT_BIT_NAME = 0x10L;
    private static final long INIT_BIT_REQUESTED_STATE = 0x20L;
    private static final long INIT_BIT_RUNNING_INSTANCES = 0x40L;
    private long initBits = 0x7fL;

    private Integer diskQuota;
    private String id;
    private Integer instances;
    private Integer memoryLimit;
    private String name;
    private String requestedState;
    private Integer runningInstances;
    private List<String> urls = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.operations.applications.AbstractApplicationSummary} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractApplicationSummary instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationSummary} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationSummary instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ApplicationSummary} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ApplicationSummary instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof AbstractApplicationSummary) {
        AbstractApplicationSummary instance = (AbstractApplicationSummary) object;
        addAllUrls(instance.getUrls());
        instances(instance.getInstances());
        requestedState(instance.getRequestedState());
        name(instance.getName());
        memoryLimit(instance.getMemoryLimit());
        id(instance.getId());
        runningInstances(instance.getRunningInstances());
        diskQuota(instance.getDiskQuota());
      }
    }

    /**
     * Initializes the value for the {@link ApplicationSummary#getDiskQuota() diskQuota} attribute.
     * @param diskQuota The value for diskQuota 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskQuota(Integer diskQuota) {
      this.diskQuota = Objects.requireNonNull(diskQuota, "diskQuota");
      initBits &= ~INIT_BIT_DISK_QUOTA;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationSummary#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationSummary#getInstances() instances} attribute.
     * @param instances The value for instances 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instances(Integer instances) {
      this.instances = Objects.requireNonNull(instances, "instances");
      initBits &= ~INIT_BIT_INSTANCES;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationSummary#getMemoryLimit() memoryLimit} attribute.
     * @param memoryLimit The value for memoryLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryLimit(Integer memoryLimit) {
      this.memoryLimit = Objects.requireNonNull(memoryLimit, "memoryLimit");
      initBits &= ~INIT_BIT_MEMORY_LIMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationSummary#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationSummary#getRequestedState() requestedState} attribute.
     * @param requestedState The value for requestedState 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requestedState(String requestedState) {
      this.requestedState = Objects.requireNonNull(requestedState, "requestedState");
      initBits &= ~INIT_BIT_REQUESTED_STATE;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationSummary#getRunningInstances() runningInstances} attribute.
     * @param runningInstances The value for runningInstances 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder runningInstances(Integer runningInstances) {
      this.runningInstances = Objects.requireNonNull(runningInstances, "runningInstances");
      initBits &= ~INIT_BIT_RUNNING_INSTANCES;
      return this;
    }

    /**
     * Adds one element to {@link ApplicationSummary#getUrls() urls} list.
     * @param element A urls element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder url(String element) {
      this.urls.add(Objects.requireNonNull(element, "urls element"));
      return this;
    }

    /**
     * Adds elements to {@link ApplicationSummary#getUrls() urls} list.
     * @param elements An array of urls elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder urls(String... elements) {
      for (String element : elements) {
        this.urls.add(Objects.requireNonNull(element, "urls element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ApplicationSummary#getUrls() urls} list.
     * @param elements An iterable of urls elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder urls(Iterable<String> elements) {
      this.urls.clear();
      return addAllUrls(elements);
    }

    /**
     * Adds elements to {@link ApplicationSummary#getUrls() urls} list.
     * @param elements An iterable of urls elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllUrls(Iterable<String> elements) {
      for (String element : elements) {
        this.urls.add(Objects.requireNonNull(element, "urls element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ApplicationSummary ApplicationSummary}.
     * @return An immutable instance of ApplicationSummary
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationSummary build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ApplicationSummary(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DISK_QUOTA) != 0) attributes.add("diskQuota");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_INSTANCES) != 0) attributes.add("instances");
      if ((initBits & INIT_BIT_MEMORY_LIMIT) != 0) attributes.add("memoryLimit");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_REQUESTED_STATE) != 0) attributes.add("requestedState");
      if ((initBits & INIT_BIT_RUNNING_INSTANCES) != 0) attributes.add("runningInstances");
      return "Cannot build ApplicationSummary, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
