/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ManifestV3RouteProtocol {
    TCP("tcp"),
    HTTP1("http1"),
    HTTP2("http2");

    private final String value;

    private ManifestV3RouteProtocol(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ManifestV3RouteProtocol from(String s) {
        switch (s.toLowerCase()) {
            case "http1": {
                return HTTP1;
            }
            case "http2": {
                return HTTP2;
            }
            case "tcp": {
                return TCP;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown protocol: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

