/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudfoundry.operations.applications.RandomWords;

final class WordListRandomWords
implements RandomWords {
    private static final Random RANDOM = new SecureRandom();

    WordListRandomWords() {
    }

    @Override
    public String getAdjective() {
        return (String)Adjectives.WORDS.get(RANDOM.nextInt(Adjectives.WORDS.size()));
    }

    @Override
    public String getNoun() {
        return (String)Nouns.WORDS.get(RANDOM.nextInt(Nouns.WORDS.size()));
    }

    private static BufferedReader getReader(String resourceName) {
        InputStream inputStream = WordListRandomWords.class.getClassLoader().getResourceAsStream(resourceName);
        return new BufferedReader(new InputStreamReader(inputStream));
    }

    private static List<String> getWordList(String resourceName) {
        try (Stream<String> stream = WordListRandomWords.getReader(resourceName).lines();){
            List<String> list = stream.map(String::trim).collect(Collectors.toList());
            return list;
        }
    }

    static /* synthetic */ List access$200(String x0) {
        return WordListRandomWords.getWordList(x0);
    }

    private static final class Nouns {
        private static List<String> WORDS = WordListRandomWords.access$200("nouns.txt");

        private Nouns() {
        }
    }

    private static final class Adjectives {
        private static List<String> WORDS = WordListRandomWords.access$200("adjectives.txt");

        private Adjectives() {
        }
    }
}

