/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications._Docker;

public final class Docker
extends _Docker {
    @Nullable
    private final String image;
    @Nullable
    private final String password;
    @Nullable
    private final String username;

    private Docker(Builder builder) {
        this.image = builder.image;
        this.password = builder.password;
        this.username = builder.username;
    }

    @Override
    @Nullable
    public String getImage() {
        return this.image;
    }

    @Override
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.username;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Docker && this.equalTo((Docker)another);
    }

    private boolean equalTo(Docker another) {
        return Objects.equals(this.image, another.image) && Objects.equals(this.password, another.password) && Objects.equals(this.username, another.username);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.image);
        h += (h << 5) + Objects.hashCode(this.password);
        h += (h << 5) + Objects.hashCode(this.username);
        return h;
    }

    public String toString() {
        return "Docker{image=" + this.image + ", password=" + this.password + ", username=" + this.username + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String image;
        private String password;
        private String username;

        private Builder() {
        }

        public final Builder from(Docker instance) {
            return this.from((_Docker)instance);
        }

        final Builder from(_Docker instance) {
            String usernameValue;
            String passwordValue;
            Objects.requireNonNull(instance, "instance");
            String imageValue = instance.getImage();
            if (imageValue != null) {
                this.image(imageValue);
            }
            if ((passwordValue = instance.getPassword()) != null) {
                this.password(passwordValue);
            }
            if ((usernameValue = instance.getUsername()) != null) {
                this.username(usernameValue);
            }
            return this;
        }

        public final Builder image(@Nullable String image) {
            this.image = image;
            return this;
        }

        public final Builder password(@Nullable String password) {
            this.password = password;
            return this;
        }

        public final Builder username(@Nullable String username) {
            this.username = username;
            return this;
        }

        public Docker build() {
            return new Docker(this);
        }
    }
}

