/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.services.AbstractServiceInstanceSummary;
import org.cloudfoundry.operations.services.ServiceInstanceType;
import org.cloudfoundry.operations.services._ServiceInstance;
import org.immutables.value.Generated;

@Generated(from="_ServiceInstance", generator="Immutables")
public final class ServiceInstance
extends _ServiceInstance {
    @Nullable
    private final String dashboardUrl;
    @Nullable
    private final String description;
    @Nullable
    private final String documentationUrl;
    @Nullable
    private final String lastOperation;
    @Nullable
    private final String message;
    @Nullable
    private final String startedAt;
    @Nullable
    private final String status;
    @Nullable
    private final List<String> tags;
    @Nullable
    private final String updatedAt;
    private final List<String> applications;
    private final String id;
    private final String name;
    @Nullable
    private final String plan;
    @Nullable
    private final String service;
    private final ServiceInstanceType type;

    private ServiceInstance(Builder builder) {
        this.dashboardUrl = builder.dashboardUrl;
        this.description = builder.description;
        this.documentationUrl = builder.documentationUrl;
        this.lastOperation = builder.lastOperation;
        this.message = builder.message;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
        this.tags = builder.tags == null ? null : ServiceInstance.createUnmodifiableList(true, builder.tags);
        this.updatedAt = builder.updatedAt;
        this.applications = ServiceInstance.createUnmodifiableList(true, builder.applications);
        this.id = builder.id;
        this.name = builder.name;
        this.plan = builder.plan;
        this.service = builder.service;
        this.type = builder.type;
    }

    @Override
    @Nullable
    public String getDashboardUrl() {
        return this.dashboardUrl;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    @Override
    @Nullable
    public String getLastOperation() {
        return this.lastOperation;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Override
    @Nullable
    public String getStartedAt() {
        return this.startedAt;
    }

    @Override
    @Nullable
    public String getStatus() {
        return this.status;
    }

    @Override
    @Nullable
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public List<String> getApplications() {
        return this.applications;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getPlan() {
        return this.plan;
    }

    @Override
    @Nullable
    public String getService() {
        return this.service;
    }

    @Override
    public ServiceInstanceType getType() {
        return this.type;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServiceInstance && this.equalTo((ServiceInstance)another);
    }

    private boolean equalTo(ServiceInstance another) {
        return Objects.equals(this.dashboardUrl, another.dashboardUrl) && Objects.equals(this.description, another.description) && Objects.equals(this.documentationUrl, another.documentationUrl) && Objects.equals(this.lastOperation, another.lastOperation) && Objects.equals(this.message, another.message) && Objects.equals(this.startedAt, another.startedAt) && Objects.equals(this.status, another.status) && Objects.equals(this.tags, another.tags) && Objects.equals(this.updatedAt, another.updatedAt) && this.applications.equals(another.applications) && this.id.equals(another.id) && this.name.equals(another.name) && Objects.equals(this.plan, another.plan) && Objects.equals(this.service, another.service) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.dashboardUrl);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.documentationUrl);
        h += (h << 5) + Objects.hashCode(this.lastOperation);
        h += (h << 5) + Objects.hashCode(this.message);
        h += (h << 5) + Objects.hashCode(this.startedAt);
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + Objects.hashCode(this.tags);
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + this.applications.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.plan);
        h += (h << 5) + Objects.hashCode(this.service);
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "ServiceInstance{dashboardUrl=" + this.dashboardUrl + ", description=" + this.description + ", documentationUrl=" + this.documentationUrl + ", lastOperation=" + this.lastOperation + ", message=" + this.message + ", startedAt=" + this.startedAt + ", status=" + this.status + ", tags=" + this.tags + ", updatedAt=" + this.updatedAt + ", applications=" + this.applications + ", id=" + this.id + ", name=" + this.name + ", plan=" + this.plan + ", service=" + this.service + ", type=" + (Object)((Object)this.type) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ServiceInstance", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private long initBits = 7L;
        private String dashboardUrl;
        private String description;
        private String documentationUrl;
        private String lastOperation;
        private String message;
        private String startedAt;
        private String status;
        private List<String> tags = null;
        private String updatedAt;
        private List<String> applications = new ArrayList<String>();
        private String id;
        private String name;
        private String plan;
        private String service;
        private ServiceInstanceType type;

        private Builder() {
        }

        public final Builder from(ServiceInstance instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ServiceInstance instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractServiceInstanceSummary instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractServiceInstanceSummary instance;
            long bits = 0L;
            if (object instanceof _ServiceInstance) {
                String updatedAtValue;
                String statusValue;
                String messageValue;
                String startedAtValue;
                String descriptionValue;
                String dashboardUrlValue;
                instance = (_ServiceInstance)object;
                String documentationUrlValue = ((_ServiceInstance)instance).getDocumentationUrl();
                if (documentationUrlValue != null) {
                    this.documentationUrl(documentationUrlValue);
                }
                if ((dashboardUrlValue = ((_ServiceInstance)instance).getDashboardUrl()) != null) {
                    this.dashboardUrl(dashboardUrlValue);
                }
                if ((bits & 2L) == 0L) {
                    String lastOperationValue = ((_ServiceInstance)instance).getLastOperation();
                    if (lastOperationValue != null) {
                        this.lastOperation(lastOperationValue);
                    }
                    bits |= 2L;
                }
                if ((descriptionValue = ((_ServiceInstance)instance).getDescription()) != null) {
                    this.description(descriptionValue);
                }
                if ((startedAtValue = ((_ServiceInstance)instance).getStartedAt()) != null) {
                    this.startedAt(startedAtValue);
                }
                if ((messageValue = ((_ServiceInstance)instance).getMessage()) != null) {
                    this.message(messageValue);
                }
                if ((bits & 1L) == 0L) {
                    List<String> tagsValue = ((_ServiceInstance)instance).getTags();
                    if (tagsValue != null) {
                        this.addAllTags(tagsValue);
                    }
                    bits |= 1L;
                }
                if ((statusValue = ((_ServiceInstance)instance).getStatus()) != null) {
                    this.status(statusValue);
                }
                if ((updatedAtValue = ((_ServiceInstance)instance).getUpdatedAt()) != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
            if (object instanceof AbstractServiceInstanceSummary) {
                instance = (AbstractServiceInstanceSummary)object;
                String serviceValue = instance.getService();
                if (serviceValue != null) {
                    this.service(serviceValue);
                }
                if ((bits & 2L) == 0L) {
                    String lastOperationValue = instance.getLastOperation();
                    if (lastOperationValue != null) {
                        this.lastOperation(lastOperationValue);
                    }
                    bits |= 2L;
                }
                this.name(instance.getName());
                this.id(instance.getId());
                this.type(instance.getType());
                String planValue = instance.getPlan();
                if (planValue != null) {
                    this.plan(planValue);
                }
                if ((bits & 1L) == 0L) {
                    List<String> tagsValue = instance.getTags();
                    if (tagsValue != null) {
                        this.addAllTags(tagsValue);
                    }
                    bits |= 1L;
                }
                this.addAllApplications(instance.getApplications());
            }
        }

        public final Builder dashboardUrl(@Nullable String dashboardUrl) {
            this.dashboardUrl = dashboardUrl;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder documentationUrl(@Nullable String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public final Builder lastOperation(@Nullable String lastOperation) {
            this.lastOperation = lastOperation;
            return this;
        }

        public final Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        public final Builder startedAt(@Nullable String startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Builder status(@Nullable String status) {
            this.status = status;
            return this;
        }

        public final Builder tag(String element) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            return this;
        }

        public final Builder tags(String ... elements) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        public final Builder tags(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.tags = null;
                return this;
            }
            this.tags = new ArrayList<String>();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            Objects.requireNonNull(elements, "tags element");
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Builder application(String element) {
            this.applications.add(Objects.requireNonNull(element, "applications element"));
            return this;
        }

        public final Builder applications(String ... elements) {
            for (String element : elements) {
                this.applications.add(Objects.requireNonNull(element, "applications element"));
            }
            return this;
        }

        public final Builder applications(Iterable<String> elements) {
            this.applications.clear();
            return this.addAllApplications(elements);
        }

        public final Builder addAllApplications(Iterable<String> elements) {
            for (String element : elements) {
                this.applications.add(Objects.requireNonNull(element, "applications element"));
            }
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder plan(@Nullable String plan) {
            this.plan = plan;
            return this;
        }

        public final Builder service(@Nullable String service) {
            this.service = service;
            return this;
        }

        public final Builder type(ServiceInstanceType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ServiceInstance build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ServiceInstance(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build ServiceInstance, some of required attributes are not set " + attributes;
        }
    }
}

