package org.cloudfoundry.operations.useradmin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The users for a space
 */
@Generated(from = "_SpaceUsers", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class SpaceUsers extends org.cloudfoundry.operations.useradmin._SpaceUsers {
  private final List<String> auditors;
  private final List<String> developers;
  private final List<String> managers;

  private SpaceUsers(SpaceUsers.Builder builder) {
    this.auditors = createUnmodifiableList(true, builder.auditors);
    this.developers = createUnmodifiableList(true, builder.developers);
    this.managers = createUnmodifiableList(true, builder.managers);
  }

  /**
   * The space's auditors
   */
  @Override
  public List<String> getAuditors() {
    return auditors;
  }

  /**
   * The space's developers
   */
  @Override
  public List<String> getDevelopers() {
    return developers;
  }

  /**
   * The space's managers
   */
  @Override
  public List<String> getManagers() {
    return managers;
  }

  /**
   * This instance is equal to all instances of {@code SpaceUsers} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SpaceUsers
        && equalTo((SpaceUsers) another);
  }

  private boolean equalTo(SpaceUsers another) {
    return auditors.equals(another.auditors)
        && developers.equals(another.developers)
        && managers.equals(another.managers);
  }

  /**
   * Computes a hash code from attributes: {@code auditors}, {@code developers}, {@code managers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + auditors.hashCode();
    h += (h << 5) + developers.hashCode();
    h += (h << 5) + managers.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SpaceUsers} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SpaceUsers{"
        + "auditors=" + auditors
        + ", developers=" + developers
        + ", managers=" + managers
        + "}";
  }

  /**
   * Creates a builder for {@link SpaceUsers SpaceUsers}.
   * @return A new SpaceUsers builder
   */
  public static SpaceUsers.Builder builder() {
    return new SpaceUsers.Builder();
  }

  /**
   * Builds instances of type {@link SpaceUsers SpaceUsers}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_SpaceUsers", generator = "Immutables")
  public static final class Builder {
    private List<String> auditors = new ArrayList<String>();
    private List<String> developers = new ArrayList<String>();
    private List<String> managers = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SpaceUsers} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SpaceUsers instance) {
      return from((_SpaceUsers) instance);
    }

    /**
     * Copy abstract value type {@code _SpaceUsers} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SpaceUsers instance) {
      Objects.requireNonNull(instance, "instance");
      addAllAuditors(instance.getAuditors());
      addAllDevelopers(instance.getDevelopers());
      addAllManagers(instance.getManagers());
      return this;
    }

    /**
     * Adds one element to {@link SpaceUsers#getAuditors() auditors} list.
     * @param element A auditors element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditor(String element) {
      this.auditors.add(Objects.requireNonNull(element, "auditors element"));
      return this;
    }

    /**
     * Adds elements to {@link SpaceUsers#getAuditors() auditors} list.
     * @param elements An array of auditors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditors(String... elements) {
      for (String element : elements) {
        this.auditors.add(Objects.requireNonNull(element, "auditors element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SpaceUsers#getAuditors() auditors} list.
     * @param elements An iterable of auditors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditors(Iterable<String> elements) {
      this.auditors.clear();
      return addAllAuditors(elements);
    }

    /**
     * Adds elements to {@link SpaceUsers#getAuditors() auditors} list.
     * @param elements An iterable of auditors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuditors(Iterable<String> elements) {
      for (String element : elements) {
        this.auditors.add(Objects.requireNonNull(element, "auditors element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link SpaceUsers#getDevelopers() developers} list.
     * @param element A developers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developer(String element) {
      this.developers.add(Objects.requireNonNull(element, "developers element"));
      return this;
    }

    /**
     * Adds elements to {@link SpaceUsers#getDevelopers() developers} list.
     * @param elements An array of developers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developers(String... elements) {
      for (String element : elements) {
        this.developers.add(Objects.requireNonNull(element, "developers element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SpaceUsers#getDevelopers() developers} list.
     * @param elements An iterable of developers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developers(Iterable<String> elements) {
      this.developers.clear();
      return addAllDevelopers(elements);
    }

    /**
     * Adds elements to {@link SpaceUsers#getDevelopers() developers} list.
     * @param elements An iterable of developers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDevelopers(Iterable<String> elements) {
      for (String element : elements) {
        this.developers.add(Objects.requireNonNull(element, "developers element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link SpaceUsers#getManagers() managers} list.
     * @param element A managers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder manager(String element) {
      this.managers.add(Objects.requireNonNull(element, "managers element"));
      return this;
    }

    /**
     * Adds elements to {@link SpaceUsers#getManagers() managers} list.
     * @param elements An array of managers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managers(String... elements) {
      for (String element : elements) {
        this.managers.add(Objects.requireNonNull(element, "managers element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SpaceUsers#getManagers() managers} list.
     * @param elements An iterable of managers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managers(Iterable<String> elements) {
      this.managers.clear();
      return addAllManagers(elements);
    }

    /**
     * Adds elements to {@link SpaceUsers#getManagers() managers} list.
     * @param elements An iterable of managers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllManagers(Iterable<String> elements) {
      for (String element : elements) {
        this.managers.add(Objects.requireNonNull(element, "managers element"));
      }
      return this;
    }

    /**
     * Builds a new {@link SpaceUsers SpaceUsers}.
     * @return An immutable instance of SpaceUsers
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SpaceUsers build() {
      return new SpaceUsers(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
