package org.cloudfoundry.operations.useradmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request options for the delete user operation
 */
@Generated(from = "_DeleteUserRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteUserRequest extends org.cloudfoundry.operations.useradmin._DeleteUserRequest {
  private final String username;

  private DeleteUserRequest(DeleteUserRequest.Builder builder) {
    this.username = builder.username;
  }

  /**
   * The username of the user to delete
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code DeleteUserRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteUserRequest
        && equalTo((DeleteUserRequest) another);
  }

  private boolean equalTo(DeleteUserRequest another) {
    return username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteUserRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteUserRequest{"
        + "username=" + username
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteUserRequest DeleteUserRequest}.
   * @return A new DeleteUserRequest builder
   */
  public static DeleteUserRequest.Builder builder() {
    return new DeleteUserRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteUserRequest DeleteUserRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteUserRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_USERNAME = 0x1L;
    private long initBits = 0x1L;

    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteUserRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteUserRequest instance) {
      return from((_DeleteUserRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteUserRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteUserRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link DeleteUserRequest DeleteUserRequest}.
     * @return An immutable instance of DeleteUserRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteUserRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteUserRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build DeleteUserRequest, some of required attributes are not set " + attributes;
    }
  }
}
