package org.cloudfoundry.operations.serviceadmin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * A Service Access
 */
@Generated(from = "_ServiceAccess", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServiceAccess extends org.cloudfoundry.operations.serviceadmin._ServiceAccess {
  private final Access access;
  private final String brokerName;
  private final @Nullable List<String> organizationNames;
  private final String planName;
  private final String serviceName;

  private ServiceAccess(ServiceAccess.Builder builder) {
    this.access = builder.access;
    this.brokerName = builder.brokerName;
    this.organizationNames = builder.organizationNames == null ? null : createUnmodifiableList(true, builder.organizationNames);
    this.planName = builder.planName;
    this.serviceName = builder.serviceName;
  }

  /**
   * The access
   */
  @Override
  public Access getAccess() {
    return access;
  }

  /**
   * The broker name
   */
  @Override
  public String getBrokerName() {
    return brokerName;
  }

  /**
   * The organizations
   */
  @Override
  public @Nullable List<String> getOrganizationNames() {
    return organizationNames;
  }

  /**
   * The plan name
   */
  @Override
  public String getPlanName() {
    return planName;
  }

  /**
   * The service name
   */
  @Override
  public String getServiceName() {
    return serviceName;
  }

  /**
   * This instance is equal to all instances of {@code ServiceAccess} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceAccess
        && equalTo((ServiceAccess) another);
  }

  private boolean equalTo(ServiceAccess another) {
    return access.equals(another.access)
        && brokerName.equals(another.brokerName)
        && Objects.equals(organizationNames, another.organizationNames)
        && planName.equals(another.planName)
        && serviceName.equals(another.serviceName);
  }

  /**
   * Computes a hash code from attributes: {@code access}, {@code brokerName}, {@code organizationNames}, {@code planName}, {@code serviceName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + access.hashCode();
    h += (h << 5) + brokerName.hashCode();
    h += (h << 5) + Objects.hashCode(organizationNames);
    h += (h << 5) + planName.hashCode();
    h += (h << 5) + serviceName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceAccess} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceAccess{"
        + "access=" + access
        + ", brokerName=" + brokerName
        + ", organizationNames=" + organizationNames
        + ", planName=" + planName
        + ", serviceName=" + serviceName
        + "}";
  }

  /**
   * Creates a builder for {@link ServiceAccess ServiceAccess}.
   * @return A new ServiceAccess builder
   */
  public static ServiceAccess.Builder builder() {
    return new ServiceAccess.Builder();
  }

  /**
   * Builds instances of type {@link ServiceAccess ServiceAccess}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServiceAccess", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ACCESS = 0x1L;
    private static final long INIT_BIT_BROKER_NAME = 0x2L;
    private static final long INIT_BIT_PLAN_NAME = 0x4L;
    private static final long INIT_BIT_SERVICE_NAME = 0x8L;
    private long initBits = 0xfL;

    private Access access;
    private String brokerName;
    private List<String> organizationNames = null;
    private String planName;
    private String serviceName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceAccess} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceAccess instance) {
      return from((_ServiceAccess) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceAccess} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceAccess instance) {
      Objects.requireNonNull(instance, "instance");
      access(instance.getAccess());
      brokerName(instance.getBrokerName());
      List<String> organizationNamesValue = instance.getOrganizationNames();
      if (organizationNamesValue != null) {
        addAllOrganizationNames(organizationNamesValue);
      }
      planName(instance.getPlanName());
      serviceName(instance.getServiceName());
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceAccess#getAccess() access} attribute.
     * @param access The value for access 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder access(Access access) {
      this.access = Objects.requireNonNull(access, "access");
      initBits &= ~INIT_BIT_ACCESS;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceAccess#getBrokerName() brokerName} attribute.
     * @param brokerName The value for brokerName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder brokerName(String brokerName) {
      this.brokerName = Objects.requireNonNull(brokerName, "brokerName");
      initBits &= ~INIT_BIT_BROKER_NAME;
      return this;
    }

    /**
     * Adds one element to {@link ServiceAccess#getOrganizationNames() organizationNames} list.
     * @param element A organizationNames element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationName(String element) {
      if (this.organizationNames == null) {
        this.organizationNames = new ArrayList<String>();
      }
      this.organizationNames.add(Objects.requireNonNull(element, "organizationNames element"));
      return this;
    }

    /**
     * Adds elements to {@link ServiceAccess#getOrganizationNames() organizationNames} list.
     * @param elements An array of organizationNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationNames(String... elements) {
      if (this.organizationNames == null) {
        this.organizationNames = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationNames.add(Objects.requireNonNull(element, "organizationNames element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ServiceAccess#getOrganizationNames() organizationNames} list.
     * @param elements An iterable of organizationNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationNames(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.organizationNames = null;
        return this;
      }
      this.organizationNames = new ArrayList<String>();
      return addAllOrganizationNames(elements);
    }

    /**
     * Adds elements to {@link ServiceAccess#getOrganizationNames() organizationNames} list.
     * @param elements An iterable of organizationNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "organizationNames element");
      if (this.organizationNames == null) {
        this.organizationNames = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationNames.add(Objects.requireNonNull(element, "organizationNames element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceAccess#getPlanName() planName} attribute.
     * @param planName The value for planName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder planName(String planName) {
      this.planName = Objects.requireNonNull(planName, "planName");
      initBits &= ~INIT_BIT_PLAN_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceAccess#getServiceName() serviceName} attribute.
     * @param serviceName The value for serviceName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceName(String serviceName) {
      this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
      initBits &= ~INIT_BIT_SERVICE_NAME;
      return this;
    }

    /**
     * Builds a new {@link ServiceAccess ServiceAccess}.
     * @return An immutable instance of ServiceAccess
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceAccess build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ServiceAccess(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ACCESS) != 0) attributes.add("access");
      if ((initBits & INIT_BIT_BROKER_NAME) != 0) attributes.add("brokerName");
      if ((initBits & INIT_BIT_PLAN_NAME) != 0) attributes.add("planName");
      if ((initBits & INIT_BIT_SERVICE_NAME) != 0) attributes.add("serviceName");
      return "Cannot build ServiceAccess, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
