package org.cloudfoundry.operations.applications;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the scale application operation
 */
@Generated(from = "_ScaleApplicationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ScaleApplicationRequest
    extends org.cloudfoundry.operations.applications._ScaleApplicationRequest {
  private final @Nullable Integer diskLimit;
  private final @Nullable Integer instances;
  private final @Nullable Integer memoryLimit;
  private final String name;
  private final Duration stagingTimeout;
  private final Duration startupTimeout;

  private ScaleApplicationRequest(ScaleApplicationRequest.Builder builder) {
    this.diskLimit = builder.diskLimit;
    this.instances = builder.instances;
    this.memoryLimit = builder.memoryLimit;
    this.name = builder.name;
    if (builder.stagingTimeout != null) {
      initShim.stagingTimeout(builder.stagingTimeout);
    }
    if (builder.startupTimeout != null) {
      initShim.startupTimeout(builder.startupTimeout);
    }
    this.stagingTimeout = initShim.getStagingTimeout();
    this.startupTimeout = initShim.getStartupTimeout();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "_ScaleApplicationRequest", generator = "Immutables")
  private final class InitShim {
    private byte stagingTimeoutBuildStage = STAGE_UNINITIALIZED;
    private Duration stagingTimeout;

    Duration getStagingTimeout() {
      if (stagingTimeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (stagingTimeoutBuildStage == STAGE_UNINITIALIZED) {
        stagingTimeoutBuildStage = STAGE_INITIALIZING;
        this.stagingTimeout = Objects.requireNonNull(ScaleApplicationRequest.super.getStagingTimeout(), "stagingTimeout");
        stagingTimeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.stagingTimeout;
    }

    void stagingTimeout(Duration stagingTimeout) {
      this.stagingTimeout = stagingTimeout;
      stagingTimeoutBuildStage = STAGE_INITIALIZED;
    }

    private byte startupTimeoutBuildStage = STAGE_UNINITIALIZED;
    private Duration startupTimeout;

    Duration getStartupTimeout() {
      if (startupTimeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (startupTimeoutBuildStage == STAGE_UNINITIALIZED) {
        startupTimeoutBuildStage = STAGE_INITIALIZING;
        this.startupTimeout = Objects.requireNonNull(ScaleApplicationRequest.super.getStartupTimeout(), "startupTimeout");
        startupTimeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.startupTimeout;
    }

    void startupTimeout(Duration startupTimeout) {
      this.startupTimeout = startupTimeout;
      startupTimeoutBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (stagingTimeoutBuildStage == STAGE_INITIALIZING) attributes.add("stagingTimeout");
      if (startupTimeoutBuildStage == STAGE_INITIALIZING) attributes.add("startupTimeout");
      return "Cannot build ScaleApplicationRequest, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * The disk limit in MB
   */
  @Override
  public @Nullable Integer getDiskLimit() {
    return diskLimit;
  }

  /**
   * The number of instances
   */
  @Override
  public @Nullable Integer getInstances() {
    return instances;
  }

  /**
   * The memory limit in MB
   */
  @Override
  public @Nullable Integer getMemoryLimit() {
    return memoryLimit;
  }

  /**
   * The name of the application
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * How long to wait for staging
   */
  @Override
  public Duration getStagingTimeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getStagingTimeout()
        : this.stagingTimeout;
  }

  /**
   * How long to wait for startup
   */
  @Override
  public Duration getStartupTimeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getStartupTimeout()
        : this.startupTimeout;
  }

  /**
   * This instance is equal to all instances of {@code ScaleApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ScaleApplicationRequest
        && equalTo((ScaleApplicationRequest) another);
  }

  private boolean equalTo(ScaleApplicationRequest another) {
    return Objects.equals(diskLimit, another.diskLimit)
        && Objects.equals(instances, another.instances)
        && Objects.equals(memoryLimit, another.memoryLimit)
        && name.equals(another.name)
        && stagingTimeout.equals(another.stagingTimeout)
        && startupTimeout.equals(another.startupTimeout);
  }

  /**
   * Computes a hash code from attributes: {@code diskLimit}, {@code instances}, {@code memoryLimit}, {@code name}, {@code stagingTimeout}, {@code startupTimeout}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(diskLimit);
    h += (h << 5) + Objects.hashCode(instances);
    h += (h << 5) + Objects.hashCode(memoryLimit);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + stagingTimeout.hashCode();
    h += (h << 5) + startupTimeout.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ScaleApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ScaleApplicationRequest{"
        + "diskLimit=" + diskLimit
        + ", instances=" + instances
        + ", memoryLimit=" + memoryLimit
        + ", name=" + name
        + ", stagingTimeout=" + stagingTimeout
        + ", startupTimeout=" + startupTimeout
        + "}";
  }

  /**
   * Creates a builder for {@link ScaleApplicationRequest ScaleApplicationRequest}.
   * @return A new ScaleApplicationRequest builder
   */
  public static ScaleApplicationRequest.Builder builder() {
    return new ScaleApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link ScaleApplicationRequest ScaleApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ScaleApplicationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Integer diskLimit;
    private Integer instances;
    private Integer memoryLimit;
    private String name;
    private Duration stagingTimeout;
    private Duration startupTimeout;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ScaleApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ScaleApplicationRequest instance) {
      return from((_ScaleApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ScaleApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ScaleApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Integer diskLimitValue = instance.getDiskLimit();
      if (diskLimitValue != null) {
        diskLimit(diskLimitValue);
      }
      Integer instancesValue = instance.getInstances();
      if (instancesValue != null) {
        instances(instancesValue);
      }
      Integer memoryLimitValue = instance.getMemoryLimit();
      if (memoryLimitValue != null) {
        memoryLimit(memoryLimitValue);
      }
      name(instance.getName());
      stagingTimeout(instance.getStagingTimeout());
      startupTimeout(instance.getStartupTimeout());
      return this;
    }

    /**
     * Initializes the value for the {@link ScaleApplicationRequest#getDiskLimit() diskLimit} attribute.
     * @param diskLimit The value for diskLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskLimit(@Nullable Integer diskLimit) {
      this.diskLimit = diskLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link ScaleApplicationRequest#getInstances() instances} attribute.
     * @param instances The value for instances (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instances(@Nullable Integer instances) {
      this.instances = instances;
      return this;
    }

    /**
     * Initializes the value for the {@link ScaleApplicationRequest#getMemoryLimit() memoryLimit} attribute.
     * @param memoryLimit The value for memoryLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryLimit(@Nullable Integer memoryLimit) {
      this.memoryLimit = memoryLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link ScaleApplicationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ScaleApplicationRequest#getStagingTimeout() stagingTimeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ScaleApplicationRequest#getStagingTimeout() stagingTimeout}.</em>
     * @param stagingTimeout The value for stagingTimeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingTimeout(Duration stagingTimeout) {
      this.stagingTimeout = Objects.requireNonNull(stagingTimeout, "stagingTimeout");
      return this;
    }

    /**
     * Initializes the value for the {@link ScaleApplicationRequest#getStartupTimeout() startupTimeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ScaleApplicationRequest#getStartupTimeout() startupTimeout}.</em>
     * @param startupTimeout The value for startupTimeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startupTimeout(Duration startupTimeout) {
      this.startupTimeout = Objects.requireNonNull(startupTimeout, "startupTimeout");
      return this;
    }

    /**
     * Builds a new {@link ScaleApplicationRequest ScaleApplicationRequest}.
     * @return An immutable instance of ScaleApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ScaleApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ScaleApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build ScaleApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
