/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.networkpolicies;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.operations.networkpolicies._Policy;
import org.immutables.value.Generated;

@Generated(from="_Policy", generator="Immutables")
public final class Policy
extends _Policy {
    private final String destination;
    private final Integer endPort;
    private final String protocol;
    private final String source;
    private final Integer startPort;

    private Policy(Builder builder) {
        this.destination = builder.destination;
        this.endPort = builder.endPort;
        this.protocol = builder.protocol;
        this.source = builder.source;
        this.startPort = builder.startPort;
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    @Override
    public Integer getEndPort() {
        return this.endPort;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public Integer getStartPort() {
        return this.startPort;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Policy && this.equalTo((Policy)another);
    }

    private boolean equalTo(Policy another) {
        return this.destination.equals(another.destination) && this.endPort.equals(another.endPort) && this.protocol.equals(another.protocol) && this.source.equals(another.source) && this.startPort.equals(another.startPort);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.endPort.hashCode();
        h += (h << 5) + this.protocol.hashCode();
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.startPort.hashCode();
        return h;
    }

    public String toString() {
        return "Policy{destination=" + this.destination + ", endPort=" + this.endPort + ", protocol=" + this.protocol + ", source=" + this.source + ", startPort=" + this.startPort + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DESTINATION = 1L;
        private static final long INIT_BIT_END_PORT = 2L;
        private static final long INIT_BIT_PROTOCOL = 4L;
        private static final long INIT_BIT_SOURCE = 8L;
        private static final long INIT_BIT_START_PORT = 16L;
        private long initBits = 31L;
        private String destination;
        private Integer endPort;
        private String protocol;
        private String source;
        private Integer startPort;

        private Builder() {
        }

        public final Builder from(Policy instance) {
            return this.from((_Policy)instance);
        }

        final Builder from(_Policy instance) {
            Objects.requireNonNull(instance, "instance");
            this.destination(instance.getDestination());
            this.endPort(instance.getEndPort());
            this.protocol(instance.getProtocol());
            this.source(instance.getSource());
            this.startPort(instance.getStartPort());
            return this;
        }

        public final Builder destination(String destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder endPort(Integer endPort) {
            this.endPort = Objects.requireNonNull(endPort, "endPort");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder protocol(String protocol) {
            this.protocol = Objects.requireNonNull(protocol, "protocol");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder source(String source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder startPort(Integer startPort) {
            this.startPort = Objects.requireNonNull(startPort, "startPort");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Policy build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Policy(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("destination");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("endPort");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("protocol");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("startPort");
            }
            return "Cannot build Policy, some of required attributes are not set " + attributes;
        }
    }
}

