package org.cloudfoundry.operations.useradmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request options for the set space role operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_SetSpaceRoleRequest", generator = "Immutables")
public final class SetSpaceRoleRequest extends org.cloudfoundry.operations.useradmin._SetSpaceRoleRequest {
  private final String organizationName;
  private final String spaceName;
  private final SpaceRole spaceRole;
  private final String username;

  private SetSpaceRoleRequest(SetSpaceRoleRequest.Builder builder) {
    this.organizationName = builder.organizationName;
    this.spaceName = builder.spaceName;
    this.spaceRole = builder.spaceRole;
    this.username = builder.username;
  }

  /**
   * Organization name
   */
  @Override
  public String getOrganizationName() {
    return organizationName;
  }

  /**
   * Space name
   */
  @Override
  public String getSpaceName() {
    return spaceName;
  }

  /**
   * Role
   */
  @Override
  public SpaceRole getSpaceRole() {
    return spaceRole;
  }

  /**
   * Username
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code SetSpaceRoleRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SetSpaceRoleRequest
        && equalTo((SetSpaceRoleRequest) another);
  }

  private boolean equalTo(SetSpaceRoleRequest another) {
    return organizationName.equals(another.organizationName)
        && spaceName.equals(another.spaceName)
        && spaceRole.equals(another.spaceRole)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code organizationName}, {@code spaceName}, {@code spaceRole}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organizationName.hashCode();
    h += (h << 5) + spaceName.hashCode();
    h += (h << 5) + spaceRole.hashCode();
    h += (h << 5) + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SetSpaceRoleRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SetSpaceRoleRequest{"
        + "organizationName=" + organizationName
        + ", spaceName=" + spaceName
        + ", spaceRole=" + spaceRole
        + ", username=" + username
        + "}";
  }

  /**
   * Creates a builder for {@link SetSpaceRoleRequest SetSpaceRoleRequest}.
   * @return A new SetSpaceRoleRequest builder
   */
  public static SetSpaceRoleRequest.Builder builder() {
    return new SetSpaceRoleRequest.Builder();
  }

  /**
   * Builds instances of type {@link SetSpaceRoleRequest SetSpaceRoleRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_NAME = 0x1L;
    private static final long INIT_BIT_SPACE_NAME = 0x2L;
    private static final long INIT_BIT_SPACE_ROLE = 0x4L;
    private static final long INIT_BIT_USERNAME = 0x8L;
    private long initBits = 0xfL;

    private String organizationName;
    private String spaceName;
    private SpaceRole spaceRole;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SetSpaceRoleRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SetSpaceRoleRequest instance) {
      return from((_SetSpaceRoleRequest) instance);
    }

    /**
     * Copy abstract value type {@code _SetSpaceRoleRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SetSpaceRoleRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationName(instance.getOrganizationName());
      spaceName(instance.getSpaceName());
      spaceRole(instance.getSpaceRole());
      username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link SetSpaceRoleRequest#getOrganizationName() organizationName} attribute.
     * @param organizationName The value for organizationName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationName(String organizationName) {
      this.organizationName = Objects.requireNonNull(organizationName, "organizationName");
      initBits &= ~INIT_BIT_ORGANIZATION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SetSpaceRoleRequest#getSpaceName() spaceName} attribute.
     * @param spaceName The value for spaceName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceName(String spaceName) {
      this.spaceName = Objects.requireNonNull(spaceName, "spaceName");
      initBits &= ~INIT_BIT_SPACE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SetSpaceRoleRequest#getSpaceRole() spaceRole} attribute.
     * @param spaceRole The value for spaceRole 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceRole(SpaceRole spaceRole) {
      this.spaceRole = Objects.requireNonNull(spaceRole, "spaceRole");
      initBits &= ~INIT_BIT_SPACE_ROLE;
      return this;
    }

    /**
     * Initializes the value for the {@link SetSpaceRoleRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link SetSpaceRoleRequest SetSpaceRoleRequest}.
     * @return An immutable instance of SetSpaceRoleRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SetSpaceRoleRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new SetSpaceRoleRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_NAME) != 0) attributes.add("organizationName");
      if ((initBits & INIT_BIT_SPACE_NAME) != 0) attributes.add("spaceName");
      if ((initBits & INIT_BIT_SPACE_ROLE) != 0) attributes.add("spaceRole");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build SetSpaceRoleRequest, some of required attributes are not set " + attributes;
    }
  }
}
