package org.cloudfoundry.operations.applications;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request options for the restage application operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_RestageApplicationRequest", generator = "Immutables")
public final class RestageApplicationRequest
    extends org.cloudfoundry.operations.applications._RestageApplicationRequest {
  private final String name;
  private final Duration stagingTimeout;
  private final Duration startupTimeout;

  private RestageApplicationRequest(RestageApplicationRequest.Builder builder) {
    this.name = builder.name;
    if (builder.stagingTimeout != null) {
      initShim.stagingTimeout(builder.stagingTimeout);
    }
    if (builder.startupTimeout != null) {
      initShim.startupTimeout(builder.startupTimeout);
    }
    this.stagingTimeout = initShim.getStagingTimeout();
    this.startupTimeout = initShim.getStartupTimeout();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private byte stagingTimeoutBuildStage = STAGE_UNINITIALIZED;
    private Duration stagingTimeout;

    Duration getStagingTimeout() {
      if (stagingTimeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (stagingTimeoutBuildStage == STAGE_UNINITIALIZED) {
        stagingTimeoutBuildStage = STAGE_INITIALIZING;
        this.stagingTimeout = Objects.requireNonNull(RestageApplicationRequest.super.getStagingTimeout(), "stagingTimeout");
        stagingTimeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.stagingTimeout;
    }

    void stagingTimeout(Duration stagingTimeout) {
      this.stagingTimeout = stagingTimeout;
      stagingTimeoutBuildStage = STAGE_INITIALIZED;
    }

    private byte startupTimeoutBuildStage = STAGE_UNINITIALIZED;
    private Duration startupTimeout;

    Duration getStartupTimeout() {
      if (startupTimeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (startupTimeoutBuildStage == STAGE_UNINITIALIZED) {
        startupTimeoutBuildStage = STAGE_INITIALIZING;
        this.startupTimeout = Objects.requireNonNull(RestageApplicationRequest.super.getStartupTimeout(), "startupTimeout");
        startupTimeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.startupTimeout;
    }

    void startupTimeout(Duration startupTimeout) {
      this.startupTimeout = startupTimeout;
      startupTimeoutBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (stagingTimeoutBuildStage == STAGE_INITIALIZING) attributes.add("stagingTimeout");
      if (startupTimeoutBuildStage == STAGE_INITIALIZING) attributes.add("startupTimeout");
      return "Cannot build RestageApplicationRequest, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * The name of the application
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * How long to wait for staging
   */
  @Override
  public Duration getStagingTimeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getStagingTimeout()
        : this.stagingTimeout;
  }

  /**
   * How long to wait for startup
   */
  @Override
  public Duration getStartupTimeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getStartupTimeout()
        : this.startupTimeout;
  }

  /**
   * This instance is equal to all instances of {@code RestageApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RestageApplicationRequest
        && equalTo((RestageApplicationRequest) another);
  }

  private boolean equalTo(RestageApplicationRequest another) {
    return name.equals(another.name)
        && stagingTimeout.equals(another.stagingTimeout)
        && startupTimeout.equals(another.startupTimeout);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code stagingTimeout}, {@code startupTimeout}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + stagingTimeout.hashCode();
    h += (h << 5) + startupTimeout.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RestageApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RestageApplicationRequest{"
        + "name=" + name
        + ", stagingTimeout=" + stagingTimeout
        + ", startupTimeout=" + startupTimeout
        + "}";
  }

  /**
   * Creates a builder for {@link RestageApplicationRequest RestageApplicationRequest}.
   * @return A new RestageApplicationRequest builder
   */
  public static RestageApplicationRequest.Builder builder() {
    return new RestageApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link RestageApplicationRequest RestageApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;
    private Duration stagingTimeout;
    private Duration startupTimeout;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RestageApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RestageApplicationRequest instance) {
      return from((_RestageApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RestageApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RestageApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      stagingTimeout(instance.getStagingTimeout());
      startupTimeout(instance.getStartupTimeout());
      return this;
    }

    /**
     * Initializes the value for the {@link RestageApplicationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link RestageApplicationRequest#getStagingTimeout() stagingTimeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link RestageApplicationRequest#getStagingTimeout() stagingTimeout}.</em>
     * @param stagingTimeout The value for stagingTimeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingTimeout(Duration stagingTimeout) {
      this.stagingTimeout = Objects.requireNonNull(stagingTimeout, "stagingTimeout");
      return this;
    }

    /**
     * Initializes the value for the {@link RestageApplicationRequest#getStartupTimeout() startupTimeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link RestageApplicationRequest#getStartupTimeout() startupTimeout}.</em>
     * @param startupTimeout The value for startupTimeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startupTimeout(Duration startupTimeout) {
      this.startupTimeout = Objects.requireNonNull(startupTimeout, "startupTimeout");
      return this;
    }

    /**
     * Builds a new {@link RestageApplicationRequest RestageApplicationRequest}.
     * @return An immutable instance of RestageApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RestageApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RestageApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build RestageApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
