/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.services._UnbindRouteServiceInstanceRequest;
import org.immutables.value.Generated;

@Generated(from="_UnbindRouteServiceInstanceRequest", generator="Immutables")
public final class UnbindRouteServiceInstanceRequest
extends _UnbindRouteServiceInstanceRequest {
    private final String domainName;
    @Nullable
    private final String hostname;
    @Nullable
    private final String path;
    private final String serviceInstanceName;

    private UnbindRouteServiceInstanceRequest(Builder builder) {
        this.domainName = builder.domainName;
        this.hostname = builder.hostname;
        this.path = builder.path;
        this.serviceInstanceName = builder.serviceInstanceName;
    }

    @Override
    public String getDomainName() {
        return this.domainName;
    }

    @Override
    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    @Override
    @Nullable
    public String getPath() {
        return this.path;
    }

    @Override
    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UnbindRouteServiceInstanceRequest && this.equalTo((UnbindRouteServiceInstanceRequest)another);
    }

    private boolean equalTo(UnbindRouteServiceInstanceRequest another) {
        return this.domainName.equals(another.domainName) && Objects.equals(this.hostname, another.hostname) && Objects.equals(this.path, another.path) && this.serviceInstanceName.equals(another.serviceInstanceName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.domainName.hashCode();
        h += (h << 5) + Objects.hashCode(this.hostname);
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + this.serviceInstanceName.hashCode();
        return h;
    }

    public String toString() {
        return "UnbindRouteServiceInstanceRequest{domainName=" + this.domainName + ", hostname=" + this.hostname + ", path=" + this.path + ", serviceInstanceName=" + this.serviceInstanceName + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DOMAIN_NAME = 1L;
        private static final long INIT_BIT_SERVICE_INSTANCE_NAME = 2L;
        private long initBits = 3L;
        private String domainName;
        private String hostname;
        private String path;
        private String serviceInstanceName;

        private Builder() {
        }

        public final Builder from(UnbindRouteServiceInstanceRequest instance) {
            return this.from((_UnbindRouteServiceInstanceRequest)instance);
        }

        final Builder from(_UnbindRouteServiceInstanceRequest instance) {
            String pathValue;
            Objects.requireNonNull(instance, "instance");
            this.domainName(instance.getDomainName());
            String hostnameValue = instance.getHostname();
            if (hostnameValue != null) {
                this.hostname(hostnameValue);
            }
            if ((pathValue = instance.getPath()) != null) {
                this.path(pathValue);
            }
            this.serviceInstanceName(instance.getServiceInstanceName());
            return this;
        }

        public final Builder domainName(String domainName) {
            this.domainName = Objects.requireNonNull(domainName, "domainName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder hostname(@Nullable String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = Objects.requireNonNull(serviceInstanceName, "serviceInstanceName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public UnbindRouteServiceInstanceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UnbindRouteServiceInstanceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("domainName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("serviceInstanceName");
            }
            return "Cannot build UnbindRouteServiceInstanceRequest, some of required attributes are not set " + attributes;
        }
    }
}

