/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.operations.services._ServiceKey;
import org.immutables.value.Generated;

@Generated(from="_ServiceKey", generator="Immutables")
public final class ServiceKey
extends _ServiceKey {
    private final Map<String, Object> credentials;
    private final String id;
    private final String name;

    private ServiceKey(Builder builder) {
        this.credentials = ServiceKey.createUnmodifiableMap(false, false, builder.credentials);
        this.id = builder.id;
        this.name = builder.name;
    }

    @Override
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServiceKey && this.equalTo((ServiceKey)another);
    }

    private boolean equalTo(ServiceKey another) {
        return this.credentials.equals(another.credentials) && this.id.equals(another.id) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.credentials.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return "ServiceKey{credentials=" + this.credentials + ", id=" + this.id + ", name=" + this.name + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        private Map<String, Object> credentials = new LinkedHashMap<String, Object>();
        private String id;
        private String name;

        private Builder() {
        }

        public final Builder from(ServiceKey instance) {
            return this.from((_ServiceKey)instance);
        }

        final Builder from(_ServiceKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllCredentials(instance.getCredentials());
            this.id(instance.getId());
            this.name(instance.getName());
            return this;
        }

        public final Builder credential(String key, Object value) {
            this.credentials.put(key, value);
            return this;
        }

        public final Builder credential(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.credentials.put(k, v);
            return this;
        }

        public final Builder credentials(Map<String, ? extends Object> entries) {
            this.credentials.clear();
            return this.putAllCredentials(entries);
        }

        public final Builder putAllCredentials(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.credentials.put(k, v);
            }
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ServiceKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ServiceKey(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build ServiceKey, some of required attributes are not set " + attributes;
        }
    }
}

