package org.cloudfoundry.operations.services;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request options for the create service instance operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_CreateServiceInstanceRequest", generator = "Immutables")
public final class CreateServiceInstanceRequest
    extends org.cloudfoundry.operations.services._CreateServiceInstanceRequest {
  private final Duration completionTimeout;
  private final @Nullable Map<String, Object> parameters;
  private final String planName;
  private final String serviceInstanceName;
  private final String serviceName;
  private final @Nullable List<String> tags;

  private CreateServiceInstanceRequest(CreateServiceInstanceRequest.Builder builder) {
    this.parameters = builder.parameters == null ? null : createUnmodifiableMap(false, false, builder.parameters);
    this.planName = builder.planName;
    this.serviceInstanceName = builder.serviceInstanceName;
    this.serviceName = builder.serviceName;
    this.tags = builder.tags == null ? null : createUnmodifiableList(true, builder.tags);
    this.completionTimeout = builder.completionTimeout != null
        ? builder.completionTimeout
        : Objects.requireNonNull(super.getCompletionTimeout(), "completionTimeout");
  }

  /**
   * How long to wait for creation
   */
  @Override
  public Duration getCompletionTimeout() {
    return completionTimeout;
  }

  /**
   * The parameters of the service instance
   */
  @Override
  public @Nullable Map<String, Object> getParameters() {
    return parameters;
  }

  /**
   * The name of the service plan to use
   */
  @Override
  public String getPlanName() {
    return planName;
  }

  /**
   * The name of the service instance to create
   */
  @Override
  public String getServiceInstanceName() {
    return serviceInstanceName;
  }

  /**
   * The name of the service
   */
  @Override
  public String getServiceName() {
    return serviceName;
  }

  /**
   * The tags
   */
  @Override
  public @Nullable List<String> getTags() {
    return tags;
  }

  /**
   * This instance is equal to all instances of {@code CreateServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateServiceInstanceRequest
        && equalTo((CreateServiceInstanceRequest) another);
  }

  private boolean equalTo(CreateServiceInstanceRequest another) {
    return completionTimeout.equals(another.completionTimeout)
        && Objects.equals(parameters, another.parameters)
        && planName.equals(another.planName)
        && serviceInstanceName.equals(another.serviceInstanceName)
        && serviceName.equals(another.serviceName)
        && Objects.equals(tags, another.tags);
  }

  /**
   * Computes a hash code from attributes: {@code completionTimeout}, {@code parameters}, {@code planName}, {@code serviceInstanceName}, {@code serviceName}, {@code tags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + completionTimeout.hashCode();
    h += (h << 5) + Objects.hashCode(parameters);
    h += (h << 5) + planName.hashCode();
    h += (h << 5) + serviceInstanceName.hashCode();
    h += (h << 5) + serviceName.hashCode();
    h += (h << 5) + Objects.hashCode(tags);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateServiceInstanceRequest{"
        + "completionTimeout=" + completionTimeout
        + ", parameters=" + parameters
        + ", planName=" + planName
        + ", serviceInstanceName=" + serviceInstanceName
        + ", serviceName=" + serviceName
        + ", tags=" + tags
        + "}";
  }

  /**
   * Creates a builder for {@link CreateServiceInstanceRequest CreateServiceInstanceRequest}.
   * @return A new CreateServiceInstanceRequest builder
   */
  public static CreateServiceInstanceRequest.Builder builder() {
    return new CreateServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateServiceInstanceRequest CreateServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_PLAN_NAME = 0x1L;
    private static final long INIT_BIT_SERVICE_INSTANCE_NAME = 0x2L;
    private static final long INIT_BIT_SERVICE_NAME = 0x4L;
    private long initBits = 0x7L;

    private Duration completionTimeout;
    private Map<String, Object> parameters = null;
    private String planName;
    private String serviceInstanceName;
    private String serviceName;
    private List<String> tags = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateServiceInstanceRequest instance) {
      return from((_CreateServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      completionTimeout(instance.getCompletionTimeout());
      Map<String, Object> parametersValue = instance.getParameters();
      if (parametersValue != null) {
        putAllParameters(parametersValue);
      }
      planName(instance.getPlanName());
      serviceInstanceName(instance.getServiceInstanceName());
      serviceName(instance.getServiceName());
      List<String> tagsValue = instance.getTags();
      if (tagsValue != null) {
        addAllTags(tagsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceInstanceRequest#getCompletionTimeout() completionTimeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link CreateServiceInstanceRequest#getCompletionTimeout() completionTimeout}.</em>
     * @param completionTimeout The value for completionTimeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder completionTimeout(Duration completionTimeout) {
      this.completionTimeout = Objects.requireNonNull(completionTimeout, "completionTimeout");
      return this;
    }

    /**
     * Put one entry to the {@link CreateServiceInstanceRequest#getParameters() parameters} map.
     * @param key The key in the parameters map
     * @param value The associated value in the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(String key, Object value) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      this.parameters.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CreateServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.parameters.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CreateServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameters(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.parameters = null;
        return this;
      }
      this.parameters = new LinkedHashMap<String, Object>();
      return putAllParameters(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CreateServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllParameters(Map<String, ? extends Object> entries) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.parameters.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceInstanceRequest#getPlanName() planName} attribute.
     * @param planName The value for planName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder planName(String planName) {
      this.planName = Objects.requireNonNull(planName, "planName");
      initBits &= ~INIT_BIT_PLAN_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceInstanceRequest#getServiceInstanceName() serviceInstanceName} attribute.
     * @param serviceInstanceName The value for serviceInstanceName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceName(String serviceInstanceName) {
      this.serviceInstanceName = Objects.requireNonNull(serviceInstanceName, "serviceInstanceName");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceInstanceRequest#getServiceName() serviceName} attribute.
     * @param serviceName The value for serviceName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceName(String serviceName) {
      this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
      initBits &= ~INIT_BIT_SERVICE_NAME;
      return this;
    }

    /**
     * Adds one element to {@link CreateServiceInstanceRequest#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String element) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateServiceInstanceRequest#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(String... elements) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateServiceInstanceRequest#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.tags = null;
        return this;
      }
      this.tags = new ArrayList<String>();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link CreateServiceInstanceRequest#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      Objects.requireNonNull(elements, "tags element");
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Builds a new {@link CreateServiceInstanceRequest CreateServiceInstanceRequest}.
     * @return An immutable instance of CreateServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PLAN_NAME) != 0) attributes.add("planName");
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_NAME) != 0) attributes.add("serviceInstanceName");
      if ((initBits & INIT_BIT_SERVICE_NAME) != 0) attributes.add("serviceName");
      return "Cannot build CreateServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
