package org.cloudfoundry.operations.routes;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request options for the map route operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_DeleteRouteRequest", generator = "Immutables")
public final class DeleteRouteRequest extends org.cloudfoundry.operations.routes._DeleteRouteRequest {
  private final Duration completionTimeout;
  private final String domain;
  private final @Nullable String host;
  private final @Nullable String path;
  private final @Nullable Integer port;

  private DeleteRouteRequest(DeleteRouteRequest.Builder builder) {
    this.domain = builder.domain;
    this.host = builder.host;
    this.path = builder.path;
    this.port = builder.port;
    this.completionTimeout = builder.completionTimeout != null
        ? builder.completionTimeout
        : Objects.requireNonNull(super.getCompletionTimeout(), "completionTimeout");
  }

  /**
   * How long to wait for deletion
   */
  @Override
  public Duration getCompletionTimeout() {
    return completionTimeout;
  }

  /**
   * The domain of the route
   */
  @Override
  public String getDomain() {
    return domain;
  }

  /**
   * The host of the route
   */
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The path of the route.
   * <p>
   * Note: the path is specified without a leading "/"
   */
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The port of the route
   */
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * This instance is equal to all instances of {@code DeleteRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteRouteRequest
        && equalTo((DeleteRouteRequest) another);
  }

  private boolean equalTo(DeleteRouteRequest another) {
    return completionTimeout.equals(another.completionTimeout)
        && domain.equals(another.domain)
        && Objects.equals(host, another.host)
        && Objects.equals(path, another.path)
        && Objects.equals(port, another.port);
  }

  /**
   * Computes a hash code from attributes: {@code completionTimeout}, {@code domain}, {@code host}, {@code path}, {@code port}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + completionTimeout.hashCode();
    h += (h << 5) + domain.hashCode();
    h += (h << 5) + Objects.hashCode(host);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(port);
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteRouteRequest{"
        + "completionTimeout=" + completionTimeout
        + ", domain=" + domain
        + ", host=" + host
        + ", path=" + path
        + ", port=" + port
        + "}";
  }


  private static DeleteRouteRequest validate(DeleteRouteRequest instance) {
    instance.checkSetup();
    return instance;
  }

  /**
   * Creates a builder for {@link DeleteRouteRequest DeleteRouteRequest}.
   * @return A new DeleteRouteRequest builder
   */
  public static DeleteRouteRequest.Builder builder() {
    return new DeleteRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteRouteRequest DeleteRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN = 0x1L;
    private long initBits = 0x1L;

    private Duration completionTimeout;
    private String domain;
    private String host;
    private String path;
    private Integer port;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteRouteRequest instance) {
      return from((_DeleteRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      completionTimeout(instance.getCompletionTimeout());
      domain(instance.getDomain());
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      Integer portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteRouteRequest#getCompletionTimeout() completionTimeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DeleteRouteRequest#getCompletionTimeout() completionTimeout}.</em>
     * @param completionTimeout The value for completionTimeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder completionTimeout(Duration completionTimeout) {
      this.completionTimeout = Objects.requireNonNull(completionTimeout, "completionTimeout");
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteRouteRequest#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String domain) {
      this.domain = Objects.requireNonNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteRouteRequest#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteRouteRequest#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteRouteRequest#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Builds a new {@link DeleteRouteRequest DeleteRouteRequest}.
     * @return An immutable instance of DeleteRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return DeleteRouteRequest.validate(new DeleteRouteRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN) != 0) attributes.add("domain");
      return "Cannot build DeleteRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
