package org.cloudfoundry.operations.applications;

import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Docker object representation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_Docker", generator = "Immutables")
public final class Docker extends org.cloudfoundry.operations.applications._Docker {
  private final @Nullable String image;
  private final @Nullable String password;
  private final @Nullable String username;

  private Docker(Docker.Builder builder) {
    this.image = builder.image;
    this.password = builder.password;
    this.username = builder.username;
  }

  /**
   * The docker image
   */
  @Override
  public @Nullable String getImage() {
    return image;
  }

  /**
   * The password for the docker repository
   */
  @Override
  public @Nullable String getPassword() {
    return password;
  }

  /**
   * The username for the docker repository
   */
  @Override
  public @Nullable String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code Docker} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Docker
        && equalTo((Docker) another);
  }

  private boolean equalTo(Docker another) {
    return Objects.equals(image, another.image)
        && Objects.equals(password, another.password)
        && Objects.equals(username, another.username);
  }

  /**
   * Computes a hash code from attributes: {@code image}, {@code password}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(image);
    h += (h << 5) + Objects.hashCode(password);
    h += (h << 5) + Objects.hashCode(username);
    return h;
  }

  /**
   * Prints the immutable value {@code Docker} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Docker{"
        + "image=" + image
        + ", password=" + password
        + ", username=" + username
        + "}";
  }

  /**
   * Creates a builder for {@link Docker Docker}.
   * @return A new Docker builder
   */
  public static Docker.Builder builder() {
    return new Docker.Builder();
  }

  /**
   * Builds instances of type {@link Docker Docker}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String image;
    private String password;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Docker} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Docker instance) {
      return from((_Docker) instance);
    }

    /**
     * Copy abstract value type {@code _Docker} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Docker instance) {
      Objects.requireNonNull(instance, "instance");
      String imageValue = instance.getImage();
      if (imageValue != null) {
        image(imageValue);
      }
      String passwordValue = instance.getPassword();
      if (passwordValue != null) {
        password(passwordValue);
      }
      String usernameValue = instance.getUsername();
      if (usernameValue != null) {
        username(usernameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Docker#getImage() image} attribute.
     * @param image The value for image (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder image(@Nullable String image) {
      this.image = image;
      return this;
    }

    /**
     * Initializes the value for the {@link Docker#getPassword() password} attribute.
     * @param password The value for password (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(@Nullable String password) {
      this.password = password;
      return this;
    }

    /**
     * Initializes the value for the {@link Docker#getUsername() username} attribute.
     * @param username The value for username (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(@Nullable String username) {
      this.username = username;
      return this;
    }

    /**
     * Builds a new {@link Docker Docker}.
     * @return An immutable instance of Docker
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Docker build() {
      return new Docker(this);
    }
  }
}
