/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.services._BindServiceInstanceRequest;
import org.immutables.value.Generated;

@Generated(from="_BindServiceInstanceRequest", generator="Immutables")
public final class BindServiceInstanceRequest
extends _BindServiceInstanceRequest {
    private final String applicationName;
    @Nullable
    private final Map<String, Object> parameters;
    private final String serviceInstanceName;

    private BindServiceInstanceRequest(Builder builder) {
        this.applicationName = builder.applicationName;
        this.parameters = builder.parameters == null ? null : BindServiceInstanceRequest.createUnmodifiableMap(false, false, builder.parameters);
        this.serviceInstanceName = builder.serviceInstanceName;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    @Nullable
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BindServiceInstanceRequest && this.equalTo((BindServiceInstanceRequest)another);
    }

    private boolean equalTo(BindServiceInstanceRequest another) {
        return this.applicationName.equals(another.applicationName) && Objects.equals(this.parameters, another.parameters) && this.serviceInstanceName.equals(another.serviceInstanceName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationName.hashCode();
        h += (h << 5) + Objects.hashCode(this.parameters);
        h += (h << 5) + this.serviceInstanceName.hashCode();
        return h;
    }

    public String toString() {
        return "BindServiceInstanceRequest{applicationName=" + this.applicationName + ", parameters=" + this.parameters + ", serviceInstanceName=" + this.serviceInstanceName + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_NAME = 1L;
        private static final long INIT_BIT_SERVICE_INSTANCE_NAME = 2L;
        private long initBits = 3L;
        private String applicationName;
        private Map<String, Object> parameters = null;
        private String serviceInstanceName;

        private Builder() {
        }

        public final Builder from(BindServiceInstanceRequest instance) {
            return this.from((_BindServiceInstanceRequest)instance);
        }

        final Builder from(_BindServiceInstanceRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.applicationName(instance.getApplicationName());
            Map<String, Object> parametersValue = instance.getParameters();
            if (parametersValue != null) {
                this.putAllParameters(parametersValue);
            }
            this.serviceInstanceName(instance.getServiceInstanceName());
            return this;
        }

        public final Builder applicationName(String applicationName) {
            this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder parameter(String key, Object value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            this.parameters.put(key, value);
            return this;
        }

        public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.parameters.put(k, v);
            return this;
        }

        public final Builder parameters(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.parameters = null;
                return this;
            }
            this.parameters = new LinkedHashMap<String, Object>();
            return this.putAllParameters(entries);
        }

        public final Builder putAllParameters(Map<String, ? extends Object> entries) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.parameters.put(k, v);
            }
            return this;
        }

        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = Objects.requireNonNull(serviceInstanceName, "serviceInstanceName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public BindServiceInstanceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new BindServiceInstanceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("serviceInstanceName");
            }
            return "Cannot build BindServiceInstanceRequest, some of required attributes are not set " + attributes;
        }
    }
}

