package org.cloudfoundry.operations.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * A Cloud Foundry Organization
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_OrganizationSummary", generator = "Immutables")
public final class OrganizationSummary extends org.cloudfoundry.operations.organizations._OrganizationSummary {
  private final String id;
  private final String name;

  private OrganizationSummary(OrganizationSummary.Builder builder) {
    this.id = builder.id;
    this.name = builder.name;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code OrganizationSummary} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OrganizationSummary
        && equalTo((OrganizationSummary) another);
  }

  private boolean equalTo(OrganizationSummary another) {
    return id.equals(another.id)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OrganizationSummary} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OrganizationSummary{"
        + "id=" + id
        + ", name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link OrganizationSummary OrganizationSummary}.
   * @return A new OrganizationSummary builder
   */
  public static OrganizationSummary.Builder builder() {
    return new OrganizationSummary.Builder();
  }

  /**
   * Builds instances of type {@link OrganizationSummary OrganizationSummary}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private long initBits = 0x3L;

    private String id;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OrganizationSummary} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OrganizationSummary instance) {
      return from((_OrganizationSummary) instance);
    }

    /**
     * Copy abstract value type {@code _OrganizationSummary} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_OrganizationSummary instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationSummary#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationSummary#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link OrganizationSummary OrganizationSummary}.
     * @return An immutable instance of OrganizationSummary
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OrganizationSummary build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new OrganizationSummary(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build OrganizationSummary, some of required attributes are not set " + attributes;
    }
  }
}
