/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.spaces;

import java.util.Map;
import org.cloudfoundry.client.v3.spaces.AssignSpaceIsolationSegmentRequest;
import org.cloudfoundry.client.v3.spaces.AssignSpaceIsolationSegmentResponse;
import org.cloudfoundry.client.v3.spaces.CreateSpaceRequest;
import org.cloudfoundry.client.v3.spaces.CreateSpaceResponse;
import org.cloudfoundry.client.v3.spaces.DeleteSpaceRequest;
import org.cloudfoundry.client.v3.spaces.DeleteUnmappedRoutesRequest;
import org.cloudfoundry.client.v3.spaces.GetSpaceIsolationSegmentRequest;
import org.cloudfoundry.client.v3.spaces.GetSpaceIsolationSegmentResponse;
import org.cloudfoundry.client.v3.spaces.GetSpaceRequest;
import org.cloudfoundry.client.v3.spaces.GetSpaceResponse;
import org.cloudfoundry.client.v3.spaces.ListSpacesRequest;
import org.cloudfoundry.client.v3.spaces.ListSpacesResponse;
import org.cloudfoundry.client.v3.spaces.SpacesV3;
import org.cloudfoundry.client.v3.spaces.UpdateSpaceRequest;
import org.cloudfoundry.client.v3.spaces.UpdateSpaceResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorSpacesV3
extends AbstractClientV3Operations
implements SpacesV3 {
    public ReactorSpacesV3(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<AssignSpaceIsolationSegmentResponse> assignIsolationSegment(AssignSpaceIsolationSegmentRequest request) {
        return this.patch(request, AssignSpaceIsolationSegmentResponse.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "relationships", "isolation_segment"})).checkpoint();
    }

    public Mono<CreateSpaceResponse> create(CreateSpaceRequest request) {
        return this.post(request, CreateSpaceResponse.class, builder -> builder.pathSegment(new String[]{"spaces"})).checkpoint();
    }

    public Mono<String> delete(DeleteSpaceRequest request) {
        return this.delete(request, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId()})).checkpoint();
    }

    public Mono<String> deleteUnmappedRoutes(DeleteUnmappedRoutesRequest request) {
        return this.delete(request, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "routes"}).query("unmapped=true")).checkpoint();
    }

    public Mono<GetSpaceResponse> get(GetSpaceRequest request) {
        return this.get((Object)request, GetSpaceResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId()})).checkpoint();
    }

    public Mono<GetSpaceIsolationSegmentResponse> getIsolationSegment(GetSpaceIsolationSegmentRequest request) {
        return this.get((Object)request, GetSpaceIsolationSegmentResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "relationships", "isolation_segment"})).checkpoint();
    }

    public Mono<ListSpacesResponse> list(ListSpacesRequest request) {
        return this.get((Object)request, ListSpacesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces"})).checkpoint();
    }

    public Mono<UpdateSpaceResponse> update(UpdateSpaceRequest request) {
        return this.patch(request, UpdateSpaceResponse.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId()})).checkpoint();
    }
}

