/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudfoundry.client.v2.FilterParameter;
import org.cloudfoundry.reactor.util.AnnotationUtils;
import org.cloudfoundry.reactor.util.UriQueryParameter;
import org.cloudfoundry.reactor.util.UriQueryParameterBuilder;

final class FilterBuilder
implements UriQueryParameterBuilder {
    FilterBuilder() {
    }

    @Override
    public Stream<UriQueryParameter> build(Object instance) {
        return AnnotationUtils.streamAnnotatedValues(instance, FilterParameter.class).map(FilterBuilder::processValue).filter(Objects::nonNull);
    }

    private static UriQueryParameter processCollection(FilterParameter filterParameter, Object value) {
        List<String> collection = ((Collection)value).stream().map(Object::toString).map(String::trim).collect(Collectors.toList());
        if (collection.size() == 1) {
            return FilterBuilder.processValue(filterParameter.value(), filterParameter.operation(), (String)collection.get(0));
        }
        if (collection.size() > 1) {
            return FilterBuilder.processValue(filterParameter.value(), filterParameter.collectionOperation(), collection);
        }
        return null;
    }

    private static UriQueryParameter processValue(AnnotationUtils.AnnotatedValue<FilterParameter> annotatedValue) {
        FilterParameter filterParameter = annotatedValue.getAnnotation();
        Object value = annotatedValue.getValue();
        if (value instanceof Collection) {
            return FilterBuilder.processCollection(filterParameter, value);
        }
        return FilterBuilder.processValue(filterParameter.value(), filterParameter.operation(), value.toString().trim());
    }

    private static UriQueryParameter processValue(String name, FilterParameter.Operation operation, Collection<String> collection) {
        String value = String.join((CharSequence)",", collection);
        if (!value.isEmpty()) {
            return FilterBuilder.processValue(name, operation, value);
        }
        return null;
    }

    private static UriQueryParameter processValue(String name, FilterParameter.Operation operation, String value) {
        return UriQueryParameter.of("q", String.format("%s%s%s", name, operation, value));
    }
}

