/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.routing.v1.tcproutes;

import io.netty.handler.codec.LineBasedFrameDecoder;
import org.cloudfoundry.reactor.routing.v1.tcproutes.ServerSentEvent;
import reactor.core.publisher.Flux;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClientResponse;

final class EventStreamCodec {
    private static final int MAX_PAYLOAD_SIZE = 0x100000;

    private EventStreamCodec() {
    }

    static LineBasedFrameDecoder createDecoder(HttpClientResponse response) {
        return new LineBasedFrameDecoder(0x100000);
    }

    static Flux<ServerSentEvent> decode(ByteBufFlux body) {
        return body.asString().windowWhile(s -> !s.isEmpty()).concatMap(window -> window.reduce((Object)ServerSentEvent.builder(), EventStreamCodec::parseLine)).map(ServerSentEvent.Builder::build).filter(sse -> sse.getData() != null || sse.getEventType() != null || sse.getId() != null || sse.getRetry() != null);
    }

    private static Field parseField(String line) {
        String[] split = line.split("[ ]?:[ ]?", 2);
        String key = split.length > 0 ? split[0] : "";
        String value = split.length > 1 ? split[1] : "";
        return new Field(key, value);
    }

    private static ServerSentEvent.Builder parseLine(ServerSentEvent.Builder builder, String line) {
        Field field = EventStreamCodec.parseField(line);
        if ("data".equals(field.getKey())) {
            builder.data(field.getValue());
        } else if ("event".equals(field.getKey())) {
            builder.eventType(field.getValue());
        } else if ("id".equals(field.getKey())) {
            builder.id(field.getValue());
        } else if ("retry".equals(field.getKey())) {
            builder.retry(Integer.parseInt(field.getValue()));
        }
        return builder;
    }

    private static final class Field {
        private final String key;
        private final String value;

        private Field(String key, String value) {
            this.key = key;
            this.value = value;
        }

        private String getKey() {
            return this.key;
        }

        private String getValue() {
            return this.value;
        }
    }
}

