/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.roles;

import java.util.Map;
import org.cloudfoundry.client.v3.roles.CreateRoleRequest;
import org.cloudfoundry.client.v3.roles.CreateRoleResponse;
import org.cloudfoundry.client.v3.roles.DeleteRoleRequest;
import org.cloudfoundry.client.v3.roles.GetRoleRequest;
import org.cloudfoundry.client.v3.roles.GetRoleResponse;
import org.cloudfoundry.client.v3.roles.ListRolesRequest;
import org.cloudfoundry.client.v3.roles.ListRolesResponse;
import org.cloudfoundry.client.v3.roles.RolesV3;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorRolesV3
extends AbstractClientV3Operations
implements RolesV3 {
    public ReactorRolesV3(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<CreateRoleResponse> create(CreateRoleRequest request) {
        return this.post(request, CreateRoleResponse.class, uriComponentsBuilder -> uriComponentsBuilder.pathSegment(new String[]{"roles"})).checkpoint();
    }

    public Mono<String> delete(DeleteRoleRequest request) {
        return this.delete(request, uriComponentsBuilder -> uriComponentsBuilder.pathSegment(new String[]{"roles", request.getRoleId()})).checkpoint();
    }

    public Mono<GetRoleResponse> get(GetRoleRequest request) {
        return this.get((Object)request, GetRoleResponse.class, (UriComponentsBuilder uriComponentsBuilder) -> uriComponentsBuilder.pathSegment(new String[]{"roles", request.getRoleId()})).checkpoint();
    }

    public Mono<ListRolesResponse> list(ListRolesRequest request) {
        return this.get((Object)request, ListRolesResponse.class, (UriComponentsBuilder uriComponentsBuilder) -> uriComponentsBuilder.pathSegment(new String[]{"roles"})).checkpoint();
    }
}

