/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.builpacks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import org.cloudfoundry.client.v3.buildpacks.BuildpacksV3;
import org.cloudfoundry.client.v3.buildpacks.CreateBuildpackRequest;
import org.cloudfoundry.client.v3.buildpacks.CreateBuildpackResponse;
import org.cloudfoundry.client.v3.buildpacks.DeleteBuildpackRequest;
import org.cloudfoundry.client.v3.buildpacks.GetBuildpackRequest;
import org.cloudfoundry.client.v3.buildpacks.GetBuildpackResponse;
import org.cloudfoundry.client.v3.buildpacks.ListBuildpacksRequest;
import org.cloudfoundry.client.v3.buildpacks.ListBuildpacksResponse;
import org.cloudfoundry.client.v3.buildpacks.UpdateBuildpackRequest;
import org.cloudfoundry.client.v3.buildpacks.UpdateBuildpackResponse;
import org.cloudfoundry.client.v3.buildpacks.UploadBuildpackRequest;
import org.cloudfoundry.client.v3.buildpacks.UploadBuildpackResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.cloudfoundry.reactor.util.MultipartHttpClientRequest;
import org.cloudfoundry.util.FileUtils;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public final class ReactorBuildpacksV3
extends AbstractClientV3Operations
implements BuildpacksV3 {
    public ReactorBuildpacksV3(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<CreateBuildpackResponse> create(CreateBuildpackRequest request) {
        return this.post(request, CreateBuildpackResponse.class, builder -> builder.pathSegment(new String[]{"buildpacks"})).checkpoint();
    }

    public Mono<String> delete(DeleteBuildpackRequest request) {
        return this.delete(request, builder -> builder.pathSegment(new String[]{"buildpacks", request.getBuildpackId()})).checkpoint();
    }

    public Mono<GetBuildpackResponse> get(GetBuildpackRequest request) {
        return this.get((Object)request, GetBuildpackResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"buildpacks", request.getBuildpackId()})).checkpoint();
    }

    public Mono<ListBuildpacksResponse> list(ListBuildpacksRequest request) {
        return this.get((Object)request, ListBuildpacksResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"buildpacks"})).checkpoint();
    }

    public Mono<UpdateBuildpackResponse> update(UpdateBuildpackRequest request) {
        return this.patch(request, UpdateBuildpackResponse.class, builder -> builder.pathSegment(new String[]{"buildpacks", request.getBuildpackId()})).checkpoint();
    }

    public Mono<UploadBuildpackResponse> upload(UploadBuildpackRequest request) {
        Path bits = request.getBits();
        if (bits.toFile().isDirectory()) {
            return FileUtils.compress((Path)bits).map(temporaryFile -> UploadBuildpackRequest.builder().from(request).bits(temporaryFile).build()).flatMap(requestWithTemporaryFile -> this.upload((UploadBuildpackRequest)requestWithTemporaryFile, () -> {
                try {
                    Files.delete(requestWithTemporaryFile.getBits());
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }));
        }
        return this.upload(request, () -> {});
    }

    private Mono<UploadBuildpackResponse> upload(UploadBuildpackRequest request, Runnable onTerminate) {
        return this.post(request, UploadBuildpackResponse.class, builder -> builder.pathSegment(new String[]{"buildpacks", request.getBuildpackId(), "upload"}), outbound -> this.upload(request.getBits(), (MultipartHttpClientRequest)outbound), onTerminate).checkpoint();
    }

    private void upload(Path bits, MultipartHttpClientRequest r) {
        r.addPart(part -> part.setName("bits").setContentType("application/zip").sendFile(bits)).done();
    }
}

