/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.spaces;

import java.util.Map;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceAuditorByUsernameRequest;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceAuditorByUsernameResponse;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceAuditorRequest;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceAuditorResponse;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceDeveloperByUsernameRequest;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceDeveloperByUsernameResponse;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceDeveloperRequest;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceDeveloperResponse;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceManagerByUsernameRequest;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceManagerByUsernameResponse;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceManagerRequest;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceManagerResponse;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceSecurityGroupRequest;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceSecurityGroupResponse;
import org.cloudfoundry.client.v2.spaces.CreateSpaceRequest;
import org.cloudfoundry.client.v2.spaces.CreateSpaceResponse;
import org.cloudfoundry.client.v2.spaces.DeleteSpaceRequest;
import org.cloudfoundry.client.v2.spaces.DeleteSpaceResponse;
import org.cloudfoundry.client.v2.spaces.GetSpaceRequest;
import org.cloudfoundry.client.v2.spaces.GetSpaceResponse;
import org.cloudfoundry.client.v2.spaces.GetSpaceSummaryRequest;
import org.cloudfoundry.client.v2.spaces.GetSpaceSummaryResponse;
import org.cloudfoundry.client.v2.spaces.ListSpaceApplicationsRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceApplicationsResponse;
import org.cloudfoundry.client.v2.spaces.ListSpaceAuditorsRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceAuditorsResponse;
import org.cloudfoundry.client.v2.spaces.ListSpaceDevelopersRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceDevelopersResponse;
import org.cloudfoundry.client.v2.spaces.ListSpaceDomainsRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceDomainsResponse;
import org.cloudfoundry.client.v2.spaces.ListSpaceEventsRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceEventsResponse;
import org.cloudfoundry.client.v2.spaces.ListSpaceManagersRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceManagersResponse;
import org.cloudfoundry.client.v2.spaces.ListSpaceRoutesRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceRoutesResponse;
import org.cloudfoundry.client.v2.spaces.ListSpaceSecurityGroupsRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceSecurityGroupsResponse;
import org.cloudfoundry.client.v2.spaces.ListSpaceServiceInstancesRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceServiceInstancesResponse;
import org.cloudfoundry.client.v2.spaces.ListSpaceServicesRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceServicesResponse;
import org.cloudfoundry.client.v2.spaces.ListSpaceUserRolesRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceUserRolesResponse;
import org.cloudfoundry.client.v2.spaces.ListSpacesRequest;
import org.cloudfoundry.client.v2.spaces.ListSpacesResponse;
import org.cloudfoundry.client.v2.spaces.RemoveSpaceAuditorByUsernameRequest;
import org.cloudfoundry.client.v2.spaces.RemoveSpaceAuditorByUsernameResponse;
import org.cloudfoundry.client.v2.spaces.RemoveSpaceAuditorRequest;
import org.cloudfoundry.client.v2.spaces.RemoveSpaceDeveloperByUsernameRequest;
import org.cloudfoundry.client.v2.spaces.RemoveSpaceDeveloperByUsernameResponse;
import org.cloudfoundry.client.v2.spaces.RemoveSpaceDeveloperRequest;
import org.cloudfoundry.client.v2.spaces.RemoveSpaceManagerByUsernameRequest;
import org.cloudfoundry.client.v2.spaces.RemoveSpaceManagerByUsernameResponse;
import org.cloudfoundry.client.v2.spaces.RemoveSpaceManagerRequest;
import org.cloudfoundry.client.v2.spaces.RemoveSpaceSecurityGroupRequest;
import org.cloudfoundry.client.v2.spaces.Spaces;
import org.cloudfoundry.client.v2.spaces.UpdateSpaceRequest;
import org.cloudfoundry.client.v2.spaces.UpdateSpaceResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorSpaces
extends AbstractClientV2Operations
implements Spaces {
    public ReactorSpaces(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<AssociateSpaceAuditorResponse> associateAuditor(AssociateSpaceAuditorRequest request) {
        return this.put(request, AssociateSpaceAuditorResponse.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "auditors", request.getAuditorId()})).checkpoint();
    }

    public Mono<AssociateSpaceAuditorByUsernameResponse> associateAuditorByUsername(AssociateSpaceAuditorByUsernameRequest request) {
        return this.put(request, AssociateSpaceAuditorByUsernameResponse.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "auditors"})).checkpoint();
    }

    public Mono<AssociateSpaceDeveloperResponse> associateDeveloper(AssociateSpaceDeveloperRequest request) {
        return this.put(request, AssociateSpaceDeveloperResponse.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "developers", request.getDeveloperId()})).checkpoint();
    }

    public Mono<AssociateSpaceDeveloperByUsernameResponse> associateDeveloperByUsername(AssociateSpaceDeveloperByUsernameRequest request) {
        return this.put(request, AssociateSpaceDeveloperByUsernameResponse.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "developers"})).checkpoint();
    }

    public Mono<AssociateSpaceManagerResponse> associateManager(AssociateSpaceManagerRequest request) {
        return this.put(request, AssociateSpaceManagerResponse.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "managers", request.getManagerId()})).checkpoint();
    }

    public Mono<AssociateSpaceManagerByUsernameResponse> associateManagerByUsername(AssociateSpaceManagerByUsernameRequest request) {
        return this.put(request, AssociateSpaceManagerByUsernameResponse.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "managers"})).checkpoint();
    }

    public Mono<AssociateSpaceSecurityGroupResponse> associateSecurityGroup(AssociateSpaceSecurityGroupRequest request) {
        return this.put(request, AssociateSpaceSecurityGroupResponse.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "security_groups", request.getSecurityGroupId()})).checkpoint();
    }

    public Mono<CreateSpaceResponse> create(CreateSpaceRequest request) {
        return this.post(request, CreateSpaceResponse.class, builder -> builder.pathSegment(new String[]{"spaces"})).checkpoint();
    }

    public Mono<DeleteSpaceResponse> delete(DeleteSpaceRequest request) {
        return this.delete(request, DeleteSpaceResponse.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId()})).checkpoint();
    }

    public Mono<GetSpaceResponse> get(GetSpaceRequest request) {
        return this.get((Object)request, GetSpaceResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId()})).checkpoint();
    }

    public Mono<GetSpaceSummaryResponse> getSummary(GetSpaceSummaryRequest request) {
        return this.get((Object)request, GetSpaceSummaryResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "summary"})).checkpoint();
    }

    public Mono<ListSpacesResponse> list(ListSpacesRequest request) {
        return this.get((Object)request, ListSpacesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces"})).checkpoint();
    }

    public Mono<ListSpaceApplicationsResponse> listApplications(ListSpaceApplicationsRequest request) {
        return this.get((Object)request, ListSpaceApplicationsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "apps"})).checkpoint();
    }

    public Mono<ListSpaceAuditorsResponse> listAuditors(ListSpaceAuditorsRequest request) {
        return this.get((Object)request, ListSpaceAuditorsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "auditors"})).checkpoint();
    }

    public Mono<ListSpaceDevelopersResponse> listDevelopers(ListSpaceDevelopersRequest request) {
        return this.get((Object)request, ListSpaceDevelopersResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "developers"})).checkpoint();
    }

    public Mono<ListSpaceDomainsResponse> listDomains(ListSpaceDomainsRequest request) {
        return this.get((Object)request, ListSpaceDomainsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "domains"})).checkpoint();
    }

    public Mono<ListSpaceEventsResponse> listEvents(ListSpaceEventsRequest request) {
        return this.get((Object)request, ListSpaceEventsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "events"})).checkpoint();
    }

    public Mono<ListSpaceManagersResponse> listManagers(ListSpaceManagersRequest request) {
        return this.get((Object)request, ListSpaceManagersResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "managers"})).checkpoint();
    }

    public Mono<ListSpaceRoutesResponse> listRoutes(ListSpaceRoutesRequest request) {
        return this.get((Object)request, ListSpaceRoutesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "routes"})).checkpoint();
    }

    public Mono<ListSpaceSecurityGroupsResponse> listSecurityGroups(ListSpaceSecurityGroupsRequest request) {
        return this.get((Object)request, ListSpaceSecurityGroupsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "security_groups"})).checkpoint();
    }

    public Mono<ListSpaceServiceInstancesResponse> listServiceInstances(ListSpaceServiceInstancesRequest request) {
        return this.get((Object)request, ListSpaceServiceInstancesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "service_instances"})).checkpoint();
    }

    public Mono<ListSpaceServicesResponse> listServices(ListSpaceServicesRequest request) {
        return this.get((Object)request, ListSpaceServicesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "services"})).checkpoint();
    }

    public Mono<ListSpaceUserRolesResponse> listUserRoles(ListSpaceUserRolesRequest request) {
        return this.get((Object)request, ListSpaceUserRolesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "user_roles"})).checkpoint();
    }

    public Mono<Void> removeAuditor(RemoveSpaceAuditorRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "auditors", request.getAuditorId()})).checkpoint();
    }

    public Mono<RemoveSpaceAuditorByUsernameResponse> removeAuditorByUsername(RemoveSpaceAuditorByUsernameRequest request) {
        return this.delete(request, RemoveSpaceAuditorByUsernameResponse.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "auditors"})).checkpoint();
    }

    public Mono<Void> removeDeveloper(RemoveSpaceDeveloperRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "developers", request.getDeveloperId()})).checkpoint();
    }

    public Mono<RemoveSpaceDeveloperByUsernameResponse> removeDeveloperByUsername(RemoveSpaceDeveloperByUsernameRequest request) {
        return this.delete(request, RemoveSpaceDeveloperByUsernameResponse.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "developers"})).checkpoint();
    }

    public Mono<Void> removeManager(RemoveSpaceManagerRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "managers", request.getManagerId()})).checkpoint();
    }

    public Mono<RemoveSpaceManagerByUsernameResponse> removeManagerByUsername(RemoveSpaceManagerByUsernameRequest request) {
        return this.delete(request, RemoveSpaceManagerByUsernameResponse.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "managers"})).checkpoint();
    }

    public Mono<Void> removeSecurityGroup(RemoveSpaceSecurityGroupRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "security_groups", request.getSecurityGroupId()})).checkpoint();
    }

    public Mono<UpdateSpaceResponse> update(UpdateSpaceRequest request) {
        return this.put(request, UpdateSpaceResponse.class, builder -> builder.pathSegment(new String[]{"spaces", request.getSpaceId()})).checkpoint();
    }
}

