package org.cloudfoundry.reactor.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _UriVariable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UriVariable.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code UriVariable.of()}.
 */
@Generated(from = "_UriVariable", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UriVariable implements org.cloudfoundry.reactor.util._UriVariable {
  private final String key;
  private transient final String placeholder;
  private final Object value;

  private UriVariable(String key, Object value) {
    this.key = Objects.requireNonNull(key, "key");
    this.value = Objects.requireNonNull(value, "value");
    this.placeholder = Objects.requireNonNull(_UriVariable.super.getPlaceholder(), "placeholder");
  }

  private UriVariable(UriVariable.Builder builder) {
    this.key = builder.key;
    this.value = builder.value;
    this.placeholder = Objects.requireNonNull(_UriVariable.super.getPlaceholder(), "placeholder");
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @Override
  public String getKey() {
    return key;
  }

  /**
   * @return The computed-at-construction value of the {@code placeholder} attribute
   */
  @Override
  public String getPlaceholder() {
    return placeholder;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public Object getValue() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code UriVariable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UriVariable
        && equalTo(0, (UriVariable) another);
  }

  private boolean equalTo(int synthetic, UriVariable another) {
    return key.equals(another.key)
        && placeholder.equals(another.placeholder)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code key}, {@code placeholder}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + key.hashCode();
    h += (h << 5) + placeholder.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UriVariable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UriVariable{"
        + "key=" + key
        + ", placeholder=" + placeholder
        + ", value=" + value
        + "}";
  }

  /**
   * Construct a new immutable {@code UriVariable} instance.
   * @param key The value for the {@code key} attribute
   * @param value The value for the {@code value} attribute
   * @return An immutable UriVariable instance
   */
  public static UriVariable of(String key, Object value) {
    return new UriVariable(key, value);
  }

  /**
   * Creates a builder for {@link UriVariable UriVariable}.
   * <pre>
   * UriVariable.builder()
   *    .key(String) // required {@link _UriVariable#getKey() key}
   *    .value(Object) // required {@link _UriVariable#getValue() value}
   *    .build();
   * </pre>
   * @return A new UriVariable builder
   */
  public static UriVariable.Builder builder() {
    return new UriVariable.Builder();
  }

  /**
   * Builds instances of type {@link UriVariable UriVariable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UriVariable", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_KEY = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private String key;
    private Object value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code _UriVariable} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UriVariable instance) {
      Objects.requireNonNull(instance, "instance");
      this.key(instance.getKey());
      this.value(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link _UriVariable#getKey() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(String key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link _UriVariable#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder value(Object value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link UriVariable UriVariable}.
     * @return An immutable instance of UriVariable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UriVariable build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UriVariable(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build UriVariable, some of required attributes are not set " + attributes;
    }
  }
}
