package org.cloudfoundry.reactor.tokenprovider;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The Client Credentials Grant implementation of {@link TokenProvider}
 */
@Generated(from = "_ClientCredentialsGrantTokenProvider", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ClientCredentialsGrantTokenProvider
    extends org.cloudfoundry.reactor.tokenprovider._ClientCredentialsGrantTokenProvider {
  private final String clientId;
  private final String clientSecret;
  private final @Nullable String identityZoneSubdomain;

  private ClientCredentialsGrantTokenProvider(ClientCredentialsGrantTokenProvider.Builder builder) {
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    if (builder.clientId != null) {
      initShim.clientId(builder.clientId);
    }
    if (builder.clientSecret != null) {
      initShim.clientSecret(builder.clientSecret);
    }
    this.clientId = initShim.getClientId();
    this.clientSecret = initShim.getClientSecret();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "_ClientCredentialsGrantTokenProvider", generator = "Immutables")
  private final class InitShim {
    private byte clientIdBuildStage = STAGE_UNINITIALIZED;
    private String clientId;

    String getClientId() {
      if (clientIdBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (clientIdBuildStage == STAGE_UNINITIALIZED) {
        clientIdBuildStage = STAGE_INITIALIZING;
        this.clientId = Objects.requireNonNull(ClientCredentialsGrantTokenProvider.super.getClientId(), "clientId");
        clientIdBuildStage = STAGE_INITIALIZED;
      }
      return this.clientId;
    }

    void clientId(String clientId) {
      this.clientId = clientId;
      clientIdBuildStage = STAGE_INITIALIZED;
    }

    private byte clientSecretBuildStage = STAGE_UNINITIALIZED;
    private String clientSecret;

    String getClientSecret() {
      if (clientSecretBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (clientSecretBuildStage == STAGE_UNINITIALIZED) {
        clientSecretBuildStage = STAGE_INITIALIZING;
        this.clientSecret = Objects.requireNonNull(ClientCredentialsGrantTokenProvider.super.getClientSecret(), "clientSecret");
        clientSecretBuildStage = STAGE_INITIALIZED;
      }
      return this.clientSecret;
    }

    void clientSecret(String clientSecret) {
      this.clientSecret = clientSecret;
      clientSecretBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (clientIdBuildStage == STAGE_INITIALIZING) attributes.add("clientId");
      if (clientSecretBuildStage == STAGE_INITIALIZING) attributes.add("clientSecret");
      return "Cannot build ClientCredentialsGrantTokenProvider, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * The client id. Defaults to {@code cf}.
   */
  @Override
  public String getClientId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getClientId()
        : this.clientId;
  }

  /**
   * The client secret. Defaults to {@code ""}.
   */
  @Override
  public String getClientSecret() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getClientSecret()
        : this.clientSecret;
  }

  /**
   * The identity zone subdomain
   */
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * This instance is equal to all instances of {@code ClientCredentialsGrantTokenProvider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ClientCredentialsGrantTokenProvider
        && equalTo(0, (ClientCredentialsGrantTokenProvider) another);
  }

  private boolean equalTo(int synthetic, ClientCredentialsGrantTokenProvider another) {
    return clientId.equals(another.clientId)
        && clientSecret.equals(another.clientSecret)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain);
  }

  /**
   * Computes a hash code from attributes: {@code clientId}, {@code clientSecret}, {@code identityZoneSubdomain}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + clientSecret.hashCode();
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    return h;
  }

  /**
   * Prints the immutable value {@code ClientCredentialsGrantTokenProvider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ClientCredentialsGrantTokenProvider{"
        + "clientId=" + clientId
        + ", clientSecret=" + clientSecret
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + "}";
  }

  /**
   * Creates a builder for {@link ClientCredentialsGrantTokenProvider ClientCredentialsGrantTokenProvider}.
   * <pre>
   * ClientCredentialsGrantTokenProvider.builder()
   *    .clientId(String) // optional {@link ClientCredentialsGrantTokenProvider#getClientId() clientId}
   *    .clientSecret(String) // optional {@link ClientCredentialsGrantTokenProvider#getClientSecret() clientSecret}
   *    .identityZoneSubdomain(String | null) // nullable {@link ClientCredentialsGrantTokenProvider#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .build();
   * </pre>
   * @return A new ClientCredentialsGrantTokenProvider builder
   */
  public static ClientCredentialsGrantTokenProvider.Builder builder() {
    return new ClientCredentialsGrantTokenProvider.Builder();
  }

  /**
   * Builds instances of type {@link ClientCredentialsGrantTokenProvider ClientCredentialsGrantTokenProvider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ClientCredentialsGrantTokenProvider", generator = "Immutables")
  public static final class Builder {
    private String clientId;
    private String clientSecret;
    private String identityZoneSubdomain;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ClientCredentialsGrantTokenProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ClientCredentialsGrantTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ClientCredentialsGrantTokenProvider} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ClientCredentialsGrantTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.reactor.tokenprovider.AbstractUaaTokenProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUaaTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof org.cloudfoundry.reactor.tokenprovider._ClientCredentialsGrantTokenProvider) {
        org.cloudfoundry.reactor.tokenprovider._ClientCredentialsGrantTokenProvider instance = (org.cloudfoundry.reactor.tokenprovider._ClientCredentialsGrantTokenProvider) object;
        if ((bits & 0x2L) == 0) {
          String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
          if (identityZoneSubdomainValue != null) {
            identityZoneSubdomain(identityZoneSubdomainValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          this.clientSecret(instance.getClientSecret());
          bits |= 0x4L;
        }
        if ((bits & 0x1L) == 0) {
          this.clientId(instance.getClientId());
          bits |= 0x1L;
        }
      }
      if (object instanceof AbstractUaaTokenProvider) {
        AbstractUaaTokenProvider instance = (AbstractUaaTokenProvider) object;
        if ((bits & 0x2L) == 0) {
          String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
          if (identityZoneSubdomainValue != null) {
            identityZoneSubdomain(identityZoneSubdomainValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          this.clientSecret(instance.getClientSecret());
          bits |= 0x4L;
        }
        if ((bits & 0x1L) == 0) {
          this.clientId(instance.getClientId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ClientCredentialsGrantTokenProvider#getClientId() clientId} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ClientCredentialsGrantTokenProvider#getClientId() clientId}.</em>
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      return this;
    }

    /**
     * Initializes the value for the {@link ClientCredentialsGrantTokenProvider#getClientSecret() clientSecret} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ClientCredentialsGrantTokenProvider#getClientSecret() clientSecret}.</em>
     * @param clientSecret The value for clientSecret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientSecret(String clientSecret) {
      this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
      return this;
    }

    /**
     * Initializes the value for the {@link ClientCredentialsGrantTokenProvider#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Builds a new {@link ClientCredentialsGrantTokenProvider ClientCredentialsGrantTokenProvider}.
     * @return An immutable instance of ClientCredentialsGrantTokenProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ClientCredentialsGrantTokenProvider build() {
      return new ClientCredentialsGrantTokenProvider(this);
    }
  }
}
