/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.doppler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.doppler.ReactorDopplerEndpoints;
import org.cloudfoundry.reactor.doppler._ReactorDopplerClient;
import org.immutables.value.Generated;
import reactor.core.publisher.Mono;

@Generated(from="_ReactorDopplerClient", generator="Immutables")
public final class ReactorDopplerClient
extends _ReactorDopplerClient {
    private final ConnectionContext connectionContext;
    private final transient ReactorDopplerEndpoints dopplerEndpoints;
    private final Map<String, String> requestTags;
    private final Mono<String> root;
    private final TokenProvider tokenProvider;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ReactorDopplerClient(Builder builder) {
        this.connectionContext = builder.connectionContext;
        this.tokenProvider = builder.tokenProvider;
        if (builder.requestTagsIsSet()) {
            this.initShim.requestTags(ReactorDopplerClient.createUnmodifiableMap(false, false, builder.requestTags));
        }
        if (builder.root != null) {
            this.initShim.root((Mono<String>)builder.root);
        }
        this.dopplerEndpoints = this.initShim.getDopplerEndpoints();
        this.requestTags = this.initShim.getRequestTags();
        this.root = this.initShim.getRoot();
        this.initShim = null;
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public ReactorDopplerEndpoints getDopplerEndpoints() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDopplerEndpoints() : this.dopplerEndpoints;
    }

    @Override
    public Map<String, String> getRequestTags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRequestTags() : this.requestTags;
    }

    @Override
    public Mono<String> getRoot() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRoot() : this.root;
    }

    @Override
    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ReactorDopplerClient && this.equalTo(0, (ReactorDopplerClient)another);
    }

    private boolean equalTo(int synthetic, ReactorDopplerClient another) {
        return this.connectionContext.equals(another.connectionContext) && this.dopplerEndpoints.equals(another.dopplerEndpoints) && this.requestTags.equals(another.requestTags) && this.root.equals(another.root) && this.tokenProvider.equals(another.tokenProvider);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.connectionContext.hashCode();
        h += (h << 5) + this.dopplerEndpoints.hashCode();
        h += (h << 5) + this.requestTags.hashCode();
        h += (h << 5) + this.root.hashCode();
        h += (h << 5) + this.tokenProvider.hashCode();
        return h;
    }

    public String toString() {
        return "ReactorDopplerClient{connectionContext=" + this.connectionContext + ", dopplerEndpoints=" + this.dopplerEndpoints + ", requestTags=" + this.requestTags + ", root=" + this.root + ", tokenProvider=" + this.tokenProvider + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_ReactorDopplerClient", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CONNECTION_CONTEXT = 1L;
        private static final long INIT_BIT_TOKEN_PROVIDER = 2L;
        private static final long OPT_BIT_REQUEST_TAGS = 1L;
        private long initBits = 3L;
        private long optBits;
        private ConnectionContext connectionContext;
        private Map<String, String> requestTags = new LinkedHashMap<String, String>();
        private Mono<String> root;
        private TokenProvider tokenProvider;

        private Builder() {
        }

        public final Builder from(ReactorDopplerClient instance) {
            return this.from((_ReactorDopplerClient)instance);
        }

        final Builder from(_ReactorDopplerClient instance) {
            Objects.requireNonNull(instance, "instance");
            this.connectionContext(instance.getConnectionContext());
            this.putAllRequestTags(instance.getRequestTags());
            this.root(instance.getRoot());
            this.tokenProvider(instance.getTokenProvider());
            return this;
        }

        public final Builder connectionContext(ConnectionContext connectionContext) {
            this.connectionContext = Objects.requireNonNull(connectionContext, "connectionContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder requestTag(String key, String value) {
            this.requestTags.put(Objects.requireNonNull(key, "requestTags key"), Objects.requireNonNull(value, value == null ? "requestTags value for key: " + key : null));
            this.optBits |= 1L;
            return this;
        }

        public final Builder requestTag(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.requestTags.put(Objects.requireNonNull(k, "requestTags key"), Objects.requireNonNull(v, v == null ? "requestTags value for key: " + k : null));
            this.optBits |= 1L;
            return this;
        }

        public final Builder requestTags(Map<String, ? extends String> entries) {
            this.requestTags.clear();
            this.optBits |= 1L;
            return this.putAllRequestTags(entries);
        }

        public final Builder putAllRequestTags(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.requestTags.put(Objects.requireNonNull(k, "requestTags key"), Objects.requireNonNull(v, v == null ? "requestTags value for key: " + k : null));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder root(Mono<String> root) {
            this.root = Objects.requireNonNull(root, "root");
            return this;
        }

        public final Builder tokenProvider(TokenProvider tokenProvider) {
            this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ReactorDopplerClient build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ReactorDopplerClient(this);
        }

        private boolean requestTagsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("connectionContext");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tokenProvider");
            }
            return "Cannot build ReactorDopplerClient, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="_ReactorDopplerClient", generator="Immutables")
    private final class InitShim {
        private byte dopplerEndpointsBuildStage = 0;
        private ReactorDopplerEndpoints dopplerEndpoints;
        private byte requestTagsBuildStage = 0;
        private Map<String, String> requestTags;
        private byte rootBuildStage = 0;
        private Mono<String> root;

        private InitShim() {
        }

        ReactorDopplerEndpoints getDopplerEndpoints() {
            if (this.dopplerEndpointsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dopplerEndpointsBuildStage == 0) {
                this.dopplerEndpointsBuildStage = (byte)-1;
                this.dopplerEndpoints = Objects.requireNonNull(ReactorDopplerClient.super.getDopplerEndpoints(), "dopplerEndpoints");
                this.dopplerEndpointsBuildStage = 1;
            }
            return this.dopplerEndpoints;
        }

        Map<String, String> getRequestTags() {
            if (this.requestTagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requestTagsBuildStage == 0) {
                this.requestTagsBuildStage = (byte)-1;
                this.requestTags = ReactorDopplerClient.createUnmodifiableMap(true, false, ReactorDopplerClient.super.getRequestTags());
                this.requestTagsBuildStage = 1;
            }
            return this.requestTags;
        }

        void requestTags(Map<String, String> requestTags) {
            this.requestTags = requestTags;
            this.requestTagsBuildStage = 1;
        }

        Mono<String> getRoot() {
            if (this.rootBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rootBuildStage == 0) {
                this.rootBuildStage = (byte)-1;
                this.root = Objects.requireNonNull(ReactorDopplerClient.super.getRoot(), "root");
                this.rootBuildStage = 1;
            }
            return this.root;
        }

        void root(Mono<String> root) {
            this.root = root;
            this.rootBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.dopplerEndpointsBuildStage == -1) {
                attributes.add("dopplerEndpoints");
            }
            if (this.requestTagsBuildStage == -1) {
                attributes.add("requestTags");
            }
            if (this.rootBuildStage == -1) {
                attributes.add("root");
            }
            return "Cannot build ReactorDopplerClient, attribute initializers form cycle " + attributes;
        }
    }
}

