package org.cloudfoundry.reactor.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.client.v2.applications.ApplicationsV2;
import org.cloudfoundry.client.v2.applicationusageevents.ApplicationUsageEvents;
import org.cloudfoundry.client.v2.blobstores.Blobstores;
import org.cloudfoundry.client.v2.buildpacks.Buildpacks;
import org.cloudfoundry.client.v2.domains.Domains;
import org.cloudfoundry.client.v2.environmentvariablegroups.EnvironmentVariableGroups;
import org.cloudfoundry.client.v2.events.Events;
import org.cloudfoundry.client.v2.featureflags.FeatureFlags;
import org.cloudfoundry.client.v2.info.Info;
import org.cloudfoundry.client.v2.jobs.Jobs;
import org.cloudfoundry.client.v2.organizationquotadefinitions.OrganizationQuotaDefinitions;
import org.cloudfoundry.client.v2.organizations.Organizations;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomains;
import org.cloudfoundry.client.v2.resourcematch.ResourceMatch;
import org.cloudfoundry.client.v2.routemappings.RouteMappings;
import org.cloudfoundry.client.v2.routes.Routes;
import org.cloudfoundry.client.v2.securitygroups.SecurityGroups;
import org.cloudfoundry.client.v2.servicebindings.ServiceBindingsV2;
import org.cloudfoundry.client.v2.servicebrokers.ServiceBrokers;
import org.cloudfoundry.client.v2.serviceinstances.ServiceInstances;
import org.cloudfoundry.client.v2.servicekeys.ServiceKeys;
import org.cloudfoundry.client.v2.serviceplans.ServicePlans;
import org.cloudfoundry.client.v2.serviceplanvisibilities.ServicePlanVisibilities;
import org.cloudfoundry.client.v2.services.Services;
import org.cloudfoundry.client.v2.serviceusageevents.ServiceUsageEvents;
import org.cloudfoundry.client.v2.shareddomains.SharedDomains;
import org.cloudfoundry.client.v2.spacequotadefinitions.SpaceQuotaDefinitions;
import org.cloudfoundry.client.v2.spaces.Spaces;
import org.cloudfoundry.client.v2.stacks.Stacks;
import org.cloudfoundry.client.v2.userprovidedserviceinstances.UserProvidedServiceInstances;
import org.cloudfoundry.client.v2.users.Users;
import org.cloudfoundry.client.v3.admin.AdminV3;
import org.cloudfoundry.client.v3.applications.ApplicationsV3;
import org.cloudfoundry.client.v3.auditevents.AuditEventsV3;
import org.cloudfoundry.client.v3.buildpacks.BuildpacksV3;
import org.cloudfoundry.client.v3.builds.Builds;
import org.cloudfoundry.client.v3.deployments.DeploymentsV3;
import org.cloudfoundry.client.v3.domains.DomainsV3;
import org.cloudfoundry.client.v3.droplets.Droplets;
import org.cloudfoundry.client.v3.isolationsegments.IsolationSegments;
import org.cloudfoundry.client.v3.jobs.JobsV3;
import org.cloudfoundry.client.v3.organizations.OrganizationsV3;
import org.cloudfoundry.client.v3.packages.Packages;
import org.cloudfoundry.client.v3.processes.Processes;
import org.cloudfoundry.client.v3.resourcematch.ResourceMatchV3;
import org.cloudfoundry.client.v3.roles.RolesV3;
import org.cloudfoundry.client.v3.routes.RoutesV3;
import org.cloudfoundry.client.v3.securitygroups.SecurityGroupsV3;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingsV3;
import org.cloudfoundry.client.v3.servicebrokers.ServiceBrokersV3;
import org.cloudfoundry.client.v3.serviceinstances.ServiceInstancesV3;
import org.cloudfoundry.client.v3.serviceofferings.ServiceOfferingsV3;
import org.cloudfoundry.client.v3.serviceplans.ServicePlansV3;
import org.cloudfoundry.client.v3.spaces.SpacesV3;
import org.cloudfoundry.client.v3.stacks.StacksV3;
import org.cloudfoundry.client.v3.tasks.Tasks;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.immutables.value.Generated;
import reactor.core.publisher.Mono;

/**
 * The Reactor-based implementation of {@link CloudFoundryClient}
 */
@Generated(from = "_ReactorCloudFoundryClient", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ReactorCloudFoundryClient
    extends org.cloudfoundry.reactor.client._ReactorCloudFoundryClient {
  private transient final AdminV3 adminV3;
  private transient final ApplicationUsageEvents applicationUsageEvents;
  private transient final ApplicationsV2 applicationsV2;
  private transient final ApplicationsV3 applicationsV3;
  private transient final AuditEventsV3 auditEventsV3;
  private transient final Blobstores blobstores;
  private transient final Buildpacks buildpacks;
  private transient final BuildpacksV3 buildpacksV3;
  private transient final Builds builds;
  private transient final DeploymentsV3 deploymentsV3;
  private transient final Domains domains;
  private transient final DomainsV3 domainsV3;
  private transient final Droplets droplets;
  private transient final EnvironmentVariableGroups environmentVariableGroups;
  private transient final Events events;
  private transient final FeatureFlags featureFlags;
  private transient final Info info;
  private transient final IsolationSegments isolationSegments;
  private transient final Jobs jobs;
  private transient final JobsV3 jobsV3;
  private transient final OrganizationQuotaDefinitions organizationQuotaDefinitions;
  private transient final Organizations organizations;
  private transient final OrganizationsV3 organizationsV3;
  private transient final Packages packages;
  private transient final PrivateDomains privateDomains;
  private transient final Processes processes;
  private transient final ResourceMatch resourceMatch;
  private transient final ResourceMatchV3 resourceMatchV3;
  private transient final RolesV3 rolesV3;
  private transient final RouteMappings routeMappings;
  private transient final Routes routes;
  private transient final RoutesV3 routesV3;
  private transient final SecurityGroups securityGroups;
  private transient final SecurityGroupsV3 securityGroupsV3;
  private transient final ServiceBindingsV2 serviceBindingsV2;
  private transient final ServiceBindingsV3 serviceBindingsV3;
  private transient final ServiceBrokers serviceBrokers;
  private transient final ServiceBrokersV3 serviceBrokersV3;
  private transient final ServiceInstances serviceInstances;
  private transient final ServiceInstancesV3 serviceInstancesV3;
  private transient final ServiceKeys serviceKeys;
  private transient final ServiceOfferingsV3 serviceOfferingsV3;
  private transient final ServicePlanVisibilities servicePlanVisibilities;
  private transient final ServicePlans servicePlans;
  private transient final ServicePlansV3 servicePlansV3;
  private transient final ServiceUsageEvents serviceUsageEvents;
  private transient final Services services;
  private transient final SharedDomains sharedDomains;
  private transient final SpaceQuotaDefinitions spaceQuotaDefinitions;
  private transient final Spaces spaces;
  private transient final SpacesV3 spacesV3;
  private transient final Stacks stacks;
  private transient final StacksV3 stacksV3;
  private transient final Tasks tasks;
  private transient final UserProvidedServiceInstances userProvidedServiceInstances;
  private transient final Users users;
  private final ConnectionContext connectionContext;
  private final Map<String, String> requestTags;
  private final Mono<String> rootV2;
  private final Mono<String> rootV3;
  private final TokenProvider tokenProvider;

  private ReactorCloudFoundryClient(ReactorCloudFoundryClient.Builder builder) {
    this.connectionContext = builder.connectionContext;
    this.tokenProvider = builder.tokenProvider;
    if (builder.requestTagsIsSet()) {
      initShim.requestTags(createUnmodifiableMap(false, false, builder.requestTags));
    }
    if (builder.rootV2 != null) {
      initShim.rootV2(builder.rootV2);
    }
    if (builder.rootV3 != null) {
      initShim.rootV3(builder.rootV3);
    }
    this.adminV3 = initShim.adminV3();
    this.applicationUsageEvents = initShim.applicationUsageEvents();
    this.applicationsV2 = initShim.applicationsV2();
    this.applicationsV3 = initShim.applicationsV3();
    this.auditEventsV3 = initShim.auditEventsV3();
    this.blobstores = initShim.blobstores();
    this.buildpacks = initShim.buildpacks();
    this.buildpacksV3 = initShim.buildpacksV3();
    this.builds = initShim.builds();
    this.deploymentsV3 = initShim.deploymentsV3();
    this.domains = initShim.domains();
    this.domainsV3 = initShim.domainsV3();
    this.droplets = initShim.droplets();
    this.environmentVariableGroups = initShim.environmentVariableGroups();
    this.events = initShim.events();
    this.featureFlags = initShim.featureFlags();
    this.info = initShim.info();
    this.isolationSegments = initShim.isolationSegments();
    this.jobs = initShim.jobs();
    this.jobsV3 = initShim.jobsV3();
    this.organizationQuotaDefinitions = initShim.organizationQuotaDefinitions();
    this.organizations = initShim.organizations();
    this.organizationsV3 = initShim.organizationsV3();
    this.packages = initShim.packages();
    this.privateDomains = initShim.privateDomains();
    this.processes = initShim.processes();
    this.resourceMatch = initShim.resourceMatch();
    this.resourceMatchV3 = initShim.resourceMatchV3();
    this.rolesV3 = initShim.rolesV3();
    this.routeMappings = initShim.routeMappings();
    this.routes = initShim.routes();
    this.routesV3 = initShim.routesV3();
    this.securityGroups = initShim.securityGroups();
    this.securityGroupsV3 = initShim.securityGroupsV3();
    this.serviceBindingsV2 = initShim.serviceBindingsV2();
    this.serviceBindingsV3 = initShim.serviceBindingsV3();
    this.serviceBrokers = initShim.serviceBrokers();
    this.serviceBrokersV3 = initShim.serviceBrokersV3();
    this.serviceInstances = initShim.serviceInstances();
    this.serviceInstancesV3 = initShim.serviceInstancesV3();
    this.serviceKeys = initShim.serviceKeys();
    this.serviceOfferingsV3 = initShim.serviceOfferingsV3();
    this.servicePlanVisibilities = initShim.servicePlanVisibilities();
    this.servicePlans = initShim.servicePlans();
    this.servicePlansV3 = initShim.servicePlansV3();
    this.serviceUsageEvents = initShim.serviceUsageEvents();
    this.services = initShim.services();
    this.sharedDomains = initShim.sharedDomains();
    this.spaceQuotaDefinitions = initShim.spaceQuotaDefinitions();
    this.spaces = initShim.spaces();
    this.spacesV3 = initShim.spacesV3();
    this.stacks = initShim.stacks();
    this.stacksV3 = initShim.stacksV3();
    this.tasks = initShim.tasks();
    this.userProvidedServiceInstances = initShim.userProvidedServiceInstances();
    this.users = initShim.users();
    this.requestTags = initShim.getRequestTags();
    this.rootV2 = initShim.getRootV2();
    this.rootV3 = initShim.getRootV3();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "_ReactorCloudFoundryClient", generator = "Immutables")
  private final class InitShim {
    private byte adminV3BuildStage = STAGE_UNINITIALIZED;
    private AdminV3 adminV3;

    AdminV3 adminV3() {
      if (adminV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (adminV3BuildStage == STAGE_UNINITIALIZED) {
        adminV3BuildStage = STAGE_INITIALIZING;
        this.adminV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.adminV3(), "adminV3");
        adminV3BuildStage = STAGE_INITIALIZED;
      }
      return this.adminV3;
    }

    private byte applicationUsageEventsBuildStage = STAGE_UNINITIALIZED;
    private ApplicationUsageEvents applicationUsageEvents;

    ApplicationUsageEvents applicationUsageEvents() {
      if (applicationUsageEventsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (applicationUsageEventsBuildStage == STAGE_UNINITIALIZED) {
        applicationUsageEventsBuildStage = STAGE_INITIALIZING;
        this.applicationUsageEvents = Objects.requireNonNull(ReactorCloudFoundryClient.super.applicationUsageEvents(), "applicationUsageEvents");
        applicationUsageEventsBuildStage = STAGE_INITIALIZED;
      }
      return this.applicationUsageEvents;
    }

    private byte applicationsV2BuildStage = STAGE_UNINITIALIZED;
    private ApplicationsV2 applicationsV2;

    ApplicationsV2 applicationsV2() {
      if (applicationsV2BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (applicationsV2BuildStage == STAGE_UNINITIALIZED) {
        applicationsV2BuildStage = STAGE_INITIALIZING;
        this.applicationsV2 = Objects.requireNonNull(ReactorCloudFoundryClient.super.applicationsV2(), "applicationsV2");
        applicationsV2BuildStage = STAGE_INITIALIZED;
      }
      return this.applicationsV2;
    }

    private byte applicationsV3BuildStage = STAGE_UNINITIALIZED;
    private ApplicationsV3 applicationsV3;

    ApplicationsV3 applicationsV3() {
      if (applicationsV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (applicationsV3BuildStage == STAGE_UNINITIALIZED) {
        applicationsV3BuildStage = STAGE_INITIALIZING;
        this.applicationsV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.applicationsV3(), "applicationsV3");
        applicationsV3BuildStage = STAGE_INITIALIZED;
      }
      return this.applicationsV3;
    }

    private byte auditEventsV3BuildStage = STAGE_UNINITIALIZED;
    private AuditEventsV3 auditEventsV3;

    AuditEventsV3 auditEventsV3() {
      if (auditEventsV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (auditEventsV3BuildStage == STAGE_UNINITIALIZED) {
        auditEventsV3BuildStage = STAGE_INITIALIZING;
        this.auditEventsV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.auditEventsV3(), "auditEventsV3");
        auditEventsV3BuildStage = STAGE_INITIALIZED;
      }
      return this.auditEventsV3;
    }

    private byte blobstoresBuildStage = STAGE_UNINITIALIZED;
    private Blobstores blobstores;

    Blobstores blobstores() {
      if (blobstoresBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (blobstoresBuildStage == STAGE_UNINITIALIZED) {
        blobstoresBuildStage = STAGE_INITIALIZING;
        this.blobstores = Objects.requireNonNull(ReactorCloudFoundryClient.super.blobstores(), "blobstores");
        blobstoresBuildStage = STAGE_INITIALIZED;
      }
      return this.blobstores;
    }

    private byte buildpacksBuildStage = STAGE_UNINITIALIZED;
    private Buildpacks buildpacks;

    Buildpacks buildpacks() {
      if (buildpacksBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (buildpacksBuildStage == STAGE_UNINITIALIZED) {
        buildpacksBuildStage = STAGE_INITIALIZING;
        this.buildpacks = Objects.requireNonNull(ReactorCloudFoundryClient.super.buildpacks(), "buildpacks");
        buildpacksBuildStage = STAGE_INITIALIZED;
      }
      return this.buildpacks;
    }

    private byte buildpacksV3BuildStage = STAGE_UNINITIALIZED;
    private BuildpacksV3 buildpacksV3;

    BuildpacksV3 buildpacksV3() {
      if (buildpacksV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (buildpacksV3BuildStage == STAGE_UNINITIALIZED) {
        buildpacksV3BuildStage = STAGE_INITIALIZING;
        this.buildpacksV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.buildpacksV3(), "buildpacksV3");
        buildpacksV3BuildStage = STAGE_INITIALIZED;
      }
      return this.buildpacksV3;
    }

    private byte buildsBuildStage = STAGE_UNINITIALIZED;
    private Builds builds;

    Builds builds() {
      if (buildsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (buildsBuildStage == STAGE_UNINITIALIZED) {
        buildsBuildStage = STAGE_INITIALIZING;
        this.builds = Objects.requireNonNull(ReactorCloudFoundryClient.super.builds(), "builds");
        buildsBuildStage = STAGE_INITIALIZED;
      }
      return this.builds;
    }

    private byte deploymentsV3BuildStage = STAGE_UNINITIALIZED;
    private DeploymentsV3 deploymentsV3;

    DeploymentsV3 deploymentsV3() {
      if (deploymentsV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (deploymentsV3BuildStage == STAGE_UNINITIALIZED) {
        deploymentsV3BuildStage = STAGE_INITIALIZING;
        this.deploymentsV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.deploymentsV3(), "deploymentsV3");
        deploymentsV3BuildStage = STAGE_INITIALIZED;
      }
      return this.deploymentsV3;
    }

    private byte domainsBuildStage = STAGE_UNINITIALIZED;
    private Domains domains;

    Domains domains() {
      if (domainsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (domainsBuildStage == STAGE_UNINITIALIZED) {
        domainsBuildStage = STAGE_INITIALIZING;
        this.domains = Objects.requireNonNull(ReactorCloudFoundryClient.super.domains(), "domains");
        domainsBuildStage = STAGE_INITIALIZED;
      }
      return this.domains;
    }

    private byte domainsV3BuildStage = STAGE_UNINITIALIZED;
    private DomainsV3 domainsV3;

    DomainsV3 domainsV3() {
      if (domainsV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (domainsV3BuildStage == STAGE_UNINITIALIZED) {
        domainsV3BuildStage = STAGE_INITIALIZING;
        this.domainsV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.domainsV3(), "domainsV3");
        domainsV3BuildStage = STAGE_INITIALIZED;
      }
      return this.domainsV3;
    }

    private byte dropletsBuildStage = STAGE_UNINITIALIZED;
    private Droplets droplets;

    Droplets droplets() {
      if (dropletsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dropletsBuildStage == STAGE_UNINITIALIZED) {
        dropletsBuildStage = STAGE_INITIALIZING;
        this.droplets = Objects.requireNonNull(ReactorCloudFoundryClient.super.droplets(), "droplets");
        dropletsBuildStage = STAGE_INITIALIZED;
      }
      return this.droplets;
    }

    private byte environmentVariableGroupsBuildStage = STAGE_UNINITIALIZED;
    private EnvironmentVariableGroups environmentVariableGroups;

    EnvironmentVariableGroups environmentVariableGroups() {
      if (environmentVariableGroupsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (environmentVariableGroupsBuildStage == STAGE_UNINITIALIZED) {
        environmentVariableGroupsBuildStage = STAGE_INITIALIZING;
        this.environmentVariableGroups = Objects.requireNonNull(ReactorCloudFoundryClient.super.environmentVariableGroups(), "environmentVariableGroups");
        environmentVariableGroupsBuildStage = STAGE_INITIALIZED;
      }
      return this.environmentVariableGroups;
    }

    private byte eventsBuildStage = STAGE_UNINITIALIZED;
    private Events events;

    Events events() {
      if (eventsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (eventsBuildStage == STAGE_UNINITIALIZED) {
        eventsBuildStage = STAGE_INITIALIZING;
        this.events = Objects.requireNonNull(ReactorCloudFoundryClient.super.events(), "events");
        eventsBuildStage = STAGE_INITIALIZED;
      }
      return this.events;
    }

    private byte featureFlagsBuildStage = STAGE_UNINITIALIZED;
    private FeatureFlags featureFlags;

    FeatureFlags featureFlags() {
      if (featureFlagsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (featureFlagsBuildStage == STAGE_UNINITIALIZED) {
        featureFlagsBuildStage = STAGE_INITIALIZING;
        this.featureFlags = Objects.requireNonNull(ReactorCloudFoundryClient.super.featureFlags(), "featureFlags");
        featureFlagsBuildStage = STAGE_INITIALIZED;
      }
      return this.featureFlags;
    }

    private byte infoBuildStage = STAGE_UNINITIALIZED;
    private Info info;

    Info info() {
      if (infoBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (infoBuildStage == STAGE_UNINITIALIZED) {
        infoBuildStage = STAGE_INITIALIZING;
        this.info = Objects.requireNonNull(ReactorCloudFoundryClient.super.info(), "info");
        infoBuildStage = STAGE_INITIALIZED;
      }
      return this.info;
    }

    private byte isolationSegmentsBuildStage = STAGE_UNINITIALIZED;
    private IsolationSegments isolationSegments;

    IsolationSegments isolationSegments() {
      if (isolationSegmentsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isolationSegmentsBuildStage == STAGE_UNINITIALIZED) {
        isolationSegmentsBuildStage = STAGE_INITIALIZING;
        this.isolationSegments = Objects.requireNonNull(ReactorCloudFoundryClient.super.isolationSegments(), "isolationSegments");
        isolationSegmentsBuildStage = STAGE_INITIALIZED;
      }
      return this.isolationSegments;
    }

    private byte jobsBuildStage = STAGE_UNINITIALIZED;
    private Jobs jobs;

    Jobs jobs() {
      if (jobsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (jobsBuildStage == STAGE_UNINITIALIZED) {
        jobsBuildStage = STAGE_INITIALIZING;
        this.jobs = Objects.requireNonNull(ReactorCloudFoundryClient.super.jobs(), "jobs");
        jobsBuildStage = STAGE_INITIALIZED;
      }
      return this.jobs;
    }

    private byte jobsV3BuildStage = STAGE_UNINITIALIZED;
    private JobsV3 jobsV3;

    JobsV3 jobsV3() {
      if (jobsV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (jobsV3BuildStage == STAGE_UNINITIALIZED) {
        jobsV3BuildStage = STAGE_INITIALIZING;
        this.jobsV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.jobsV3(), "jobsV3");
        jobsV3BuildStage = STAGE_INITIALIZED;
      }
      return this.jobsV3;
    }

    private byte organizationQuotaDefinitionsBuildStage = STAGE_UNINITIALIZED;
    private OrganizationQuotaDefinitions organizationQuotaDefinitions;

    OrganizationQuotaDefinitions organizationQuotaDefinitions() {
      if (organizationQuotaDefinitionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (organizationQuotaDefinitionsBuildStage == STAGE_UNINITIALIZED) {
        organizationQuotaDefinitionsBuildStage = STAGE_INITIALIZING;
        this.organizationQuotaDefinitions = Objects.requireNonNull(ReactorCloudFoundryClient.super.organizationQuotaDefinitions(), "organizationQuotaDefinitions");
        organizationQuotaDefinitionsBuildStage = STAGE_INITIALIZED;
      }
      return this.organizationQuotaDefinitions;
    }

    private byte organizationsBuildStage = STAGE_UNINITIALIZED;
    private Organizations organizations;

    Organizations organizations() {
      if (organizationsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (organizationsBuildStage == STAGE_UNINITIALIZED) {
        organizationsBuildStage = STAGE_INITIALIZING;
        this.organizations = Objects.requireNonNull(ReactorCloudFoundryClient.super.organizations(), "organizations");
        organizationsBuildStage = STAGE_INITIALIZED;
      }
      return this.organizations;
    }

    private byte organizationsV3BuildStage = STAGE_UNINITIALIZED;
    private OrganizationsV3 organizationsV3;

    OrganizationsV3 organizationsV3() {
      if (organizationsV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (organizationsV3BuildStage == STAGE_UNINITIALIZED) {
        organizationsV3BuildStage = STAGE_INITIALIZING;
        this.organizationsV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.organizationsV3(), "organizationsV3");
        organizationsV3BuildStage = STAGE_INITIALIZED;
      }
      return this.organizationsV3;
    }

    private byte packagesBuildStage = STAGE_UNINITIALIZED;
    private Packages packages;

    Packages packages() {
      if (packagesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (packagesBuildStage == STAGE_UNINITIALIZED) {
        packagesBuildStage = STAGE_INITIALIZING;
        this.packages = Objects.requireNonNull(ReactorCloudFoundryClient.super.packages(), "packages");
        packagesBuildStage = STAGE_INITIALIZED;
      }
      return this.packages;
    }

    private byte privateDomainsBuildStage = STAGE_UNINITIALIZED;
    private PrivateDomains privateDomains;

    PrivateDomains privateDomains() {
      if (privateDomainsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (privateDomainsBuildStage == STAGE_UNINITIALIZED) {
        privateDomainsBuildStage = STAGE_INITIALIZING;
        this.privateDomains = Objects.requireNonNull(ReactorCloudFoundryClient.super.privateDomains(), "privateDomains");
        privateDomainsBuildStage = STAGE_INITIALIZED;
      }
      return this.privateDomains;
    }

    private byte processesBuildStage = STAGE_UNINITIALIZED;
    private Processes processes;

    Processes processes() {
      if (processesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (processesBuildStage == STAGE_UNINITIALIZED) {
        processesBuildStage = STAGE_INITIALIZING;
        this.processes = Objects.requireNonNull(ReactorCloudFoundryClient.super.processes(), "processes");
        processesBuildStage = STAGE_INITIALIZED;
      }
      return this.processes;
    }

    private byte resourceMatchBuildStage = STAGE_UNINITIALIZED;
    private ResourceMatch resourceMatch;

    ResourceMatch resourceMatch() {
      if (resourceMatchBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (resourceMatchBuildStage == STAGE_UNINITIALIZED) {
        resourceMatchBuildStage = STAGE_INITIALIZING;
        this.resourceMatch = Objects.requireNonNull(ReactorCloudFoundryClient.super.resourceMatch(), "resourceMatch");
        resourceMatchBuildStage = STAGE_INITIALIZED;
      }
      return this.resourceMatch;
    }

    private byte resourceMatchV3BuildStage = STAGE_UNINITIALIZED;
    private ResourceMatchV3 resourceMatchV3;

    ResourceMatchV3 resourceMatchV3() {
      if (resourceMatchV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (resourceMatchV3BuildStage == STAGE_UNINITIALIZED) {
        resourceMatchV3BuildStage = STAGE_INITIALIZING;
        this.resourceMatchV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.resourceMatchV3(), "resourceMatchV3");
        resourceMatchV3BuildStage = STAGE_INITIALIZED;
      }
      return this.resourceMatchV3;
    }

    private byte rolesV3BuildStage = STAGE_UNINITIALIZED;
    private RolesV3 rolesV3;

    RolesV3 rolesV3() {
      if (rolesV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rolesV3BuildStage == STAGE_UNINITIALIZED) {
        rolesV3BuildStage = STAGE_INITIALIZING;
        this.rolesV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.rolesV3(), "rolesV3");
        rolesV3BuildStage = STAGE_INITIALIZED;
      }
      return this.rolesV3;
    }

    private byte routeMappingsBuildStage = STAGE_UNINITIALIZED;
    private RouteMappings routeMappings;

    RouteMappings routeMappings() {
      if (routeMappingsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (routeMappingsBuildStage == STAGE_UNINITIALIZED) {
        routeMappingsBuildStage = STAGE_INITIALIZING;
        this.routeMappings = Objects.requireNonNull(ReactorCloudFoundryClient.super.routeMappings(), "routeMappings");
        routeMappingsBuildStage = STAGE_INITIALIZED;
      }
      return this.routeMappings;
    }

    private byte routesBuildStage = STAGE_UNINITIALIZED;
    private Routes routes;

    Routes routes() {
      if (routesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (routesBuildStage == STAGE_UNINITIALIZED) {
        routesBuildStage = STAGE_INITIALIZING;
        this.routes = Objects.requireNonNull(ReactorCloudFoundryClient.super.routes(), "routes");
        routesBuildStage = STAGE_INITIALIZED;
      }
      return this.routes;
    }

    private byte routesV3BuildStage = STAGE_UNINITIALIZED;
    private RoutesV3 routesV3;

    RoutesV3 routesV3() {
      if (routesV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (routesV3BuildStage == STAGE_UNINITIALIZED) {
        routesV3BuildStage = STAGE_INITIALIZING;
        this.routesV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.routesV3(), "routesV3");
        routesV3BuildStage = STAGE_INITIALIZED;
      }
      return this.routesV3;
    }

    private byte securityGroupsBuildStage = STAGE_UNINITIALIZED;
    private SecurityGroups securityGroups;

    SecurityGroups securityGroups() {
      if (securityGroupsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (securityGroupsBuildStage == STAGE_UNINITIALIZED) {
        securityGroupsBuildStage = STAGE_INITIALIZING;
        this.securityGroups = Objects.requireNonNull(ReactorCloudFoundryClient.super.securityGroups(), "securityGroups");
        securityGroupsBuildStage = STAGE_INITIALIZED;
      }
      return this.securityGroups;
    }

    private byte securityGroupsV3BuildStage = STAGE_UNINITIALIZED;
    private SecurityGroupsV3 securityGroupsV3;

    SecurityGroupsV3 securityGroupsV3() {
      if (securityGroupsV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (securityGroupsV3BuildStage == STAGE_UNINITIALIZED) {
        securityGroupsV3BuildStage = STAGE_INITIALIZING;
        this.securityGroupsV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.securityGroupsV3(), "securityGroupsV3");
        securityGroupsV3BuildStage = STAGE_INITIALIZED;
      }
      return this.securityGroupsV3;
    }

    private byte serviceBindingsV2BuildStage = STAGE_UNINITIALIZED;
    private ServiceBindingsV2 serviceBindingsV2;

    ServiceBindingsV2 serviceBindingsV2() {
      if (serviceBindingsV2BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceBindingsV2BuildStage == STAGE_UNINITIALIZED) {
        serviceBindingsV2BuildStage = STAGE_INITIALIZING;
        this.serviceBindingsV2 = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceBindingsV2(), "serviceBindingsV2");
        serviceBindingsV2BuildStage = STAGE_INITIALIZED;
      }
      return this.serviceBindingsV2;
    }

    private byte serviceBindingsV3BuildStage = STAGE_UNINITIALIZED;
    private ServiceBindingsV3 serviceBindingsV3;

    ServiceBindingsV3 serviceBindingsV3() {
      if (serviceBindingsV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceBindingsV3BuildStage == STAGE_UNINITIALIZED) {
        serviceBindingsV3BuildStage = STAGE_INITIALIZING;
        this.serviceBindingsV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceBindingsV3(), "serviceBindingsV3");
        serviceBindingsV3BuildStage = STAGE_INITIALIZED;
      }
      return this.serviceBindingsV3;
    }

    private byte serviceBrokersBuildStage = STAGE_UNINITIALIZED;
    private ServiceBrokers serviceBrokers;

    ServiceBrokers serviceBrokers() {
      if (serviceBrokersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceBrokersBuildStage == STAGE_UNINITIALIZED) {
        serviceBrokersBuildStage = STAGE_INITIALIZING;
        this.serviceBrokers = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceBrokers(), "serviceBrokers");
        serviceBrokersBuildStage = STAGE_INITIALIZED;
      }
      return this.serviceBrokers;
    }

    private byte serviceBrokersV3BuildStage = STAGE_UNINITIALIZED;
    private ServiceBrokersV3 serviceBrokersV3;

    ServiceBrokersV3 serviceBrokersV3() {
      if (serviceBrokersV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceBrokersV3BuildStage == STAGE_UNINITIALIZED) {
        serviceBrokersV3BuildStage = STAGE_INITIALIZING;
        this.serviceBrokersV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceBrokersV3(), "serviceBrokersV3");
        serviceBrokersV3BuildStage = STAGE_INITIALIZED;
      }
      return this.serviceBrokersV3;
    }

    private byte serviceInstancesBuildStage = STAGE_UNINITIALIZED;
    private ServiceInstances serviceInstances;

    ServiceInstances serviceInstances() {
      if (serviceInstancesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceInstancesBuildStage == STAGE_UNINITIALIZED) {
        serviceInstancesBuildStage = STAGE_INITIALIZING;
        this.serviceInstances = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceInstances(), "serviceInstances");
        serviceInstancesBuildStage = STAGE_INITIALIZED;
      }
      return this.serviceInstances;
    }

    private byte serviceInstancesV3BuildStage = STAGE_UNINITIALIZED;
    private ServiceInstancesV3 serviceInstancesV3;

    ServiceInstancesV3 serviceInstancesV3() {
      if (serviceInstancesV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceInstancesV3BuildStage == STAGE_UNINITIALIZED) {
        serviceInstancesV3BuildStage = STAGE_INITIALIZING;
        this.serviceInstancesV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceInstancesV3(), "serviceInstancesV3");
        serviceInstancesV3BuildStage = STAGE_INITIALIZED;
      }
      return this.serviceInstancesV3;
    }

    private byte serviceKeysBuildStage = STAGE_UNINITIALIZED;
    private ServiceKeys serviceKeys;

    ServiceKeys serviceKeys() {
      if (serviceKeysBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceKeysBuildStage == STAGE_UNINITIALIZED) {
        serviceKeysBuildStage = STAGE_INITIALIZING;
        this.serviceKeys = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceKeys(), "serviceKeys");
        serviceKeysBuildStage = STAGE_INITIALIZED;
      }
      return this.serviceKeys;
    }

    private byte serviceOfferingsV3BuildStage = STAGE_UNINITIALIZED;
    private ServiceOfferingsV3 serviceOfferingsV3;

    ServiceOfferingsV3 serviceOfferingsV3() {
      if (serviceOfferingsV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceOfferingsV3BuildStage == STAGE_UNINITIALIZED) {
        serviceOfferingsV3BuildStage = STAGE_INITIALIZING;
        this.serviceOfferingsV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceOfferingsV3(), "serviceOfferingsV3");
        serviceOfferingsV3BuildStage = STAGE_INITIALIZED;
      }
      return this.serviceOfferingsV3;
    }

    private byte servicePlanVisibilitiesBuildStage = STAGE_UNINITIALIZED;
    private ServicePlanVisibilities servicePlanVisibilities;

    ServicePlanVisibilities servicePlanVisibilities() {
      if (servicePlanVisibilitiesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (servicePlanVisibilitiesBuildStage == STAGE_UNINITIALIZED) {
        servicePlanVisibilitiesBuildStage = STAGE_INITIALIZING;
        this.servicePlanVisibilities = Objects.requireNonNull(ReactorCloudFoundryClient.super.servicePlanVisibilities(), "servicePlanVisibilities");
        servicePlanVisibilitiesBuildStage = STAGE_INITIALIZED;
      }
      return this.servicePlanVisibilities;
    }

    private byte servicePlansBuildStage = STAGE_UNINITIALIZED;
    private ServicePlans servicePlans;

    ServicePlans servicePlans() {
      if (servicePlansBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (servicePlansBuildStage == STAGE_UNINITIALIZED) {
        servicePlansBuildStage = STAGE_INITIALIZING;
        this.servicePlans = Objects.requireNonNull(ReactorCloudFoundryClient.super.servicePlans(), "servicePlans");
        servicePlansBuildStage = STAGE_INITIALIZED;
      }
      return this.servicePlans;
    }

    private byte servicePlansV3BuildStage = STAGE_UNINITIALIZED;
    private ServicePlansV3 servicePlansV3;

    ServicePlansV3 servicePlansV3() {
      if (servicePlansV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (servicePlansV3BuildStage == STAGE_UNINITIALIZED) {
        servicePlansV3BuildStage = STAGE_INITIALIZING;
        this.servicePlansV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.servicePlansV3(), "servicePlansV3");
        servicePlansV3BuildStage = STAGE_INITIALIZED;
      }
      return this.servicePlansV3;
    }

    private byte serviceUsageEventsBuildStage = STAGE_UNINITIALIZED;
    private ServiceUsageEvents serviceUsageEvents;

    ServiceUsageEvents serviceUsageEvents() {
      if (serviceUsageEventsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceUsageEventsBuildStage == STAGE_UNINITIALIZED) {
        serviceUsageEventsBuildStage = STAGE_INITIALIZING;
        this.serviceUsageEvents = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceUsageEvents(), "serviceUsageEvents");
        serviceUsageEventsBuildStage = STAGE_INITIALIZED;
      }
      return this.serviceUsageEvents;
    }

    private byte servicesBuildStage = STAGE_UNINITIALIZED;
    private Services services;

    Services services() {
      if (servicesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (servicesBuildStage == STAGE_UNINITIALIZED) {
        servicesBuildStage = STAGE_INITIALIZING;
        this.services = Objects.requireNonNull(ReactorCloudFoundryClient.super.services(), "services");
        servicesBuildStage = STAGE_INITIALIZED;
      }
      return this.services;
    }

    private byte sharedDomainsBuildStage = STAGE_UNINITIALIZED;
    private SharedDomains sharedDomains;

    SharedDomains sharedDomains() {
      if (sharedDomainsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sharedDomainsBuildStage == STAGE_UNINITIALIZED) {
        sharedDomainsBuildStage = STAGE_INITIALIZING;
        this.sharedDomains = Objects.requireNonNull(ReactorCloudFoundryClient.super.sharedDomains(), "sharedDomains");
        sharedDomainsBuildStage = STAGE_INITIALIZED;
      }
      return this.sharedDomains;
    }

    private byte spaceQuotaDefinitionsBuildStage = STAGE_UNINITIALIZED;
    private SpaceQuotaDefinitions spaceQuotaDefinitions;

    SpaceQuotaDefinitions spaceQuotaDefinitions() {
      if (spaceQuotaDefinitionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (spaceQuotaDefinitionsBuildStage == STAGE_UNINITIALIZED) {
        spaceQuotaDefinitionsBuildStage = STAGE_INITIALIZING;
        this.spaceQuotaDefinitions = Objects.requireNonNull(ReactorCloudFoundryClient.super.spaceQuotaDefinitions(), "spaceQuotaDefinitions");
        spaceQuotaDefinitionsBuildStage = STAGE_INITIALIZED;
      }
      return this.spaceQuotaDefinitions;
    }

    private byte spacesBuildStage = STAGE_UNINITIALIZED;
    private Spaces spaces;

    Spaces spaces() {
      if (spacesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (spacesBuildStage == STAGE_UNINITIALIZED) {
        spacesBuildStage = STAGE_INITIALIZING;
        this.spaces = Objects.requireNonNull(ReactorCloudFoundryClient.super.spaces(), "spaces");
        spacesBuildStage = STAGE_INITIALIZED;
      }
      return this.spaces;
    }

    private byte spacesV3BuildStage = STAGE_UNINITIALIZED;
    private SpacesV3 spacesV3;

    SpacesV3 spacesV3() {
      if (spacesV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (spacesV3BuildStage == STAGE_UNINITIALIZED) {
        spacesV3BuildStage = STAGE_INITIALIZING;
        this.spacesV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.spacesV3(), "spacesV3");
        spacesV3BuildStage = STAGE_INITIALIZED;
      }
      return this.spacesV3;
    }

    private byte stacksBuildStage = STAGE_UNINITIALIZED;
    private Stacks stacks;

    Stacks stacks() {
      if (stacksBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (stacksBuildStage == STAGE_UNINITIALIZED) {
        stacksBuildStage = STAGE_INITIALIZING;
        this.stacks = Objects.requireNonNull(ReactorCloudFoundryClient.super.stacks(), "stacks");
        stacksBuildStage = STAGE_INITIALIZED;
      }
      return this.stacks;
    }

    private byte stacksV3BuildStage = STAGE_UNINITIALIZED;
    private StacksV3 stacksV3;

    StacksV3 stacksV3() {
      if (stacksV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (stacksV3BuildStage == STAGE_UNINITIALIZED) {
        stacksV3BuildStage = STAGE_INITIALIZING;
        this.stacksV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.stacksV3(), "stacksV3");
        stacksV3BuildStage = STAGE_INITIALIZED;
      }
      return this.stacksV3;
    }

    private byte tasksBuildStage = STAGE_UNINITIALIZED;
    private Tasks tasks;

    Tasks tasks() {
      if (tasksBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (tasksBuildStage == STAGE_UNINITIALIZED) {
        tasksBuildStage = STAGE_INITIALIZING;
        this.tasks = Objects.requireNonNull(ReactorCloudFoundryClient.super.tasks(), "tasks");
        tasksBuildStage = STAGE_INITIALIZED;
      }
      return this.tasks;
    }

    private byte userProvidedServiceInstancesBuildStage = STAGE_UNINITIALIZED;
    private UserProvidedServiceInstances userProvidedServiceInstances;

    UserProvidedServiceInstances userProvidedServiceInstances() {
      if (userProvidedServiceInstancesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (userProvidedServiceInstancesBuildStage == STAGE_UNINITIALIZED) {
        userProvidedServiceInstancesBuildStage = STAGE_INITIALIZING;
        this.userProvidedServiceInstances = Objects.requireNonNull(ReactorCloudFoundryClient.super.userProvidedServiceInstances(), "userProvidedServiceInstances");
        userProvidedServiceInstancesBuildStage = STAGE_INITIALIZED;
      }
      return this.userProvidedServiceInstances;
    }

    private byte usersBuildStage = STAGE_UNINITIALIZED;
    private Users users;

    Users users() {
      if (usersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (usersBuildStage == STAGE_UNINITIALIZED) {
        usersBuildStage = STAGE_INITIALIZING;
        this.users = Objects.requireNonNull(ReactorCloudFoundryClient.super.users(), "users");
        usersBuildStage = STAGE_INITIALIZED;
      }
      return this.users;
    }

    private byte requestTagsBuildStage = STAGE_UNINITIALIZED;
    private Map<String, String> requestTags;

    Map<String, String> getRequestTags() {
      if (requestTagsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (requestTagsBuildStage == STAGE_UNINITIALIZED) {
        requestTagsBuildStage = STAGE_INITIALIZING;
        this.requestTags = createUnmodifiableMap(true, false, ReactorCloudFoundryClient.super.getRequestTags());
        requestTagsBuildStage = STAGE_INITIALIZED;
      }
      return this.requestTags;
    }

    void requestTags(Map<String, String> requestTags) {
      this.requestTags = requestTags;
      requestTagsBuildStage = STAGE_INITIALIZED;
    }

    private byte rootV2BuildStage = STAGE_UNINITIALIZED;
    private Mono<String> rootV2;

    Mono<String> getRootV2() {
      if (rootV2BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rootV2BuildStage == STAGE_UNINITIALIZED) {
        rootV2BuildStage = STAGE_INITIALIZING;
        this.rootV2 = Objects.requireNonNull(ReactorCloudFoundryClient.super.getRootV2(), "rootV2");
        rootV2BuildStage = STAGE_INITIALIZED;
      }
      return this.rootV2;
    }

    void rootV2(Mono<String> rootV2) {
      this.rootV2 = rootV2;
      rootV2BuildStage = STAGE_INITIALIZED;
    }

    private byte rootV3BuildStage = STAGE_UNINITIALIZED;
    private Mono<String> rootV3;

    Mono<String> getRootV3() {
      if (rootV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rootV3BuildStage == STAGE_UNINITIALIZED) {
        rootV3BuildStage = STAGE_INITIALIZING;
        this.rootV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.getRootV3(), "rootV3");
        rootV3BuildStage = STAGE_INITIALIZED;
      }
      return this.rootV3;
    }

    void rootV3(Mono<String> rootV3) {
      this.rootV3 = rootV3;
      rootV3BuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (adminV3BuildStage == STAGE_INITIALIZING) attributes.add("adminV3");
      if (applicationUsageEventsBuildStage == STAGE_INITIALIZING) attributes.add("applicationUsageEvents");
      if (applicationsV2BuildStage == STAGE_INITIALIZING) attributes.add("applicationsV2");
      if (applicationsV3BuildStage == STAGE_INITIALIZING) attributes.add("applicationsV3");
      if (auditEventsV3BuildStage == STAGE_INITIALIZING) attributes.add("auditEventsV3");
      if (blobstoresBuildStage == STAGE_INITIALIZING) attributes.add("blobstores");
      if (buildpacksBuildStage == STAGE_INITIALIZING) attributes.add("buildpacks");
      if (buildpacksV3BuildStage == STAGE_INITIALIZING) attributes.add("buildpacksV3");
      if (buildsBuildStage == STAGE_INITIALIZING) attributes.add("builds");
      if (deploymentsV3BuildStage == STAGE_INITIALIZING) attributes.add("deploymentsV3");
      if (domainsBuildStage == STAGE_INITIALIZING) attributes.add("domains");
      if (domainsV3BuildStage == STAGE_INITIALIZING) attributes.add("domainsV3");
      if (dropletsBuildStage == STAGE_INITIALIZING) attributes.add("droplets");
      if (environmentVariableGroupsBuildStage == STAGE_INITIALIZING) attributes.add("environmentVariableGroups");
      if (eventsBuildStage == STAGE_INITIALIZING) attributes.add("events");
      if (featureFlagsBuildStage == STAGE_INITIALIZING) attributes.add("featureFlags");
      if (infoBuildStage == STAGE_INITIALIZING) attributes.add("info");
      if (isolationSegmentsBuildStage == STAGE_INITIALIZING) attributes.add("isolationSegments");
      if (jobsBuildStage == STAGE_INITIALIZING) attributes.add("jobs");
      if (jobsV3BuildStage == STAGE_INITIALIZING) attributes.add("jobsV3");
      if (organizationQuotaDefinitionsBuildStage == STAGE_INITIALIZING) attributes.add("organizationQuotaDefinitions");
      if (organizationsBuildStage == STAGE_INITIALIZING) attributes.add("organizations");
      if (organizationsV3BuildStage == STAGE_INITIALIZING) attributes.add("organizationsV3");
      if (packagesBuildStage == STAGE_INITIALIZING) attributes.add("packages");
      if (privateDomainsBuildStage == STAGE_INITIALIZING) attributes.add("privateDomains");
      if (processesBuildStage == STAGE_INITIALIZING) attributes.add("processes");
      if (resourceMatchBuildStage == STAGE_INITIALIZING) attributes.add("resourceMatch");
      if (resourceMatchV3BuildStage == STAGE_INITIALIZING) attributes.add("resourceMatchV3");
      if (rolesV3BuildStage == STAGE_INITIALIZING) attributes.add("rolesV3");
      if (routeMappingsBuildStage == STAGE_INITIALIZING) attributes.add("routeMappings");
      if (routesBuildStage == STAGE_INITIALIZING) attributes.add("routes");
      if (routesV3BuildStage == STAGE_INITIALIZING) attributes.add("routesV3");
      if (securityGroupsBuildStage == STAGE_INITIALIZING) attributes.add("securityGroups");
      if (securityGroupsV3BuildStage == STAGE_INITIALIZING) attributes.add("securityGroupsV3");
      if (serviceBindingsV2BuildStage == STAGE_INITIALIZING) attributes.add("serviceBindingsV2");
      if (serviceBindingsV3BuildStage == STAGE_INITIALIZING) attributes.add("serviceBindingsV3");
      if (serviceBrokersBuildStage == STAGE_INITIALIZING) attributes.add("serviceBrokers");
      if (serviceBrokersV3BuildStage == STAGE_INITIALIZING) attributes.add("serviceBrokersV3");
      if (serviceInstancesBuildStage == STAGE_INITIALIZING) attributes.add("serviceInstances");
      if (serviceInstancesV3BuildStage == STAGE_INITIALIZING) attributes.add("serviceInstancesV3");
      if (serviceKeysBuildStage == STAGE_INITIALIZING) attributes.add("serviceKeys");
      if (serviceOfferingsV3BuildStage == STAGE_INITIALIZING) attributes.add("serviceOfferingsV3");
      if (servicePlanVisibilitiesBuildStage == STAGE_INITIALIZING) attributes.add("servicePlanVisibilities");
      if (servicePlansBuildStage == STAGE_INITIALIZING) attributes.add("servicePlans");
      if (servicePlansV3BuildStage == STAGE_INITIALIZING) attributes.add("servicePlansV3");
      if (serviceUsageEventsBuildStage == STAGE_INITIALIZING) attributes.add("serviceUsageEvents");
      if (servicesBuildStage == STAGE_INITIALIZING) attributes.add("services");
      if (sharedDomainsBuildStage == STAGE_INITIALIZING) attributes.add("sharedDomains");
      if (spaceQuotaDefinitionsBuildStage == STAGE_INITIALIZING) attributes.add("spaceQuotaDefinitions");
      if (spacesBuildStage == STAGE_INITIALIZING) attributes.add("spaces");
      if (spacesV3BuildStage == STAGE_INITIALIZING) attributes.add("spacesV3");
      if (stacksBuildStage == STAGE_INITIALIZING) attributes.add("stacks");
      if (stacksV3BuildStage == STAGE_INITIALIZING) attributes.add("stacksV3");
      if (tasksBuildStage == STAGE_INITIALIZING) attributes.add("tasks");
      if (userProvidedServiceInstancesBuildStage == STAGE_INITIALIZING) attributes.add("userProvidedServiceInstances");
      if (usersBuildStage == STAGE_INITIALIZING) attributes.add("users");
      if (requestTagsBuildStage == STAGE_INITIALIZING) attributes.add("requestTags");
      if (rootV2BuildStage == STAGE_INITIALIZING) attributes.add("rootV2");
      if (rootV3BuildStage == STAGE_INITIALIZING) attributes.add("rootV3");
      return "Cannot build ReactorCloudFoundryClient, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The computed-at-construction value of the {@code adminV3} attribute
   */
  @Override
  public AdminV3 adminV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.adminV3()
        : this.adminV3;
  }

  /**
   * @return The computed-at-construction value of the {@code applicationUsageEvents} attribute
   */
  @Override
  public ApplicationUsageEvents applicationUsageEvents() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.applicationUsageEvents()
        : this.applicationUsageEvents;
  }

  /**
   * @return The computed-at-construction value of the {@code applicationsV2} attribute
   */
  @Override
  public ApplicationsV2 applicationsV2() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.applicationsV2()
        : this.applicationsV2;
  }

  /**
   * @return The computed-at-construction value of the {@code applicationsV3} attribute
   */
  @Override
  public ApplicationsV3 applicationsV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.applicationsV3()
        : this.applicationsV3;
  }

  /**
   * @return The computed-at-construction value of the {@code auditEventsV3} attribute
   */
  @Override
  public AuditEventsV3 auditEventsV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.auditEventsV3()
        : this.auditEventsV3;
  }

  /**
   * @return The computed-at-construction value of the {@code blobstores} attribute
   */
  @Override
  public Blobstores blobstores() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.blobstores()
        : this.blobstores;
  }

  /**
   * @return The computed-at-construction value of the {@code buildpacks} attribute
   */
  @Override
  public Buildpacks buildpacks() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.buildpacks()
        : this.buildpacks;
  }

  /**
   * @return The computed-at-construction value of the {@code buildpacksV3} attribute
   */
  @Override
  public BuildpacksV3 buildpacksV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.buildpacksV3()
        : this.buildpacksV3;
  }

  /**
   * @return The computed-at-construction value of the {@code builds} attribute
   */
  @Override
  public Builds builds() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.builds()
        : this.builds;
  }

  /**
   * @return The computed-at-construction value of the {@code deploymentsV3} attribute
   */
  @Override
  public DeploymentsV3 deploymentsV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.deploymentsV3()
        : this.deploymentsV3;
  }

  /**
   * @return The computed-at-construction value of the {@code domains} attribute
   */
  @Override
  public Domains domains() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.domains()
        : this.domains;
  }

  /**
   * @return The computed-at-construction value of the {@code domainsV3} attribute
   */
  @Override
  public DomainsV3 domainsV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.domainsV3()
        : this.domainsV3;
  }

  /**
   * @return The computed-at-construction value of the {@code droplets} attribute
   */
  @Override
  public Droplets droplets() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.droplets()
        : this.droplets;
  }

  /**
   * @return The computed-at-construction value of the {@code environmentVariableGroups} attribute
   */
  @Override
  public EnvironmentVariableGroups environmentVariableGroups() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.environmentVariableGroups()
        : this.environmentVariableGroups;
  }

  /**
   * @return The computed-at-construction value of the {@code events} attribute
   */
  @Override
  public Events events() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.events()
        : this.events;
  }

  /**
   * @return The computed-at-construction value of the {@code featureFlags} attribute
   */
  @Override
  public FeatureFlags featureFlags() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.featureFlags()
        : this.featureFlags;
  }

  /**
   * @return The computed-at-construction value of the {@code info} attribute
   */
  @Override
  public Info info() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.info()
        : this.info;
  }

  /**
   * @return The computed-at-construction value of the {@code isolationSegments} attribute
   */
  @Override
  public IsolationSegments isolationSegments() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isolationSegments()
        : this.isolationSegments;
  }

  /**
   * @return The computed-at-construction value of the {@code jobs} attribute
   */
  @Override
  public Jobs jobs() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.jobs()
        : this.jobs;
  }

  /**
   * @return The computed-at-construction value of the {@code jobsV3} attribute
   */
  @Override
  public JobsV3 jobsV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.jobsV3()
        : this.jobsV3;
  }

  /**
   * @return The computed-at-construction value of the {@code organizationQuotaDefinitions} attribute
   */
  @Override
  public OrganizationQuotaDefinitions organizationQuotaDefinitions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.organizationQuotaDefinitions()
        : this.organizationQuotaDefinitions;
  }

  /**
   * @return The computed-at-construction value of the {@code organizations} attribute
   */
  @Override
  public Organizations organizations() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.organizations()
        : this.organizations;
  }

  /**
   * @return The computed-at-construction value of the {@code organizationsV3} attribute
   */
  @Override
  public OrganizationsV3 organizationsV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.organizationsV3()
        : this.organizationsV3;
  }

  /**
   * @return The computed-at-construction value of the {@code packages} attribute
   */
  @Override
  public Packages packages() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.packages()
        : this.packages;
  }

  /**
   * @return The computed-at-construction value of the {@code privateDomains} attribute
   */
  @Override
  public PrivateDomains privateDomains() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.privateDomains()
        : this.privateDomains;
  }

  /**
   * @return The computed-at-construction value of the {@code processes} attribute
   */
  @Override
  public Processes processes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.processes()
        : this.processes;
  }

  /**
   * @return The computed-at-construction value of the {@code resourceMatch} attribute
   */
  @Override
  public ResourceMatch resourceMatch() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.resourceMatch()
        : this.resourceMatch;
  }

  /**
   * @return The computed-at-construction value of the {@code resourceMatchV3} attribute
   */
  @Override
  public ResourceMatchV3 resourceMatchV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.resourceMatchV3()
        : this.resourceMatchV3;
  }

  /**
   * @return The computed-at-construction value of the {@code rolesV3} attribute
   */
  @Override
  public RolesV3 rolesV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.rolesV3()
        : this.rolesV3;
  }

  /**
   * @return The computed-at-construction value of the {@code routeMappings} attribute
   */
  @Override
  public RouteMappings routeMappings() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.routeMappings()
        : this.routeMappings;
  }

  /**
   * @return The computed-at-construction value of the {@code routes} attribute
   */
  @Override
  public Routes routes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.routes()
        : this.routes;
  }

  /**
   * @return The computed-at-construction value of the {@code routesV3} attribute
   */
  @Override
  public RoutesV3 routesV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.routesV3()
        : this.routesV3;
  }

  /**
   * @return The computed-at-construction value of the {@code securityGroups} attribute
   */
  @Override
  public SecurityGroups securityGroups() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.securityGroups()
        : this.securityGroups;
  }

  /**
   * @return The computed-at-construction value of the {@code securityGroupsV3} attribute
   */
  @Override
  public SecurityGroupsV3 securityGroupsV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.securityGroupsV3()
        : this.securityGroupsV3;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceBindingsV2} attribute
   */
  @Override
  public ServiceBindingsV2 serviceBindingsV2() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceBindingsV2()
        : this.serviceBindingsV2;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceBindingsV3} attribute
   */
  @Override
  public ServiceBindingsV3 serviceBindingsV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceBindingsV3()
        : this.serviceBindingsV3;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceBrokers} attribute
   */
  @Override
  public ServiceBrokers serviceBrokers() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceBrokers()
        : this.serviceBrokers;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceBrokersV3} attribute
   */
  @Override
  public ServiceBrokersV3 serviceBrokersV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceBrokersV3()
        : this.serviceBrokersV3;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceInstances} attribute
   */
  @Override
  public ServiceInstances serviceInstances() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceInstances()
        : this.serviceInstances;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceInstancesV3} attribute
   */
  @Override
  public ServiceInstancesV3 serviceInstancesV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceInstancesV3()
        : this.serviceInstancesV3;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceKeys} attribute
   */
  @Override
  public ServiceKeys serviceKeys() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceKeys()
        : this.serviceKeys;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceOfferingsV3} attribute
   */
  @Override
  public ServiceOfferingsV3 serviceOfferingsV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceOfferingsV3()
        : this.serviceOfferingsV3;
  }

  /**
   * @return The computed-at-construction value of the {@code servicePlanVisibilities} attribute
   */
  @Override
  public ServicePlanVisibilities servicePlanVisibilities() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.servicePlanVisibilities()
        : this.servicePlanVisibilities;
  }

  /**
   * @return The computed-at-construction value of the {@code servicePlans} attribute
   */
  @Override
  public ServicePlans servicePlans() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.servicePlans()
        : this.servicePlans;
  }

  /**
   * @return The computed-at-construction value of the {@code servicePlansV3} attribute
   */
  @Override
  public ServicePlansV3 servicePlansV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.servicePlansV3()
        : this.servicePlansV3;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceUsageEvents} attribute
   */
  @Override
  public ServiceUsageEvents serviceUsageEvents() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceUsageEvents()
        : this.serviceUsageEvents;
  }

  /**
   * @return The computed-at-construction value of the {@code services} attribute
   */
  @Override
  public Services services() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.services()
        : this.services;
  }

  /**
   * @return The computed-at-construction value of the {@code sharedDomains} attribute
   */
  @Override
  public SharedDomains sharedDomains() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.sharedDomains()
        : this.sharedDomains;
  }

  /**
   * @return The computed-at-construction value of the {@code spaceQuotaDefinitions} attribute
   */
  @Override
  public SpaceQuotaDefinitions spaceQuotaDefinitions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.spaceQuotaDefinitions()
        : this.spaceQuotaDefinitions;
  }

  /**
   * @return The computed-at-construction value of the {@code spaces} attribute
   */
  @Override
  public Spaces spaces() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.spaces()
        : this.spaces;
  }

  /**
   * @return The computed-at-construction value of the {@code spacesV3} attribute
   */
  @Override
  public SpacesV3 spacesV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.spacesV3()
        : this.spacesV3;
  }

  /**
   * @return The computed-at-construction value of the {@code stacks} attribute
   */
  @Override
  public Stacks stacks() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.stacks()
        : this.stacks;
  }

  /**
   * @return The computed-at-construction value of the {@code stacksV3} attribute
   */
  @Override
  public StacksV3 stacksV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.stacksV3()
        : this.stacksV3;
  }

  /**
   * @return The computed-at-construction value of the {@code tasks} attribute
   */
  @Override
  public Tasks tasks() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.tasks()
        : this.tasks;
  }

  /**
   * @return The computed-at-construction value of the {@code userProvidedServiceInstances} attribute
   */
  @Override
  public UserProvidedServiceInstances userProvidedServiceInstances() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.userProvidedServiceInstances()
        : this.userProvidedServiceInstances;
  }

  /**
   * @return The computed-at-construction value of the {@code users} attribute
   */
  @Override
  public Users users() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.users()
        : this.users;
  }

  /**
   * The connection context
   */
  @Override
  public ConnectionContext getConnectionContext() {
    return connectionContext;
  }

  /**
   * Map of http header name and value which will be added to every request to the
   * controller
   */
  @Override
  public Map<String, String> getRequestTags() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRequestTags()
        : this.requestTags;
  }

  /**
   * @return The value of the {@code rootV2} attribute
   */
  @Override
  public Mono<String> getRootV2() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRootV2()
        : this.rootV2;
  }

  /**
   * @return The value of the {@code rootV3} attribute
   */
  @Override
  public Mono<String> getRootV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRootV3()
        : this.rootV3;
  }

  /**
   * The token provider
   */
  @Override
  public TokenProvider getTokenProvider() {
    return tokenProvider;
  }

  /**
   * This instance is equal to all instances of {@code ReactorCloudFoundryClient} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ReactorCloudFoundryClient
        && equalTo(0, (ReactorCloudFoundryClient) another);
  }

  private boolean equalTo(int synthetic, ReactorCloudFoundryClient another) {
    return adminV3.equals(another.adminV3)
        && applicationUsageEvents.equals(another.applicationUsageEvents)
        && applicationsV2.equals(another.applicationsV2)
        && applicationsV3.equals(another.applicationsV3)
        && auditEventsV3.equals(another.auditEventsV3)
        && blobstores.equals(another.blobstores)
        && buildpacks.equals(another.buildpacks)
        && buildpacksV3.equals(another.buildpacksV3)
        && builds.equals(another.builds)
        && deploymentsV3.equals(another.deploymentsV3)
        && domains.equals(another.domains)
        && domainsV3.equals(another.domainsV3)
        && droplets.equals(another.droplets)
        && environmentVariableGroups.equals(another.environmentVariableGroups)
        && events.equals(another.events)
        && featureFlags.equals(another.featureFlags)
        && info.equals(another.info)
        && isolationSegments.equals(another.isolationSegments)
        && jobs.equals(another.jobs)
        && jobsV3.equals(another.jobsV3)
        && organizationQuotaDefinitions.equals(another.organizationQuotaDefinitions)
        && organizations.equals(another.organizations)
        && organizationsV3.equals(another.organizationsV3)
        && packages.equals(another.packages)
        && privateDomains.equals(another.privateDomains)
        && processes.equals(another.processes)
        && resourceMatch.equals(another.resourceMatch)
        && resourceMatchV3.equals(another.resourceMatchV3)
        && rolesV3.equals(another.rolesV3)
        && routeMappings.equals(another.routeMappings)
        && routes.equals(another.routes)
        && routesV3.equals(another.routesV3)
        && securityGroups.equals(another.securityGroups)
        && securityGroupsV3.equals(another.securityGroupsV3)
        && serviceBindingsV2.equals(another.serviceBindingsV2)
        && serviceBindingsV3.equals(another.serviceBindingsV3)
        && serviceBrokers.equals(another.serviceBrokers)
        && serviceBrokersV3.equals(another.serviceBrokersV3)
        && serviceInstances.equals(another.serviceInstances)
        && serviceInstancesV3.equals(another.serviceInstancesV3)
        && serviceKeys.equals(another.serviceKeys)
        && serviceOfferingsV3.equals(another.serviceOfferingsV3)
        && servicePlanVisibilities.equals(another.servicePlanVisibilities)
        && servicePlans.equals(another.servicePlans)
        && servicePlansV3.equals(another.servicePlansV3)
        && serviceUsageEvents.equals(another.serviceUsageEvents)
        && services.equals(another.services)
        && sharedDomains.equals(another.sharedDomains)
        && spaceQuotaDefinitions.equals(another.spaceQuotaDefinitions)
        && spaces.equals(another.spaces)
        && spacesV3.equals(another.spacesV3)
        && stacks.equals(another.stacks)
        && stacksV3.equals(another.stacksV3)
        && tasks.equals(another.tasks)
        && userProvidedServiceInstances.equals(another.userProvidedServiceInstances)
        && users.equals(another.users)
        && connectionContext.equals(another.connectionContext)
        && requestTags.equals(another.requestTags)
        && rootV2.equals(another.rootV2)
        && rootV3.equals(another.rootV3)
        && tokenProvider.equals(another.tokenProvider);
  }

  /**
   * Computes a hash code from attributes: {@code adminV3}, {@code applicationUsageEvents}, {@code applicationsV2}, {@code applicationsV3}, {@code auditEventsV3}, {@code blobstores}, {@code buildpacks}, {@code buildpacksV3}, {@code builds}, {@code deploymentsV3}, {@code domains}, {@code domainsV3}, {@code droplets}, {@code environmentVariableGroups}, {@code events}, {@code featureFlags}, {@code info}, {@code isolationSegments}, {@code jobs}, {@code jobsV3}, {@code organizationQuotaDefinitions}, {@code organizations}, {@code organizationsV3}, {@code packages}, {@code privateDomains}, {@code processes}, {@code resourceMatch}, {@code resourceMatchV3}, {@code rolesV3}, {@code routeMappings}, {@code routes}, {@code routesV3}, {@code securityGroups}, {@code securityGroupsV3}, {@code serviceBindingsV2}, {@code serviceBindingsV3}, {@code serviceBrokers}, {@code serviceBrokersV3}, {@code serviceInstances}, {@code serviceInstancesV3}, {@code serviceKeys}, {@code serviceOfferingsV3}, {@code servicePlanVisibilities}, {@code servicePlans}, {@code servicePlansV3}, {@code serviceUsageEvents}, {@code services}, {@code sharedDomains}, {@code spaceQuotaDefinitions}, {@code spaces}, {@code spacesV3}, {@code stacks}, {@code stacksV3}, {@code tasks}, {@code userProvidedServiceInstances}, {@code users}, {@code connectionContext}, {@code requestTags}, {@code rootV2}, {@code rootV3}, {@code tokenProvider}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + adminV3.hashCode();
    h += (h << 5) + applicationUsageEvents.hashCode();
    h += (h << 5) + applicationsV2.hashCode();
    h += (h << 5) + applicationsV3.hashCode();
    h += (h << 5) + auditEventsV3.hashCode();
    h += (h << 5) + blobstores.hashCode();
    h += (h << 5) + buildpacks.hashCode();
    h += (h << 5) + buildpacksV3.hashCode();
    h += (h << 5) + builds.hashCode();
    h += (h << 5) + deploymentsV3.hashCode();
    h += (h << 5) + domains.hashCode();
    h += (h << 5) + domainsV3.hashCode();
    h += (h << 5) + droplets.hashCode();
    h += (h << 5) + environmentVariableGroups.hashCode();
    h += (h << 5) + events.hashCode();
    h += (h << 5) + featureFlags.hashCode();
    h += (h << 5) + info.hashCode();
    h += (h << 5) + isolationSegments.hashCode();
    h += (h << 5) + jobs.hashCode();
    h += (h << 5) + jobsV3.hashCode();
    h += (h << 5) + organizationQuotaDefinitions.hashCode();
    h += (h << 5) + organizations.hashCode();
    h += (h << 5) + organizationsV3.hashCode();
    h += (h << 5) + packages.hashCode();
    h += (h << 5) + privateDomains.hashCode();
    h += (h << 5) + processes.hashCode();
    h += (h << 5) + resourceMatch.hashCode();
    h += (h << 5) + resourceMatchV3.hashCode();
    h += (h << 5) + rolesV3.hashCode();
    h += (h << 5) + routeMappings.hashCode();
    h += (h << 5) + routes.hashCode();
    h += (h << 5) + routesV3.hashCode();
    h += (h << 5) + securityGroups.hashCode();
    h += (h << 5) + securityGroupsV3.hashCode();
    h += (h << 5) + serviceBindingsV2.hashCode();
    h += (h << 5) + serviceBindingsV3.hashCode();
    h += (h << 5) + serviceBrokers.hashCode();
    h += (h << 5) + serviceBrokersV3.hashCode();
    h += (h << 5) + serviceInstances.hashCode();
    h += (h << 5) + serviceInstancesV3.hashCode();
    h += (h << 5) + serviceKeys.hashCode();
    h += (h << 5) + serviceOfferingsV3.hashCode();
    h += (h << 5) + servicePlanVisibilities.hashCode();
    h += (h << 5) + servicePlans.hashCode();
    h += (h << 5) + servicePlansV3.hashCode();
    h += (h << 5) + serviceUsageEvents.hashCode();
    h += (h << 5) + services.hashCode();
    h += (h << 5) + sharedDomains.hashCode();
    h += (h << 5) + spaceQuotaDefinitions.hashCode();
    h += (h << 5) + spaces.hashCode();
    h += (h << 5) + spacesV3.hashCode();
    h += (h << 5) + stacks.hashCode();
    h += (h << 5) + stacksV3.hashCode();
    h += (h << 5) + tasks.hashCode();
    h += (h << 5) + userProvidedServiceInstances.hashCode();
    h += (h << 5) + users.hashCode();
    h += (h << 5) + connectionContext.hashCode();
    h += (h << 5) + requestTags.hashCode();
    h += (h << 5) + rootV2.hashCode();
    h += (h << 5) + rootV3.hashCode();
    h += (h << 5) + tokenProvider.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ReactorCloudFoundryClient} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReactorCloudFoundryClient{"
        + "adminV3=" + adminV3
        + ", applicationUsageEvents=" + applicationUsageEvents
        + ", applicationsV2=" + applicationsV2
        + ", applicationsV3=" + applicationsV3
        + ", auditEventsV3=" + auditEventsV3
        + ", blobstores=" + blobstores
        + ", buildpacks=" + buildpacks
        + ", buildpacksV3=" + buildpacksV3
        + ", builds=" + builds
        + ", deploymentsV3=" + deploymentsV3
        + ", domains=" + domains
        + ", domainsV3=" + domainsV3
        + ", droplets=" + droplets
        + ", environmentVariableGroups=" + environmentVariableGroups
        + ", events=" + events
        + ", featureFlags=" + featureFlags
        + ", info=" + info
        + ", isolationSegments=" + isolationSegments
        + ", jobs=" + jobs
        + ", jobsV3=" + jobsV3
        + ", organizationQuotaDefinitions=" + organizationQuotaDefinitions
        + ", organizations=" + organizations
        + ", organizationsV3=" + organizationsV3
        + ", packages=" + packages
        + ", privateDomains=" + privateDomains
        + ", processes=" + processes
        + ", resourceMatch=" + resourceMatch
        + ", resourceMatchV3=" + resourceMatchV3
        + ", rolesV3=" + rolesV3
        + ", routeMappings=" + routeMappings
        + ", routes=" + routes
        + ", routesV3=" + routesV3
        + ", securityGroups=" + securityGroups
        + ", securityGroupsV3=" + securityGroupsV3
        + ", serviceBindingsV2=" + serviceBindingsV2
        + ", serviceBindingsV3=" + serviceBindingsV3
        + ", serviceBrokers=" + serviceBrokers
        + ", serviceBrokersV3=" + serviceBrokersV3
        + ", serviceInstances=" + serviceInstances
        + ", serviceInstancesV3=" + serviceInstancesV3
        + ", serviceKeys=" + serviceKeys
        + ", serviceOfferingsV3=" + serviceOfferingsV3
        + ", servicePlanVisibilities=" + servicePlanVisibilities
        + ", servicePlans=" + servicePlans
        + ", servicePlansV3=" + servicePlansV3
        + ", serviceUsageEvents=" + serviceUsageEvents
        + ", services=" + services
        + ", sharedDomains=" + sharedDomains
        + ", spaceQuotaDefinitions=" + spaceQuotaDefinitions
        + ", spaces=" + spaces
        + ", spacesV3=" + spacesV3
        + ", stacks=" + stacks
        + ", stacksV3=" + stacksV3
        + ", tasks=" + tasks
        + ", userProvidedServiceInstances=" + userProvidedServiceInstances
        + ", users=" + users
        + ", connectionContext=" + connectionContext
        + ", requestTags=" + requestTags
        + ", rootV2=" + rootV2
        + ", rootV3=" + rootV3
        + ", tokenProvider=" + tokenProvider
        + "}";
  }

  /**
   * Creates a builder for {@link ReactorCloudFoundryClient ReactorCloudFoundryClient}.
   * <pre>
   * ReactorCloudFoundryClient.builder()
   *    .connectionContext(org.cloudfoundry.reactor.ConnectionContext) // required {@link ReactorCloudFoundryClient#getConnectionContext() connectionContext}
   *    .requestTag|putAllRequestTags(String =&gt; String) // {@link ReactorCloudFoundryClient#getRequestTags() requestTags} mappings
   *    .rootV2(reactor.core.publisher.Mono&amp;lt;String&amp;gt;) // optional {@link ReactorCloudFoundryClient#getRootV2() rootV2}
   *    .rootV3(reactor.core.publisher.Mono&amp;lt;String&amp;gt;) // optional {@link ReactorCloudFoundryClient#getRootV3() rootV3}
   *    .tokenProvider(org.cloudfoundry.reactor.TokenProvider) // required {@link ReactorCloudFoundryClient#getTokenProvider() tokenProvider}
   *    .build();
   * </pre>
   * @return A new ReactorCloudFoundryClient builder
   */
  public static ReactorCloudFoundryClient.Builder builder() {
    return new ReactorCloudFoundryClient.Builder();
  }

  /**
   * Builds instances of type {@link ReactorCloudFoundryClient ReactorCloudFoundryClient}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ReactorCloudFoundryClient", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CONNECTION_CONTEXT = 0x1L;
    private static final long INIT_BIT_TOKEN_PROVIDER = 0x2L;
    private static final long OPT_BIT_REQUEST_TAGS = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private ConnectionContext connectionContext;
    private Map<String, String> requestTags = new LinkedHashMap<String, String>();
    private Mono<String> rootV2;
    private Mono<String> rootV3;
    private TokenProvider tokenProvider;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReactorCloudFoundryClient} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReactorCloudFoundryClient instance) {
      return from((_ReactorCloudFoundryClient) instance);
    }

    /**
     * Copy abstract value type {@code _ReactorCloudFoundryClient} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ReactorCloudFoundryClient instance) {
      Objects.requireNonNull(instance, "instance");
      connectionContext(instance.getConnectionContext());
      putAllRequestTags(instance.getRequestTags());
      rootV2(instance.getRootV2());
      rootV3(instance.getRootV3());
      tokenProvider(instance.getTokenProvider());
      return this;
    }

    /**
     * Initializes the value for the {@link ReactorCloudFoundryClient#getConnectionContext() connectionContext} attribute.
     * @param connectionContext The value for connectionContext 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectionContext(ConnectionContext connectionContext) {
      this.connectionContext = Objects.requireNonNull(connectionContext, "connectionContext");
      initBits &= ~INIT_BIT_CONNECTION_CONTEXT;
      return this;
    }

    /**
     * Put one entry to the {@link ReactorCloudFoundryClient#getRequestTags() requestTags} map.
     * @param key The key in the requestTags map
     * @param value The associated value in the requestTags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requestTag(String key, String value) {
      this.requestTags.put(
          Objects.requireNonNull(key, "requestTags key"),
          Objects.requireNonNull(value, value == null ? "requestTags value for key: " + key : null));
      optBits |= OPT_BIT_REQUEST_TAGS;
      return this;
    }

    /**
     * Put one entry to the {@link ReactorCloudFoundryClient#getRequestTags() requestTags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requestTag(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.requestTags.put(
          Objects.requireNonNull(k, "requestTags key"),
          Objects.requireNonNull(v, v == null ? "requestTags value for key: " + k : null));
      optBits |= OPT_BIT_REQUEST_TAGS;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ReactorCloudFoundryClient#getRequestTags() requestTags} map. Nulls are not permitted
     * @param entries The entries that will be added to the requestTags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requestTags(Map<String, ? extends String> entries) {
      this.requestTags.clear();
      optBits |= OPT_BIT_REQUEST_TAGS;
      return putAllRequestTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ReactorCloudFoundryClient#getRequestTags() requestTags} map. Nulls are not permitted
     * @param entries The entries that will be added to the requestTags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllRequestTags(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.requestTags.put(
            Objects.requireNonNull(k, "requestTags key"),
            Objects.requireNonNull(v, v == null ? "requestTags value for key: " + k : null));
      }
      optBits |= OPT_BIT_REQUEST_TAGS;
      return this;
    }

    /**
     * Initializes the value for the {@link ReactorCloudFoundryClient#getRootV2() rootV2} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ReactorCloudFoundryClient#getRootV2() rootV2}.</em>
     * @param rootV2 The value for rootV2 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rootV2(Mono<String> rootV2) {
      this.rootV2 = Objects.requireNonNull(rootV2, "rootV2");
      return this;
    }

    /**
     * Initializes the value for the {@link ReactorCloudFoundryClient#getRootV3() rootV3} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ReactorCloudFoundryClient#getRootV3() rootV3}.</em>
     * @param rootV3 The value for rootV3 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rootV3(Mono<String> rootV3) {
      this.rootV3 = Objects.requireNonNull(rootV3, "rootV3");
      return this;
    }

    /**
     * Initializes the value for the {@link ReactorCloudFoundryClient#getTokenProvider() tokenProvider} attribute.
     * @param tokenProvider The value for tokenProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenProvider(TokenProvider tokenProvider) {
      this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider");
      initBits &= ~INIT_BIT_TOKEN_PROVIDER;
      return this;
    }

    /**
     * Builds a new {@link ReactorCloudFoundryClient ReactorCloudFoundryClient}.
     * @return An immutable instance of ReactorCloudFoundryClient
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ReactorCloudFoundryClient build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ReactorCloudFoundryClient(this);
    }

    private boolean requestTagsIsSet() {
      return (optBits & OPT_BIT_REQUEST_TAGS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONNECTION_CONTEXT) != 0) attributes.add("connectionContext");
      if ((initBits & INIT_BIT_TOKEN_PROVIDER) != 0) attributes.add("tokenProvider");
      return "Cannot build ReactorCloudFoundryClient, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
