package org.cloudfoundry.reactor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * A {@link RootProvider} that returns endpoints extracted from the `/v2/info` API for the configured endpoint.
 */
@Generated(from = "_InfoPayloadRootProvider", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class InfoPayloadRootProvider extends org.cloudfoundry.reactor._InfoPayloadRootProvider {
  private final String apiHost;
  private final Integer port;
  private final Boolean secure;
  private final ObjectMapper objectMapper;

  private InfoPayloadRootProvider(InfoPayloadRootProvider.Builder builder) {
    this.apiHost = builder.apiHost;
    this.port = builder.port;
    this.secure = builder.secure;
    this.objectMapper = builder.objectMapper;
  }

  /**
   * The hostname of the API root. Typically something like {@code api.run.pivotal.io}.
   */
  @Override
  public String getApiHost() {
    return apiHost;
  }

  /**
   * The port for the Cloud Foundry instance. Defaults to {@code 443}.
   */
  @Override
  public Optional<Integer> getPort() {
    return Optional.ofNullable(port);
  }

  /**
   * Whether the connection to the root API should be secure (i.e. using HTTPS). Defaults to {@code true}.
   */
  @Override
  public Optional<Boolean> getSecure() {
    return Optional.ofNullable(secure);
  }

  /**
   * @return The value of the {@code objectMapper} attribute
   */
  @Override
  public ObjectMapper getObjectMapper() {
    return objectMapper;
  }

  /**
   * This instance is equal to all instances of {@code InfoPayloadRootProvider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InfoPayloadRootProvider
        && equalTo(0, (InfoPayloadRootProvider) another);
  }

  private boolean equalTo(int synthetic, InfoPayloadRootProvider another) {
    return apiHost.equals(another.apiHost)
        && Objects.equals(port, another.port)
        && Objects.equals(secure, another.secure)
        && objectMapper.equals(another.objectMapper);
  }

  /**
   * Computes a hash code from attributes: {@code apiHost}, {@code port}, {@code secure}, {@code objectMapper}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + apiHost.hashCode();
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + Objects.hashCode(secure);
    h += (h << 5) + objectMapper.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InfoPayloadRootProvider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("InfoPayloadRootProvider{");
    builder.append("apiHost=").append(apiHost);
    if (port != null) {
      builder.append(", ");
      builder.append("port=").append(port);
    }
    if (secure != null) {
      builder.append(", ");
      builder.append("secure=").append(secure);
    }
    builder.append(", ");
    builder.append("objectMapper=").append(objectMapper);
    return builder.append("}").toString();
  }

  private static InfoPayloadRootProvider validate(InfoPayloadRootProvider instance) {
    instance.checkForValidApiHost();
    return instance;
  }

  /**
   * Creates a builder for {@link InfoPayloadRootProvider InfoPayloadRootProvider}.
   * <pre>
   * InfoPayloadRootProvider.builder()
   *    .apiHost(String) // required {@link InfoPayloadRootProvider#getApiHost() apiHost}
   *    .port(Integer) // optional {@link InfoPayloadRootProvider#getPort() port}
   *    .secure(Boolean) // optional {@link InfoPayloadRootProvider#getSecure() secure}
   *    .objectMapper(com.fasterxml.jackson.databind.ObjectMapper) // required {@link InfoPayloadRootProvider#getObjectMapper() objectMapper}
   *    .build();
   * </pre>
   * @return A new InfoPayloadRootProvider builder
   */
  public static InfoPayloadRootProvider.Builder builder() {
    return new InfoPayloadRootProvider.Builder();
  }

  /**
   * Builds instances of type {@link InfoPayloadRootProvider InfoPayloadRootProvider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_InfoPayloadRootProvider", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_API_HOST = 0x1L;
    private static final long INIT_BIT_OBJECT_MAPPER = 0x2L;
    private long initBits = 0x3L;

    private String apiHost;
    private Integer port;
    private Boolean secure;
    private ObjectMapper objectMapper;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.reactor.AbstractRootProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractRootProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code InfoPayloadRootProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InfoPayloadRootProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _InfoPayloadRootProvider} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_InfoPayloadRootProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof AbstractRootProvider) {
        AbstractRootProvider instance = (AbstractRootProvider) object;
        if ((bits & 0x2L) == 0) {
          Optional<Boolean> secureOptional = instance.getSecure();
          if (secureOptional.isPresent()) {
            secure(secureOptional);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          Optional<Integer> portOptional = instance.getPort();
          if (portOptional.isPresent()) {
            port(portOptional);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x1L) == 0) {
          apiHost(instance.getApiHost());
          bits |= 0x1L;
        }
      }
      if (object instanceof org.cloudfoundry.reactor._InfoPayloadRootProvider) {
        org.cloudfoundry.reactor._InfoPayloadRootProvider instance = (org.cloudfoundry.reactor._InfoPayloadRootProvider) object;
        objectMapper(instance.getObjectMapper());
        if ((bits & 0x2L) == 0) {
          Optional<Boolean> secureOptional = instance.getSecure();
          if (secureOptional.isPresent()) {
            secure(secureOptional);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          Optional<Integer> portOptional = instance.getPort();
          if (portOptional.isPresent()) {
            port(portOptional);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x1L) == 0) {
          apiHost(instance.getApiHost());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link InfoPayloadRootProvider#getApiHost() apiHost} attribute.
     * @param apiHost The value for apiHost 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder apiHost(String apiHost) {
      this.apiHost = Objects.requireNonNull(apiHost, "apiHost");
      initBits &= ~INIT_BIT_API_HOST;
      return this;
    }

    /**
     * Initializes the optional value {@link InfoPayloadRootProvider#getPort() port} to port.
     * @param port The value for port
     * @return {@code this} builder for chained invocation
     */
    public final Builder port(int port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the optional value {@link InfoPayloadRootProvider#getPort() port} to port.
     * @param port The value for port
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(Optional<Integer> port) {
      this.port = port.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link InfoPayloadRootProvider#getSecure() secure} to secure.
     * @param secure The value for secure
     * @return {@code this} builder for chained invocation
     */
    public final Builder secure(boolean secure) {
      this.secure = secure;
      return this;
    }

    /**
     * Initializes the optional value {@link InfoPayloadRootProvider#getSecure() secure} to secure.
     * @param secure The value for secure
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder secure(Optional<Boolean> secure) {
      this.secure = secure.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link InfoPayloadRootProvider#getObjectMapper() objectMapper} attribute.
     * @param objectMapper The value for objectMapper 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
      initBits &= ~INIT_BIT_OBJECT_MAPPER;
      return this;
    }

    /**
     * Builds a new {@link InfoPayloadRootProvider InfoPayloadRootProvider}.
     * @return An immutable instance of InfoPayloadRootProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public InfoPayloadRootProvider build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return InfoPayloadRootProvider.validate(new InfoPayloadRootProvider(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_API_HOST) != 0) attributes.add("apiHost");
      if ((initBits & INIT_BIT_OBJECT_MAPPER) != 0) attributes.add("objectMapper");
      return "Cannot build InfoPayloadRootProvider, some of required attributes are not set " + attributes;
    }
  }
}
