/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.HttpClientResponseWithParsedBody;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.QueryBuilder;
import org.cloudfoundry.reactor.client.v3.FilterBuilder;
import org.cloudfoundry.reactor.util.AbstractReactorOperations;
import org.cloudfoundry.reactor.util.DelegatingUriQueryParameterBuilder;
import org.cloudfoundry.reactor.util.ErrorPayloadMappers;
import org.cloudfoundry.reactor.util.MultipartHttpClientRequest;
import org.cloudfoundry.reactor.util.Operator;
import org.cloudfoundry.reactor.util.UriQueryParameter;
import org.cloudfoundry.reactor.util.UriQueryParameterBuilder;
import org.cloudfoundry.reactor.util.UriQueryParameters;
import org.reactivestreams.Publisher;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClientForm;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;

public abstract class AbstractClientV3Operations
extends AbstractReactorOperations {
    protected AbstractClientV3Operations(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    protected static String extractJobId(HttpClientResponse response) {
        String locationHeader = response.responseHeaders().get((CharSequence)HttpHeaderNames.LOCATION);
        if (locationHeader == null) {
            return null;
        }
        List pathSegments = UriComponentsBuilder.fromUriString((String)locationHeader).build().getPathSegments();
        return (String)pathSegments.get(pathSegments.size() - 1);
    }

    @Override
    protected Mono<Operator> createOperator() {
        return super.createOperator().map(this::attachErrorPayloadMapper);
    }

    protected final Mono<String> delete(Object requestPayload, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.delete().uri(this.queryTransformer(requestPayload).andThen(uriTransformer)).send(requestPayload).response().get()).flatMap(response -> Mono.justOrEmpty((Object)AbstractClientV3Operations.extractJobId(response)));
    }

    protected final <T> Mono<T> delete(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.delete().uri(this.queryTransformer(requestPayload).andThen(uriTransformer)).send(requestPayload).response().parseBody(responseType));
    }

    protected final <T> Mono<HttpClientResponseWithParsedBody<T>> deleteWithResponse(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.delete().uri(this.queryTransformer(requestPayload).andThen(uriTransformer)).send(requestPayload).response().parseBodyWithResponse(responseType));
    }

    protected final <T> Flux<T> get(Object requestPayload, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<ByteBufFlux, Flux<T>> bodyTransformer) {
        return this.createOperator().flatMapMany(operator -> operator.followRedirects().get().uri(this.queryTransformer(requestPayload).andThen(uriTransformer)).response().parseBodyToFlux(responseWithBody -> (Flux)bodyTransformer.apply(responseWithBody.getBody())));
    }

    protected final <T> Mono<T> get(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.get().uri(this.queryTransformer(requestPayload).andThen(uriTransformer)).response().parseBody(responseType));
    }

    protected final <T> Mono<T> patch(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.patch().uri(this.queryTransformer(requestPayload).andThen(uriTransformer)).send(requestPayload).response().parseBody(responseType));
    }

    protected final <T> Mono<HttpClientResponseWithParsedBody<T>> patchWithResponse(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.patch().uri(this.queryTransformer(requestPayload).andThen(uriTransformer)).send(requestPayload).response().parseBodyWithResponse(responseType));
    }

    protected final <T> Mono<T> post(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Consumer<MultipartHttpClientRequest> requestTransformer, Runnable onTerminate) {
        return this.createOperator().flatMap(operator -> operator.post().uri(this.queryTransformer(requestPayload).andThen(uriTransformer)).sendForm(this.multipartRequest(requestTransformer)).response().parseBody(responseType)).doFinally(signalType -> onTerminate.run());
    }

    protected <T> Mono<T> post(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.post().uri(this.queryTransformer(requestPayload).andThen(uriTransformer)).send(requestPayload).response().parseBody(responseType));
    }

    protected final Mono<String> post(Object requestPayload, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.post().uri(this.queryTransformer(requestPayload).andThen(uriTransformer)).send(requestPayload).response().get()).flatMap(response -> Mono.justOrEmpty((Object)AbstractClientV3Operations.extractJobId(response)));
    }

    protected <T> Mono<HttpClientResponseWithParsedBody<T>> postRawWithResponse(byte[] requestPayload, String contentType, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.post().uri(this.queryTransformer(requestPayload).andThen(uriTransformer)).send((request, outbound) -> {
            String contentLength = String.valueOf(requestPayload.length);
            Mono body = Mono.just((Object)requestPayload);
            request.header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)contentLength);
            request.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)contentType);
            return outbound.sendByteArray((Publisher)body);
        }).response().parseBodyWithResponse(responseType));
    }

    protected final <T> Mono<HttpClientResponseWithParsedBody<T>> postWithResponse(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.post().uri(this.queryTransformer(requestPayload).andThen(uriTransformer)).send(requestPayload).response().parseBodyWithResponse(responseType));
    }

    protected final <T> Mono<T> put(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.put().uri(this.queryTransformer(requestPayload).andThen(uriTransformer)).send(requestPayload).response().parseBody(responseType));
    }

    private Operator attachErrorPayloadMapper(Operator operator) {
        return operator.withErrorPayloadMapper(ErrorPayloadMappers.clientV3(this.connectionContext.getObjectMapper()));
    }

    private MultipartHttpClientRequest createMultipartRequest(HttpClientRequest request, HttpClientForm form) {
        return new MultipartHttpClientRequest(this.connectionContext.getObjectMapper(), request, form);
    }

    private UriQueryParameterBuilder getUriQueryParameterBuilder() {
        return DelegatingUriQueryParameterBuilder.builder().builders(new FilterBuilder(), new QueryBuilder()).build();
    }

    private BiConsumer<HttpClientRequest, HttpClientForm> multipartRequest(Consumer<MultipartHttpClientRequest> requestTransformer) {
        return (request, outbound) -> {
            MultipartHttpClientRequest multipartRequest = this.createMultipartRequest((HttpClientRequest)request, (HttpClientForm)outbound);
            requestTransformer.accept(multipartRequest);
        };
    }

    private Function<UriComponentsBuilder, UriComponentsBuilder> queryTransformer(Object requestPayload) {
        return builder -> {
            Stream<UriQueryParameter> parameters = this.getUriQueryParameterBuilder().build(requestPayload);
            UriQueryParameters.set(builder, parameters);
            return builder;
        };
    }
}

