/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.tokenprovider;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.reactor.tokenprovider.AbstractUaaTokenProvider;
import org.cloudfoundry.reactor.tokenprovider._PasswordGrantTokenProvider;
import org.immutables.value.Generated;

@Generated(from="_PasswordGrantTokenProvider", generator="Immutables")
public final class PasswordGrantTokenProvider
extends _PasswordGrantTokenProvider {
    private final String clientId;
    private final String clientSecret;
    @Nullable
    private final String identityZoneSubdomain;
    @Nullable
    private final String loginHint;
    private final String password;
    private final String username;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private PasswordGrantTokenProvider(Builder builder) {
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
        this.loginHint = builder.loginHint;
        this.password = builder.password;
        this.username = builder.username;
        if (builder.clientId != null) {
            this.initShim.clientId(builder.clientId);
        }
        if (builder.clientSecret != null) {
            this.initShim.clientSecret(builder.clientSecret);
        }
        this.clientId = this.initShim.getClientId();
        this.clientSecret = this.initShim.getClientSecret();
        this.initShim = null;
    }

    @Override
    public String getClientId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getClientId() : this.clientId;
    }

    @Override
    public String getClientSecret() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getClientSecret() : this.clientSecret;
    }

    @Override
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    @Override
    @Nullable
    public String getLoginHint() {
        return this.loginHint;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PasswordGrantTokenProvider && this.equalTo((PasswordGrantTokenProvider)another);
    }

    private boolean equalTo(PasswordGrantTokenProvider another) {
        return this.clientId.equals(another.clientId) && this.clientSecret.equals(another.clientSecret) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain) && Objects.equals(this.loginHint, another.loginHint) && this.password.equals(another.password) && this.username.equals(another.username);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + this.clientSecret.hashCode();
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        h += (h << 5) + Objects.hashCode(this.loginHint);
        h += (h << 5) + this.password.hashCode();
        h += (h << 5) + this.username.hashCode();
        return h;
    }

    public String toString() {
        return "PasswordGrantTokenProvider{clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", identityZoneSubdomain=" + this.identityZoneSubdomain + ", loginHint=" + this.loginHint + ", password=" + this.password + ", username=" + this.username + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_PasswordGrantTokenProvider", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PASSWORD = 1L;
        private static final long INIT_BIT_USERNAME = 2L;
        private long initBits = 3L;
        private String clientId;
        private String clientSecret;
        private String identityZoneSubdomain;
        private String loginHint;
        private String password;
        private String username;

        private Builder() {
        }

        public final Builder from(PasswordGrantTokenProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_PasswordGrantTokenProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractUaaTokenProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractUaaTokenProvider instance;
            if (object instanceof _PasswordGrantTokenProvider) {
                instance = (_PasswordGrantTokenProvider)object;
                String loginHintValue = ((_PasswordGrantTokenProvider)instance).getLoginHint();
                if (loginHintValue != null) {
                    this.loginHint(loginHintValue);
                }
                this.password(((_PasswordGrantTokenProvider)instance).getPassword());
                this.username(((_PasswordGrantTokenProvider)instance).getUsername());
            }
            if (object instanceof AbstractUaaTokenProvider) {
                instance = (AbstractUaaTokenProvider)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                this.clientSecret(instance.getClientSecret());
                this.clientId(instance.getClientId());
            }
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            return this;
        }

        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public final Builder loginHint(@Nullable String loginHint) {
            this.loginHint = loginHint;
            return this;
        }

        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public PasswordGrantTokenProvider build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new PasswordGrantTokenProvider(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("password");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("username");
            }
            return "Cannot build PasswordGrantTokenProvider, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="_PasswordGrantTokenProvider", generator="Immutables")
    private final class InitShim {
        private byte clientIdBuildStage = 0;
        private String clientId;
        private byte clientSecretBuildStage = 0;
        private String clientSecret;

        private InitShim() {
        }

        String getClientId() {
            if (this.clientIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clientIdBuildStage == 0) {
                this.clientIdBuildStage = (byte)-1;
                this.clientId = Objects.requireNonNull(PasswordGrantTokenProvider.super.getClientId(), "clientId");
                this.clientIdBuildStage = 1;
            }
            return this.clientId;
        }

        void clientId(String clientId) {
            this.clientId = clientId;
            this.clientIdBuildStage = 1;
        }

        String getClientSecret() {
            if (this.clientSecretBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clientSecretBuildStage == 0) {
                this.clientSecretBuildStage = (byte)-1;
                this.clientSecret = Objects.requireNonNull(PasswordGrantTokenProvider.super.getClientSecret(), "clientSecret");
                this.clientSecretBuildStage = 1;
            }
            return this.clientSecret;
        }

        void clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            this.clientSecretBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.clientIdBuildStage == -1) {
                attributes.add("clientId");
            }
            if (this.clientSecretBuildStage == -1) {
                attributes.add("clientSecret");
            }
            return "Cannot build PasswordGrantTokenProvider, attribute initializers form cycle " + attributes;
        }
    }
}

