/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client;

import com.github.zafarkhaja.semver.Version;
import org.cloudfoundry.client.v2.info.GetInfoRequest;
import org.cloudfoundry.client.v2.info.Info;
import org.cloudfoundry.util.tuple.TupleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

final class CloudFoundryClientCompatibilityChecker {
    private final Logger logger = LoggerFactory.getLogger((String)"cloudfoundry-client.compatibility");
    private final Info info;

    CloudFoundryClientCompatibilityChecker(Info info) {
        this.info = info;
    }

    void check() {
        this.info.get(GetInfoRequest.builder().build()).map(response -> Version.valueOf((String)response.getApiVersion())).zipWith(Mono.just((Object)Version.valueOf((String)"2.150.0"))).subscribe(TupleUtils.consumer((server, supported) -> CloudFoundryClientCompatibilityChecker.logCompatibility(server, supported, this.logger)), t -> this.logger.error("An error occurred while checking version compatibility:", t));
    }

    private static void logCompatibility(Version server, Version supported, Logger logger) {
        String message = "Client supports API version {} and is connected to server with API version {}. Things may not work as expected.";
        if (server.greaterThan(supported)) {
            logger.info(message, (Object)supported, (Object)server);
        } else if (server.lessThan(supported)) {
            logger.warn(message, (Object)supported, (Object)server);
        }
    }
}

