package org.cloudfoundry.reactor.doppler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.immutables.value.Generated;
import reactor.core.publisher.Mono;

/**
 * The Reactor-based implementation of {@link DopplerClient}
 */
@Generated(from = "_ReactorDopplerClient", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ReactorDopplerClient extends org.cloudfoundry.reactor.doppler._ReactorDopplerClient {
  private final ConnectionContext connectionContext;
  private transient final ReactorDopplerEndpoints dopplerEndpoints;
  private final Map<String, String> requestTags;
  private final Mono<String> root;
  private final TokenProvider tokenProvider;

  private ReactorDopplerClient(ReactorDopplerClient.Builder builder) {
    this.connectionContext = builder.connectionContext;
    this.tokenProvider = builder.tokenProvider;
    if (builder.requestTagsIsSet()) {
      initShim.requestTags(createUnmodifiableMap(false, false, builder.requestTags));
    }
    if (builder.root != null) {
      initShim.root(builder.root);
    }
    this.dopplerEndpoints = initShim.getDopplerEndpoints();
    this.requestTags = initShim.getRequestTags();
    this.root = initShim.getRoot();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "_ReactorDopplerClient", generator = "Immutables")
  private final class InitShim {
    private byte dopplerEndpointsBuildStage = STAGE_UNINITIALIZED;
    private ReactorDopplerEndpoints dopplerEndpoints;

    ReactorDopplerEndpoints getDopplerEndpoints() {
      if (dopplerEndpointsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dopplerEndpointsBuildStage == STAGE_UNINITIALIZED) {
        dopplerEndpointsBuildStage = STAGE_INITIALIZING;
        this.dopplerEndpoints = Objects.requireNonNull(ReactorDopplerClient.super.getDopplerEndpoints(), "dopplerEndpoints");
        dopplerEndpointsBuildStage = STAGE_INITIALIZED;
      }
      return this.dopplerEndpoints;
    }

    private byte requestTagsBuildStage = STAGE_UNINITIALIZED;
    private Map<String, String> requestTags;

    Map<String, String> getRequestTags() {
      if (requestTagsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (requestTagsBuildStage == STAGE_UNINITIALIZED) {
        requestTagsBuildStage = STAGE_INITIALIZING;
        this.requestTags = createUnmodifiableMap(true, false, ReactorDopplerClient.super.getRequestTags());
        requestTagsBuildStage = STAGE_INITIALIZED;
      }
      return this.requestTags;
    }

    void requestTags(Map<String, String> requestTags) {
      this.requestTags = requestTags;
      requestTagsBuildStage = STAGE_INITIALIZED;
    }

    private byte rootBuildStage = STAGE_UNINITIALIZED;
    private Mono<String> root;

    Mono<String> getRoot() {
      if (rootBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rootBuildStage == STAGE_UNINITIALIZED) {
        rootBuildStage = STAGE_INITIALIZING;
        this.root = Objects.requireNonNull(ReactorDopplerClient.super.getRoot(), "root");
        rootBuildStage = STAGE_INITIALIZED;
      }
      return this.root;
    }

    void root(Mono<String> root) {
      this.root = root;
      rootBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (dopplerEndpointsBuildStage == STAGE_INITIALIZING) attributes.add("dopplerEndpoints");
      if (requestTagsBuildStage == STAGE_INITIALIZING) attributes.add("requestTags");
      if (rootBuildStage == STAGE_INITIALIZING) attributes.add("root");
      return "Cannot build ReactorDopplerClient, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * The connection context
   */
  @Override
  public ConnectionContext getConnectionContext() {
    return connectionContext;
  }

  /**
   * @return The computed-at-construction value of the {@code dopplerEndpoints} attribute
   */
  @Override
  public ReactorDopplerEndpoints getDopplerEndpoints() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDopplerEndpoints()
        : this.dopplerEndpoints;
  }

  /**
   * @return The value of the {@code requestTags} attribute
   */
  @Override
  public Map<String, String> getRequestTags() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRequestTags()
        : this.requestTags;
  }

  /**
   * @return The value of the {@code root} attribute
   */
  @Override
  public Mono<String> getRoot() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRoot()
        : this.root;
  }

  /**
   * The token provider
   */
  @Override
  public TokenProvider getTokenProvider() {
    return tokenProvider;
  }

  /**
   * This instance is equal to all instances of {@code ReactorDopplerClient} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ReactorDopplerClient
        && equalTo((ReactorDopplerClient) another);
  }

  private boolean equalTo(ReactorDopplerClient another) {
    return connectionContext.equals(another.connectionContext)
        && dopplerEndpoints.equals(another.dopplerEndpoints)
        && requestTags.equals(another.requestTags)
        && root.equals(another.root)
        && tokenProvider.equals(another.tokenProvider);
  }

  /**
   * Computes a hash code from attributes: {@code connectionContext}, {@code dopplerEndpoints}, {@code requestTags}, {@code root}, {@code tokenProvider}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + connectionContext.hashCode();
    h += (h << 5) + dopplerEndpoints.hashCode();
    h += (h << 5) + requestTags.hashCode();
    h += (h << 5) + root.hashCode();
    h += (h << 5) + tokenProvider.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ReactorDopplerClient} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReactorDopplerClient{"
        + "connectionContext=" + connectionContext
        + ", dopplerEndpoints=" + dopplerEndpoints
        + ", requestTags=" + requestTags
        + ", root=" + root
        + ", tokenProvider=" + tokenProvider
        + "}";
  }

  /**
   * Creates a builder for {@link ReactorDopplerClient ReactorDopplerClient}.
   * <pre>
   * ReactorDopplerClient.builder()
   *    .connectionContext(org.cloudfoundry.reactor.ConnectionContext) // required {@link ReactorDopplerClient#getConnectionContext() connectionContext}
   *    .requestTag|putAllRequestTags(String =&gt; String) // {@link ReactorDopplerClient#getRequestTags() requestTags} mappings
   *    .root(reactor.core.publisher.Mono&amp;lt;String&amp;gt;) // optional {@link ReactorDopplerClient#getRoot() root}
   *    .tokenProvider(org.cloudfoundry.reactor.TokenProvider) // required {@link ReactorDopplerClient#getTokenProvider() tokenProvider}
   *    .build();
   * </pre>
   * @return A new ReactorDopplerClient builder
   */
  public static ReactorDopplerClient.Builder builder() {
    return new ReactorDopplerClient.Builder();
  }

  /**
   * Builds instances of type {@link ReactorDopplerClient ReactorDopplerClient}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ReactorDopplerClient", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CONNECTION_CONTEXT = 0x1L;
    private static final long INIT_BIT_TOKEN_PROVIDER = 0x2L;
    private static final long OPT_BIT_REQUEST_TAGS = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private ConnectionContext connectionContext;
    private Map<String, String> requestTags = new LinkedHashMap<String, String>();
    private Mono<String> root;
    private TokenProvider tokenProvider;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReactorDopplerClient} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReactorDopplerClient instance) {
      return from((_ReactorDopplerClient) instance);
    }

    /**
     * Copy abstract value type {@code _ReactorDopplerClient} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ReactorDopplerClient instance) {
      Objects.requireNonNull(instance, "instance");
      connectionContext(instance.getConnectionContext());
      putAllRequestTags(instance.getRequestTags());
      root(instance.getRoot());
      tokenProvider(instance.getTokenProvider());
      return this;
    }

    /**
     * Initializes the value for the {@link ReactorDopplerClient#getConnectionContext() connectionContext} attribute.
     * @param connectionContext The value for connectionContext 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectionContext(ConnectionContext connectionContext) {
      this.connectionContext = Objects.requireNonNull(connectionContext, "connectionContext");
      initBits &= ~INIT_BIT_CONNECTION_CONTEXT;
      return this;
    }

    /**
     * Put one entry to the {@link ReactorDopplerClient#getRequestTags() requestTags} map.
     * @param key The key in the requestTags map
     * @param value The associated value in the requestTags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requestTag(String key, String value) {
      this.requestTags.put(
          Objects.requireNonNull(key, "requestTags key"),
          Objects.requireNonNull(value, "requestTags value"));
      optBits |= OPT_BIT_REQUEST_TAGS;
      return this;
    }

    /**
     * Put one entry to the {@link ReactorDopplerClient#getRequestTags() requestTags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requestTag(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.requestTags.put(
          Objects.requireNonNull(k, "requestTags key"),
          Objects.requireNonNull(v, "requestTags value"));
      optBits |= OPT_BIT_REQUEST_TAGS;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ReactorDopplerClient#getRequestTags() requestTags} map. Nulls are not permitted
     * @param entries The entries that will be added to the requestTags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requestTags(Map<String, ? extends String> entries) {
      this.requestTags.clear();
      optBits |= OPT_BIT_REQUEST_TAGS;
      return putAllRequestTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ReactorDopplerClient#getRequestTags() requestTags} map. Nulls are not permitted
     * @param entries The entries that will be added to the requestTags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllRequestTags(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.requestTags.put(
            Objects.requireNonNull(k, "requestTags key"),
            Objects.requireNonNull(v, "requestTags value"));
      }
      optBits |= OPT_BIT_REQUEST_TAGS;
      return this;
    }

    /**
     * Initializes the value for the {@link ReactorDopplerClient#getRoot() root} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ReactorDopplerClient#getRoot() root}.</em>
     * @param root The value for root 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder root(Mono<String> root) {
      this.root = Objects.requireNonNull(root, "root");
      return this;
    }

    /**
     * Initializes the value for the {@link ReactorDopplerClient#getTokenProvider() tokenProvider} attribute.
     * @param tokenProvider The value for tokenProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenProvider(TokenProvider tokenProvider) {
      this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider");
      initBits &= ~INIT_BIT_TOKEN_PROVIDER;
      return this;
    }

    /**
     * Builds a new {@link ReactorDopplerClient ReactorDopplerClient}.
     * @return An immutable instance of ReactorDopplerClient
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ReactorDopplerClient build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ReactorDopplerClient(this);
    }

    private boolean requestTagsIsSet() {
      return (optBits & OPT_BIT_REQUEST_TAGS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONNECTION_CONTEXT) != 0) attributes.add("connectionContext");
      if ((initBits & INIT_BIT_TOKEN_PROVIDER) != 0) attributes.add("tokenProvider");
      return "Cannot build ReactorDopplerClient, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
