/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.cloudfoundry.reactor.HttpClientResponseWithBody;
import org.cloudfoundry.reactor.HttpClientResponseWithConnection;
import org.cloudfoundry.reactor.util.ErrorPayloadMapper;
import org.cloudfoundry.reactor.util.ErrorPayloadMappers;
import org.cloudfoundry.reactor.util.JsonCodec;
import org.cloudfoundry.reactor.util.OperatorContext;
import org.cloudfoundry.reactor.util.OperatorContextAware;
import org.cloudfoundry.reactor.util.RequestLogger;
import org.reactivestreams.Publisher;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.Connection;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientForm;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import reactor.util.retry.Retry;

public class Operator
extends OperatorContextAware {
    private final HttpClient httpClient;

    public Operator(OperatorContext context, HttpClient httpClient) {
        super(context);
        this.httpClient = httpClient;
    }

    public UriConfiguration delete() {
        return this.request(HttpMethod.DELETE);
    }

    public Operator followRedirects() {
        return new Operator(this.context, this.httpClient.followRedirect(true));
    }

    public UriConfiguration get() {
        return this.request(HttpMethod.GET);
    }

    public Operator headers(Consumer<HttpHeaders> headersTransformer) {
        return new Operator(this.context, this.httpClient.headers(headersTransformer));
    }

    public Operator headersWhen(Function<HttpHeaders, Mono<? extends HttpHeaders>> headersWhenTransformer) {
        return new Operator(this.context, this.httpClient.headersWhen(headersWhenTransformer));
    }

    public UriConfiguration patch() {
        return this.request(HttpMethod.PATCH);
    }

    public UriConfiguration post() {
        return this.request(HttpMethod.POST);
    }

    public UriConfiguration put() {
        return this.request(HttpMethod.PUT);
    }

    public UriConfiguration request(HttpMethod method) {
        return new UriConfiguration(this.context, Operator.attachRequestLogger(this.httpClient).request(method));
    }

    public WebsocketUriConfiguration websocket() {
        return new WebsocketUriConfiguration(this.context, this.httpClient.websocket());
    }

    public Operator withErrorPayloadMapper(ErrorPayloadMapper errorPayloadMapper) {
        return new Operator(this.context.withErrorPayloadMapper(errorPayloadMapper), this.httpClient);
    }

    private static HttpClient attachRequestLogger(HttpClient httpClient) {
        RequestLogger requestLogger = new RequestLogger();
        return httpClient.doAfterRequest((request, connection) -> requestLogger.request((HttpClientRequest)request)).doAfterResponseSuccess((response, connection) -> requestLogger.response((HttpClientResponse)response)).doOnResponseError((response, connection) -> requestLogger.response((HttpClientResponse)response));
    }

    public static class WebsocketUriConfiguration
    extends OperatorContextAware {
        private final HttpClient.WebsocketSender sender;

        private WebsocketUriConfiguration(OperatorContext context, HttpClient.WebsocketSender sender) {
            super(context);
            this.sender = sender;
        }

        public WebsocketResponseReceiver uri(Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
            String uri = this.transformRoot(uriTransformer);
            WebsocketUriConfiguration.logWebsocketRequest(uri);
            return new WebsocketResponseReceiver((HttpClient.WebsocketSender)this.sender.uri(uri));
        }

        private static void logWebsocketRequest(String uri) {
            new RequestLogger().websocketRequest(uri);
        }
    }

    public static class WebsocketResponseReceiver {
        private final HttpClient.WebsocketSender sender;

        WebsocketResponseReceiver(HttpClient.WebsocketSender sender) {
            this.sender = sender;
        }

        public Flux<InputStream> get() {
            return this.sender.handle(this::handleWebsocketCommunication);
        }

        private Publisher<InputStream> handleWebsocketCommunication(WebsocketInbound inbound, WebsocketOutbound outbound) {
            return inbound.aggregateFrames().receive().asInputStream().doFinally(signalType -> outbound.sendClose());
        }
    }

    public static class UriConfiguration
    extends OperatorContextAware {
        private final HttpClient.RequestSender requestSender;

        private UriConfiguration(OperatorContext context, HttpClient.RequestSender requestSender) {
            super(context);
            this.requestSender = requestSender;
        }

        public PayloadConfiguration uri(Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
            String uri = this.transformRoot(uriTransformer);
            return new PayloadConfiguration(this.context, (HttpClient.RequestSender)this.requestSender.uri(uri));
        }
    }

    public static class ResponseReceiverConstructor
    extends OperatorContextAware {
        private final HttpClient.ResponseReceiver<?> responseReceiver;

        ResponseReceiverConstructor(OperatorContext context, HttpClient.ResponseReceiver<?> responseReceiver) {
            super(context);
            this.responseReceiver = responseReceiver;
        }

        public ResponseReceiver response() {
            return new ResponseReceiver(this.context, this.responseReceiver);
        }
    }

    public static class ResponseReceiver
    extends OperatorContextAware {
        private final List<Function<HttpClientResponse, ChannelHandler>> channelHandlerBuilders = new ArrayList<Function<HttpClientResponse, ChannelHandler>>();
        private final HttpClient.ResponseReceiver<?> responseReceiver;

        ResponseReceiver(OperatorContext context, HttpClient.ResponseReceiver<?> responseReceiver) {
            super(context);
            this.responseReceiver = responseReceiver;
        }

        public ResponseReceiver addChannelHandler(Function<HttpClientResponse, ChannelHandler> channelHandlerBuilder) {
            this.channelHandlerBuilders.add(channelHandlerBuilder);
            return this;
        }

        public Mono<HttpClientResponse> get() {
            return this.responseReceiver.responseConnection((response, connection) -> Mono.just((Object)HttpClientResponseWithConnection.of(connection, response))).transform(this::processResponse).flatMap(httpClientResponseWithConnection -> {
                Connection connection = httpClientResponseWithConnection.getConnection();
                return ByteBufFlux.fromInbound((Publisher)connection.inbound().receive().doFinally(signalType -> connection.dispose())).then().thenReturn(httpClientResponseWithConnection);
            }).map(HttpClientResponseWithConnection::getResponse).singleOrEmpty();
        }

        public <T> Mono<T> parseBody(Class<T> bodyType) {
            this.addChannelHandler(response -> {
                if (HttpHeaderValues.APPLICATION_JSON.contentEquals((CharSequence)response.responseHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE))) {
                    return JsonCodec.createDecoder();
                }
                return null;
            });
            return this.parseBodyToMono(responseWithBody -> this.deserialized(responseWithBody.getBody(), bodyType));
        }

        public <T> Flux<T> parseBodyToFlux(Function<HttpClientResponseWithBody, Publisher<T>> responseTransformer) {
            return this.responseReceiver.responseConnection((response, connection) -> Mono.just((Object)HttpClientResponseWithConnection.of(connection, response))).transform(this::processResponse).flatMap(httpClientResponseWithConnection -> {
                Connection connection = httpClientResponseWithConnection.getConnection();
                HttpClientResponse response = httpClientResponseWithConnection.getResponse();
                this.attachChannelHandlers(response, connection);
                ByteBufFlux body = ByteBufFlux.fromInbound((Publisher)connection.inbound().receive().doFinally(signalType -> connection.dispose()));
                return Mono.just((Object)HttpClientResponseWithBody.of(body, response));
            }).flatMap(responseTransformer);
        }

        public <T> Mono<T> parseBodyToMono(Function<HttpClientResponseWithBody, Publisher<T>> responseTransformer) {
            return this.parseBodyToFlux(responseTransformer).singleOrEmpty();
        }

        public <T> Mono<T> parseBodyToToken(Function<HttpClientResponseWithBody, Publisher<T>> responseTransformer) {
            return this.responseReceiver.responseConnection((response, connection) -> Mono.just((Object)HttpClientResponseWithConnection.of(connection, response))).transform((Function)this.context.getErrorPayloadMapper().orElse(ErrorPayloadMappers.fallback())).flatMap(httpClientResponseWithConnection -> {
                Connection connection = httpClientResponseWithConnection.getConnection();
                HttpClientResponse response = httpClientResponseWithConnection.getResponse();
                ByteBufFlux body = ByteBufFlux.fromInbound((Publisher)connection.inbound().receive().doFinally(signalType -> connection.dispose()));
                return Mono.just((Object)HttpClientResponseWithBody.of(body, response));
            }).flatMap(responseTransformer).singleOrEmpty();
        }

        private static boolean isUnauthorized(HttpClientResponseWithConnection response) {
            return response.getResponse().status() == HttpResponseStatus.UNAUTHORIZED;
        }

        private void attachChannelHandlers(HttpClientResponse response, Connection connection) {
            for (Function<HttpClientResponse, ChannelHandler> handlerBuilder : this.channelHandlerBuilders) {
                ChannelHandler handler = handlerBuilder.apply(response);
                if (handler == null) continue;
                connection.addHandler(handler);
            }
        }

        private <T> Mono<T> deserialized(ByteBufFlux body, Class<T> bodyType) {
            return JsonCodec.decode(this.context.getConnectionContext().getObjectMapper(), body, bodyType);
        }

        private Flux<HttpClientResponseWithConnection> invalidateToken(Flux<HttpClientResponseWithConnection> inbound) {
            return inbound.doOnNext(response -> {
                if (ResponseReceiver.isUnauthorized(response)) {
                    this.context.getTokenProvider().ifPresent(tokenProvider -> tokenProvider.invalidate(this.context.getConnectionContext()));
                    throw new InvalidTokenException();
                }
            });
        }

        private Flux<HttpClientResponseWithConnection> processResponse(Flux<HttpClientResponseWithConnection> inbound) {
            return inbound.transform(this::invalidateToken).retryWhen((Retry)Retry.max((long)this.context.getConnectionContext().getInvalidTokenRetries()).filter(InvalidTokenException.class::isInstance)).transform((Function)this.context.getErrorPayloadMapper().orElse(ErrorPayloadMappers.fallback()));
        }

        private static final class InvalidTokenException
        extends RuntimeException {
            private static final long serialVersionUID = -3114034909507471614L;

            private InvalidTokenException() {
            }

            @Override
            public synchronized Throwable fillInStackTrace() {
                return null;
            }
        }
    }

    public static class PayloadConfiguration
    extends OperatorContextAware {
        private final HttpClient.RequestSender requestSender;

        PayloadConfiguration(OperatorContext context, HttpClient.RequestSender requestSender) {
            super(context);
            this.requestSender = requestSender;
        }

        public ResponseReceiver response() {
            return new ResponseReceiver(this.context, (HttpClient.ResponseReceiver<?>)this.requestSender);
        }

        public ResponseReceiverConstructor send(Object payload) {
            return this.send(this.serialized(payload));
        }

        public ResponseReceiverConstructor send(BiFunction<HttpClientRequest, NettyOutbound, Publisher<Void>> requestTransformer) {
            HttpClient.ResponseReceiver responseReceiver = this.requestSender.send(requestTransformer);
            return new ResponseReceiverConstructor(this.context, responseReceiver);
        }

        public ResponseReceiverConstructor sendForm(BiConsumer<HttpClientRequest, HttpClientForm> requestTransformer) {
            HttpClient.ResponseReceiver responseReceiver = this.requestSender.sendForm(requestTransformer);
            return new ResponseReceiverConstructor(this.context, responseReceiver);
        }

        private BiFunction<HttpClientRequest, NettyOutbound, Publisher<Void>> serialized(Object payload) {
            return JsonCodec.encode(this.context.getConnectionContext().getObjectMapper(), payload);
        }
    }
}

